/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.support.APTSystemMacroMap;
import org.netbeans.modules.cnd.apt.support.APTIncludePathStorage;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTSystemStorage {
    private final Map<String, APTMacroMap> allMacroMaps = new HashMap<String, APTMacroMap>();
    private final APTIncludePathStorage includesStorage = new APTIncludePathStorage();
    private static final String baseNewName = "#SYSTEM MACRO MAP# ";
    private static final APTSystemStorage instance = new APTSystemStorage();

    private APTSystemStorage() {
    }

    public static APTSystemStorage getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APTMacroMap getMacroMap(List<String> list) {
        Map<String, APTMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            APTSystemMacroMap aPTSystemMacroMap = new APTSystemMacroMap(list);
            for (APTMacroMap aPTMacroMap : this.allMacroMaps.values()) {
                if (!aPTSystemMacroMap.equals(aPTMacroMap)) continue;
                return aPTMacroMap;
            }
            this.allMacroMaps.put(baseNewName + this.allMacroMaps.size(), aPTSystemMacroMap);
            return aPTSystemMacroMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APTMacroMap getMacroMap(String string, List<String> list) {
        Map<String, APTMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            APTMacroMap aPTMacroMap = this.allMacroMaps.get(string);
            if (aPTMacroMap == null) {
                aPTMacroMap = new APTSystemMacroMap(list);
                this.allMacroMaps.put(string, aPTMacroMap);
                if (APTUtils.LOG.isLoggable(Level.FINE)) {
                    APTUtils.LOG.log(Level.FINE, "new system macro map was added\n {0}", new Object[]{aPTMacroMap});
                }
            }
            return aPTMacroMap;
        }
    }

    public List<CharSequence> getIncludes(CharSequence charSequence, List<? extends CharSequence> list) {
        return this.includesStorage.get(charSequence, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<String, APTMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            this.allMacroMaps.clear();
        }
        this.includesStorage.dispose();
    }
}

