/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;

public final class APTFileCacheEntry {
    private final ConcurrentMap<Integer, IncludeData> cache = new ConcurrentHashMap<Integer, IncludeData>();
    private final Map<Integer, Boolean> evalData = new HashMap<Integer, Boolean>();
    private final CharSequence filePath;
    private static volatile int includeHits = 0;
    private static volatile int evalHits = 0;

    public APTFileCacheEntry(CharSequence charSequence) {
        assert (charSequence != null);
        this.filePath = charSequence;
    }

    APTMacroMap.State getPostIncludeMacroState(APTInclude aPTInclude) {
        IncludeData includeData = this.getIncludeData(aPTInclude);
        assert (includeData != null);
        if (includeData.postIncludeMacroState != null && APTTraceFlags.TRACE_APT_CACHE && this.needTraceValue(++includeHits)) {
            System.err.println("INCLUDE HIT " + includeHits + " cache for line:" + aPTInclude.getToken().getLine() + " in " + this.filePath);
        }
        return includeData.postIncludeMacroState;
    }

    void setPostIncludeMacroState(APTInclude aPTInclude, APTMacroMap.State state) {
        IncludeData includeData = this.getIncludeData(aPTInclude);
        assert (includeData.postIncludeMacroState == null);
        includeData.postIncludeMacroState = state;
    }

    Object getIncludeLock(APTInclude aPTInclude) {
        return this.getIncludeData(aPTInclude);
    }

    Boolean getEvalResult(APT aPT) {
        Boolean bl = this.evalData.get(aPT.getOffset());
        if (APTTraceFlags.TRACE_APT_CACHE && bl != null && this.needTraceValue(evalHits++)) {
            System.err.println("EVAL HIT " + evalHits + " cache for line:" + aPT.getToken().getLine() + " as " + bl + " in " + this.filePath);
        }
        return bl;
    }

    void setEvalResult(APT aPT, boolean bl) {
        this.evalData.put(aPT.getOffset(), bl);
    }

    private IncludeData getIncludeData(APTInclude aPTInclude) {
        IncludeData includeData;
        Integer n = aPTInclude.getOffset();
        IncludeData includeData2 = (IncludeData)this.cache.get(n);
        if (includeData2 == null && (includeData = this.cache.putIfAbsent(n, includeData2 = new IncludeData(null))) != null) {
            includeData2 = includeData;
        }
        return includeData2;
    }

    public CharSequence getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return "APT cache for " + this.filePath;
    }

    private boolean needTraceValue(int n) {
        return n % 10 == 0;
    }

    private static final class IncludeData {
        private volatile APTMacroMap.State postIncludeMacroState;

        public IncludeData(APTMacroMap.State state) {
            this.postIncludeMacroState = state;
        }
    }
}

