/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import antlr.TokenStreamException;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTConditionResolver;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public abstract class APTAbstractWalker
extends APTWalker {
    private final APTPreprocHandler preprocHandler;
    private final CharSequence startPath;
    private final APTFileCacheEntry cacheEntry;

    protected APTAbstractWalker(APTFile aPTFile, APTPreprocHandler aPTPreprocHandler, APTFileCacheEntry aPTFileCacheEntry) {
        super(aPTFile, aPTPreprocHandler == null ? null : aPTPreprocHandler.getMacroMap());
        this.startPath = aPTFile.getPath();
        this.preprocHandler = aPTPreprocHandler;
        this.cacheEntry = aPTFileCacheEntry;
    }

    protected void onInclude(APT aPT) {
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver aPTIncludeResolver = this.getIncludeHandler().getResolver(this.startPath);
            ResolvedPath resolvedPath = aPTIncludeResolver.resolveInclude((APTInclude)aPT, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + new File(((Object)this.startPath).toString()).getName() + " for:\n\t" + aPT);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, aPT});
                }
            }
            this.includeImpl(resolvedPath, (APTInclude)aPT);
        }
    }

    protected void onIncludeNext(APT aPT) {
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver aPTIncludeResolver = this.getIncludeHandler().getResolver(this.startPath);
            ResolvedPath resolvedPath = aPTIncludeResolver.resolveIncludeNext((APTIncludeNext)aPT, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + new File(((Object)this.startPath).toString()).getName() + " for:\n\t" + aPT);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, aPT});
                }
            }
            this.includeImpl(resolvedPath, (APTInclude)aPT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeImpl(ResolvedPath resolvedPath, APTInclude aPTInclude) {
        if (this.cacheEntry != null) {
            Object object;
            if (!this.startPath.equals(this.cacheEntry.getFilePath())) {
                System.err.println("using not expected entry " + this.cacheEntry + " when work with file " + this.startPath);
            }
            Object object2 = object = this.cacheEntry.getIncludeLock(aPTInclude);
            synchronized (object2) {
                APTMacroMap.State state = this.cacheEntry.getPostIncludeMacroState(aPTInclude);
                if (state != null && !this.hasIncludeActionSideEffects()) {
                    this.getPreprocHandler().getMacroMap().setState(state);
                    return;
                }
                if (this.include(resolvedPath, aPTInclude, state)) {
                    state = this.getPreprocHandler().getMacroMap().getState();
                    this.cacheEntry.setPostIncludeMacroState(aPTInclude, state);
                }
            }
        } else {
            this.include(resolvedPath, aPTInclude, null);
        }
    }

    protected abstract boolean include(ResolvedPath var1, APTInclude var2, APTMacroMap.State var3);

    protected abstract boolean hasIncludeActionSideEffects();

    protected void onDefine(APT aPT) {
        APTDefine aPTDefine = (APTDefine)aPT;
        if (aPTDefine.isValid()) {
            this.getMacroMap().define(this.getRootFile(), aPTDefine, APTMacro.Kind.DEFINED);
        } else if (DebugUtils.STANDALONE) {
            if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                System.err.println("INCORRECT #define directive: in " + new File(((Object)this.startPath).toString()).getName() + " for:\n\t" + aPT);
            }
        } else {
            APTUtils.LOG.log(Level.SEVERE, "INCORRECT #define directive: in {0} for:\n\t{1}", new Object[]{new File(((Object)this.startPath).toString()).getName(), aPT});
        }
    }

    protected void onUndef(APT aPT) {
        APTUndefine aPTUndefine = (APTUndefine)aPT;
        this.getMacroMap().undef(this.getRootFile(), aPTUndefine.getName());
    }

    protected boolean onIf(APT aPT) {
        return this.eval(aPT);
    }

    protected boolean onIfdef(APT aPT) {
        return this.eval(aPT);
    }

    protected boolean onIfndef(APT aPT) {
        return this.eval(aPT);
    }

    protected boolean onElif(APT aPT, boolean bl) {
        return !bl && this.eval(aPT);
    }

    protected boolean onElse(APT aPT, boolean bl) {
        return !bl;
    }

    protected void onEndif(APT aPT, boolean bl) {
    }

    protected void onEval(APT aPT, boolean bl) {
    }

    protected APTPreprocHandler getPreprocHandler() {
        return this.preprocHandler;
    }

    protected APTIncludeHandler getIncludeHandler() {
        return this.getPreprocHandler() == null ? null : this.getPreprocHandler().getIncludeHandler();
    }

    private boolean eval(APT aPT) {
        if (APTUtils.LOG.isLoggable(Level.FINE)) {
            APTUtils.LOG.log(Level.FINE, "eval condition for {0}", new Object[]{aPT});
        }
        boolean bl = false;
        try {
            Boolean bl2;
            Boolean bl3 = bl2 = this.cacheEntry != null ? this.cacheEntry.getEvalResult(aPT) : null;
            if (bl2 != null) {
                bl = bl2;
            } else {
                bl = APTConditionResolver.evaluate(aPT, (APTMacroCallback)this.getMacroMap());
                if (this.cacheEntry != null) {
                    this.cacheEntry.setEvalResult(aPT, bl);
                }
            }
        }
        catch (TokenStreamException tokenStreamException) {
            APTUtils.LOG.log(Level.SEVERE, "error on evaluating condition node {0}\n{1}", new Object[]{aPT, tokenStreamException});
        }
        this.onEval(aPT, bl);
        return bl;
    }
}

