/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.TokenStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.cnd.utils.cache.TinyCharSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTMacroMapSnapshot {
    private final Map<CharSequence, APTMacro> macros = new HashMap<CharSequence, APTMacro>(2);
    final APTMacroMapSnapshot parent;
    public static final APTMacro UNDEFINED_MACRO = new UndefinedMacro();

    public APTMacroMapSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot) {
        assert (aPTMacroMapSnapshot == null || aPTMacroMapSnapshot.parent == null || !aPTMacroMapSnapshot.parent.isEmtpy()) : "how grand father could be empty " + aPTMacroMapSnapshot;
        while (aPTMacroMapSnapshot != null && aPTMacroMapSnapshot.isEmtpy()) {
            aPTMacroMapSnapshot = aPTMacroMapSnapshot.parent;
        }
        this.parent = aPTMacroMapSnapshot;
    }

    final Map<CharSequence, APTMacro> getMacros() {
        return this.macros;
    }

    public final APTMacro getMacro(APTToken aPTToken) {
        return this.getMacro(aPTToken.getTextID());
    }

    final APTMacro getMacro(CharSequence charSequence) {
        assert (charSequence instanceof TinyCharSequence) : "string can't be here " + charSequence;
        APTMacroMapSnapshot aPTMacroMapSnapshot = this;
        while (aPTMacroMapSnapshot != null) {
            APTMacro aPTMacro = aPTMacroMapSnapshot.macros.get(charSequence);
            if (aPTMacro != null) {
                return aPTMacro;
            }
            aPTMacroMapSnapshot = aPTMacroMapSnapshot.parent;
        }
        return null;
    }

    public String toString() {
        HashMap<CharSequence, APTMacro> hashMap = new HashMap<CharSequence, APTMacro>();
        APTMacroMapSnapshot.addAllMacros(this, hashMap);
        return APTUtils.macros2String(hashMap);
    }

    public static void addAllMacros(APTMacroMapSnapshot aPTMacroMapSnapshot, Map<CharSequence, APTMacro> map) {
        if (aPTMacroMapSnapshot != null) {
            if (aPTMacroMapSnapshot.parent != null) {
                APTMacroMapSnapshot.addAllMacros(aPTMacroMapSnapshot.parent, map);
            }
            for (Map.Entry<CharSequence, APTMacro> entry : aPTMacroMapSnapshot.macros.entrySet()) {
                if (entry.getValue() != UNDEFINED_MACRO) {
                    map.put(entry.getKey(), entry.getValue());
                    continue;
                }
                map.remove(entry.getKey());
            }
        }
    }

    public static int getMacroSize(APTMacroMapSnapshot aPTMacroMapSnapshot) {
        int n = 0;
        while (aPTMacroMapSnapshot != null) {
            n += aPTMacroMapSnapshot.macros.size();
            aPTMacroMapSnapshot = aPTMacroMapSnapshot.parent;
        }
        return n;
    }

    public boolean isEmtpy() {
        return this.macros.isEmpty();
    }

    public void write(DataOutput dataOutput) throws IOException {
        APTSerializeUtils.writeSnapshot(this.parent, dataOutput);
        APTSerializeUtils.writeStringToMacroMap(this.macros, dataOutput);
    }

    public APTMacroMapSnapshot(DataInput dataInput) throws IOException {
        this.parent = APTSerializeUtils.readSnapshot(dataInput);
        APTSerializeUtils.readStringToMacroMap(this.macros, dataInput);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UndefinedMacro
    implements APTMacro {
        private UndefinedMacro() {
        }

        public String toString() {
            return "Macro undefined";
        }

        @Override
        public CharSequence getFile() {
            return CharSequenceKey.empty();
        }

        @Override
        public APTMacro.Kind getKind() {
            return APTMacro.Kind.USER_SPECIFIED;
        }

        @Override
        public boolean isFunctionLike() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTToken getName() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public Collection<APTToken> getParams() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public TokenStream getBody() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTDefine getDefineNode() {
            throw new UnsupportedOperationException("Not supported in fake impl.");
        }
    }
}

