/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import org.netbeans.modules.cnd.apt.impl.structure.APTContainerNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class APTFileNode
extends APTContainerNode
implements APTFile,
Serializable {
    private static final long serialVersionUID = -6182803432699849825L;
    private final CharSequence path;
    private transient boolean tokenized;

    APTFileNode(APTFileNode aPTFileNode) {
        super(aPTFileNode);
        this.path = aPTFileNode.path;
        this.tokenized = false;
    }

    public APTFileNode(CharSequence charSequence) {
        this.path = FilePathCache.getManager().getString(charSequence);
        this.tokenized = true;
    }

    public final int getType() {
        return 1;
    }

    public int getOffset() {
        return -1;
    }

    public int getEndOffset() {
        return -1;
    }

    public APT getNextSibling() {
        return null;
    }

    public String getText() {
        return "FILE:{" + this.getPath() + "}";
    }

    public CharSequence getPath() {
        return this.path;
    }

    public void dispose() {
        if (this.isTokenized()) {
            new CleanTokensWalker(this).visit();
            this.tokenized = false;
        }
    }

    public boolean isTokenized() {
        return this.tokenized;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof APTFileNode)) {
            return false;
        }
        APTFileNode aPTFileNode = (APTFileNode)object;
        return this.path.equals(aPTFileNode.path);
    }

    public int hashCode() {
        int n = 5;
        n = 41 * n + this.path.hashCode();
        return n;
    }

    public final void setNextSibling(APT aPT) {
        assert (false) : "Illegal to add siblings to file node";
    }

    private static class CleanTokensWalker
    extends APTWalker {
        public CleanTokensWalker(APTFileNode aPTFileNode) {
            super(aPTFileNode, null);
        }

        protected void onInclude(APT aPT) {
        }

        protected void onIncludeNext(APT aPT) {
        }

        protected void onDefine(APT aPT) {
        }

        protected void onUndef(APT aPT) {
        }

        protected boolean onIf(APT aPT) {
            return true;
        }

        protected boolean onIfdef(APT aPT) {
            return true;
        }

        protected boolean onIfndef(APT aPT) {
            return true;
        }

        protected boolean onElif(APT aPT, boolean bl) {
            return true;
        }

        protected boolean onElse(APT aPT, boolean bl) {
            return true;
        }

        protected void onEndif(APT aPT, boolean bl) {
        }

        protected void onStreamNode(APT aPT) {
            aPT.dispose();
        }

        protected void onOtherNode(APT aPT) {
            aPT.dispose();
        }
    }
}

