/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.gsf.codecoverage.CoverageBar;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CoverageSideBar
extends JPanel {
    private static final String COVERAGE_SIDEBAR_PROP = "coverageSideBar";
    private Document document;
    private boolean enabled;
    private JButton allTestsButton;
    private JButton clearButton;
    private CoverageBar coverageBar;
    private JButton jButton1;
    private JLabel label;
    private JButton reportButton;
    private JButton testButton;
    private JLabel warningsLabel;

    public CoverageSideBar(JTextComponent jTextComponent) {
        CoverageManagerImpl coverageManagerImpl;
        this.document = jTextComponent.getDocument();
        String string = (String)this.document.getProperty("mimeType");
        boolean bl = false;
        if (string != null && (bl = (coverageManagerImpl = CoverageManagerImpl.getInstance()).isEnabled(string))) {
            CoverageProvider coverageProvider = this.getProvider();
            bl = coverageProvider != null ? coverageProvider.isEnabled() && coverageManagerImpl.getShowEditorBar() : false;
        }
        if (bl) {
            this.showCoveragePanel(true);
        } else {
            this.updatePreferredSize();
        }
        this.document.putProperty(COVERAGE_SIDEBAR_PROP, this);
    }

    public static CoverageSideBar getSideBar(Document document) {
        return (CoverageSideBar)document.getProperty(COVERAGE_SIDEBAR_PROP);
    }

    public void setCoverage(FileCoverageDetails fileCoverageDetails) {
        if (fileCoverageDetails != null) {
            FileCoverageSummary fileCoverageSummary = fileCoverageDetails.getSummary();
            float f = fileCoverageSummary.getCoveragePercentage();
            if ((double)f >= 0.0) {
                this.coverageBar.setCoveragePercentage(f);
            }
            long l = fileCoverageDetails.lastUpdated();
            FileObject fileObject = fileCoverageDetails.getFile();
            boolean bl = false;
            if (fileObject != null && l > 0L && l < fileObject.lastModified().getTime()) {
                bl = true;
            } else if (fileObject != null && fileObject.isValid()) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    bl = dataObject.isModified();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            if (bl) {
                this.warningsLabel.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"DataTooOld"));
            } else {
                this.warningsLabel.setText("");
            }
        } else {
            this.coverageBar.setCoveragePercentage(0.0f);
            this.warningsLabel.setText("");
        }
    }

    public boolean isShowingCoverage() {
        return this.enabled;
    }

    public void showCoveragePanel(boolean bl) {
        if (bl == this.enabled) {
            return;
        }
        this.enabled = bl;
        if (bl) {
            this.initComponents();
            this.setCoverage(null);
        } else {
            this.removeAll();
        }
        this.updatePreferredSize();
        this.revalidate();
        this.repaint();
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.setPreferredSize(null);
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(dimension);
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.coverageBar = new CoverageBar();
        this.warningsLabel = new JLabel();
        this.testButton = new JButton();
        this.allTestsButton = new JButton();
        this.clearButton = new JButton();
        this.reportButton = new JButton();
        this.jButton1 = new JButton();
        this.label.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.label.text"));
        this.coverageBar.setMinimumSize(new Dimension(40, 10));
        this.warningsLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.testButton.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.testButton.text"));
        this.testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageSideBar.this.testOne(actionEvent);
            }
        });
        this.allTestsButton.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.allTestsButton.text"));
        this.allTestsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageSideBar.this.allTests(actionEvent);
            }
        });
        this.clearButton.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.clearButton.text"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageSideBar.this.clearResults(actionEvent);
            }
        });
        this.reportButton.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.reportButton.text"));
        this.reportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageSideBar.this.report(actionEvent);
            }
        });
        this.jButton1.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageSideBar.this.done(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0).add((Component)this.coverageBar, -2, -1, -2).addPreferredGap(0, 86, Short.MAX_VALUE).add((Component)this.warningsLabel).addPreferredGap(0).add((Component)this.testButton).addPreferredGap(0).add((Component)this.allTestsButton).addPreferredGap(0).add((Component)this.clearButton).addPreferredGap(0).add((Component)this.reportButton).addPreferredGap(0).add((Component)this.jButton1)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.label).add((Component)this.coverageBar, -2, -1, -2).add((Component)this.jButton1).add((Component)this.reportButton).add((Component)this.clearButton).add((Component)this.allTestsButton).add((Component)this.testButton).add((Component)this.warningsLabel)));
    }

    private void clearResults(ActionEvent actionEvent) {
        Project project = this.getProject();
        if (project != null) {
            CoverageManagerImpl.getInstance().clear(project);
        }
    }

    private void allTests(ActionEvent actionEvent) {
        String string = "test";
        CoverageProvider coverageProvider = this.getProvider();
        if (coverageProvider != null && coverageProvider.getTestAllAction() != null) {
            string = coverageProvider.getTestAllAction();
        }
        this.runAction(string);
    }

    private void testOne(ActionEvent actionEvent) {
        this.runAction("test.single");
    }

    private void report(ActionEvent actionEvent) {
        Project project = this.getProject();
        if (project != null) {
            CoverageManagerImpl.getInstance().showReport(project);
        }
    }

    private void done(ActionEvent actionEvent) {
        Project project = this.getProject();
        if (project != null) {
            CoverageManagerImpl.getInstance().setEnabled(project, false);
        }
        this.showCoveragePanel(false);
    }

    private void runAction(String string) {
        Project project = this.getProject();
        if (project != null) {
            DataObject dataObject;
            Lookup lookup = project.getLookup();
            FileObject fileObject = GsfUtilities.findFileObject((Document)this.document);
            if (fileObject != null) {
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                    lookup = dataObject.getLookup();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            if ((dataObject = (ActionProvider)project.getLookup().lookup(ActionProvider.class)) != null && dataObject.isActionEnabled(string, lookup)) {
                dataObject.invokeAction(string, lookup);
            }
        }
    }

    private Project getProject() {
        FileObject fileObject = GsfUtilities.findFileObject((Document)this.document);
        if (fileObject != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            return project;
        }
        return null;
    }

    private CoverageProvider getProvider() {
        Project project = this.getProject();
        if (project != null) {
            return CoverageManagerImpl.getProvider(project);
        }
        return null;
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent jTextComponent) {
            return new CoverageSideBar(jTextComponent);
        }
    }
}

