/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class CoverageBar
extends JComponent {
    private static final Color NOT_COVERED_LIGHT = new Color(255, 160, 160);
    private static final Color NOT_COVERED_DARK = new Color(180, 50, 50);
    private static final Color COVERED_LIGHT = new Color(160, 255, 160);
    private static final Color COVERED_DARK = new Color(30, 180, 30);
    private boolean emphasize;
    private boolean selected;
    private float coveragePercentage;
    private BufferedImage textImage;
    private BufferedImage dropShadowImage;
    private static final Color TEXT_BLUR_COLOR = Color.WHITE;
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final int KERNEL_SIZE = 3;
    private static final float BLUR_FACTOR = 0.1f;
    private static final int SHIFT_X = 0;
    private static final int SHIFT_Y = 1;
    private ConvolveOp blur;

    public CoverageBar() {
        this.updateUI();
    }

    public float getCoveragePercentage() {
        return this.coveragePercentage;
    }

    public void setCoveragePercentage(float f) {
        this.coveragePercentage = f;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isEmphasize() {
        return this.emphasize;
    }

    public void setEmphasize(boolean bl) {
        this.emphasize = bl;
    }

    private String getString() {
        return String.format("%.1f %%", Float.valueOf(this.coveragePercentage));
    }

    public boolean isOpaque() {
        return true;
    }

    public void updateUI() {
        Font font = new JLabel().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        this.setFont(font);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Map map;
        Map map2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Map map3 = map = map2 instanceof Map ? map2 : null;
        if (map != null && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(map);
            try {
                super.paint(graphics2D);
            }
            finally {
                graphics2D.setRenderingHints(renderingHints);
            }
        } else {
            super.paint(graphics);
        }
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = (int)((float)n3 * this.coveragePercentage / 100.0f);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.getBackground());
        Color color = NOT_COVERED_LIGHT;
        Color color2 = NOT_COVERED_DARK;
        Color color3 = COVERED_LIGHT;
        Color color4 = COVERED_DARK;
        if (this.emphasize) {
            color4 = color4.darker();
        } else if (this.selected) {
            color3 = color3.brighter();
            color4 = color4.darker();
        }
        if (this.emphasize) {
            color2 = color2.darker();
        } else if (this.selected) {
            color = color.brighter();
            color2 = color2.darker();
        }
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, n / 2, color2));
        graphics2D.fillRect(n5, 1, n2 - 1, n / 2);
        graphics2D.setPaint(new GradientPaint(0.0f, n / 2, color2, 0.0f, 2 * n, color));
        graphics2D.fillRect(n5, n / 2, n2 - 1, n / 2);
        graphics2D.setColor(this.getForeground());
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color3, 0.0f, n / 2, color4));
        graphics2D.fillRect(1, 1, n5, n / 2);
        graphics2D.setPaint(new GradientPaint(0.0f, n / 2, color4, 0.0f, 2 * n, color3));
        graphics2D.fillRect(1, n / 2, n5, n / 2);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.coveragePercentage > 0.0f) {
            graphics2D.setColor(color4);
            graphics2D.clipRect(0, 0, n5 + 1, n);
            graphics2D.drawRect(0, 0, n2 - 1, n - 1);
        }
        if (this.coveragePercentage < 100.0f) {
            graphics2D.setColor(color2);
            graphics2D.setClip(rectangle);
            graphics2D.clipRect(n5, 0, n2, n);
            graphics2D.drawRect(0, 0, n2 - 1, n - 1);
        }
        graphics2D.setClip(rectangle);
        graphics2D.setFont(this.getFont());
        this.paintDropShadowText(graphics2D, n3, n4);
    }

    public Dimension getPreferredSize() {
        int n;
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = new Dimension(146, 12);
        String string = this.getString();
        int n2 = fontMetrics.stringWidth(string);
        if (n2 > dimension.width) {
            dimension.width = n2;
        }
        if ((n = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
            dimension.height = n;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = 40;
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    public int getBaseline(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return n2 - fontMetrics.getDescent() - (n2 - fontMetrics.getHeight()) / 2;
    }

    private void paintDropShadowText(Graphics graphics, int n, int n2) {
        if (this.textImage == null) {
            this.textImage = new BufferedImage(n, n2, 2);
            this.dropShadowImage = new BufferedImage(n, n2, 2);
        }
        Graphics2D graphics2D = this.textImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setColor(TEXT_BLUR_COLOR);
        this.paintText(graphics2D, n, n2);
        graphics2D.dispose();
        Graphics2D graphics2D2 = this.dropShadowImage.createGraphics();
        graphics2D2.setComposite(AlphaComposite.Clear);
        graphics2D2.fillRect(0, 0, n, n2);
        graphics2D2.setComposite(AlphaComposite.SrcOver);
        if (this.blur == null) {
            int n3 = 3;
            int n4 = 3;
            float f = 0.1f;
            float[] fArray = new float[n3 * n4];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f;
            }
            this.blur = new ConvolveOp(new Kernel(n3, n4, fArray));
        }
        graphics2D2.drawImage(this.textImage, this.blur, 0, 1);
        if (this.emphasize) {
            graphics2D2.setColor(Color.YELLOW);
        } else {
            graphics2D2.setColor(TEXT_COLOR);
        }
        graphics2D2.setFont(this.getFont());
        this.paintText(graphics2D2, n, n2);
        graphics2D2.dispose();
        graphics.drawImage(this.dropShadowImage, 0, 0, null);
    }

    private void paintText(Graphics graphics, int n, int n2) {
        graphics.setFont(this.getFont());
        String string = this.getString();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        graphics.drawString(string, (n - n3) / 2, n2 - fontMetrics.getDescent() - (n2 - fontMetrics.getHeight()) / 2);
    }
}

