/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.impl;

import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.web.client.tools.common.dbgp.HttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSHttpProgress
implements JSHttpMessage {
    private final String id;
    private final String timeStamp;
    private final int current;
    private final int max;
    private final int total;
    private final int maxTotal;
    private final Map<String, String> headerData;
    private final String status;
    private final String mimeType;
    private final String responseText;
    private final String category;

    public JSHttpProgress(HttpMessage httpMessage) {
        this.id = httpMessage.getId();
        assert (this.id != null);
        this.timeStamp = httpMessage.getTimeStamp();
        this.current = Integer.parseInt(httpMessage.getChildValue("current"));
        this.max = Integer.parseInt(httpMessage.getChildValue("max"));
        this.total = Integer.parseInt(httpMessage.getChildValue("total"));
        this.maxTotal = Integer.parseInt(httpMessage.getChildValue("maxTotal"));
        this.headerData = Collections.unmodifiableMap(httpMessage.getHeader());
        this.status = httpMessage.getChildValue("status");
        this.mimeType = httpMessage.getChildValue("mimeType");
        this.responseText = httpMessage.getResponseText();
        this.category = httpMessage.getChildValue("category");
    }

    public String getCategory() {
        return this.category;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public static final JSHttpMessage.Type getType() {
        return JSHttpMessage.Type.PROGRESS;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTimeStamp() {
        return this.timeStamp;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getMax() {
        return this.max;
    }

    public int getTotal() {
        return this.total;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public Map<String, String> getHeader() {
        return Collections.unmodifiableMap(this.headerData);
    }

    public String getStatus() {
        return this.status;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

