/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.util.logging.Level;
import org.netbeans.modules.web.client.tools.common.dbgp.BaseMessageChildElement;
import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.Log;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.w3c.dom.Node;

public class Status {

    public static class DebugMessage
    extends BaseMessageChildElement {
        static final String TAG = "message";

        DebugMessage(Node node) {
            super(node);
        }

        public String getFileName() {
            return this.getAttribute("filename");
        }

        public int getLineNumber() {
            return this.getInt("lineno");
        }

        public String getBreakpointId() {
            return this.getAttribute("id");
        }
    }

    public static class StatusResponse
    extends ResponseMessage {
        private static final String REASON = "reason";
        private static final String STATUS = "status";

        StatusResponse(Node node) {
            super(node);
        }

        public State getState() {
            String string = StatusResponse.getAttribute(this.getNode(), STATUS);
            try {
                return State.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.getLogger().log(Level.FINE, "Unknown status: " + string);
                return State.UNKNOWN;
            }
        }

        public Reason getReason() {
            String string = StatusResponse.getAttribute(this.getNode(), REASON);
            try {
                return Reason.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.getLogger().log(Level.FINE, "Unknown reason: " + string);
                return Reason.UNKNOWN;
            }
        }

        public DebugMessage getDebugMessage() {
            return new DebugMessage(StatusResponse.getChild(this.getNode(), "message"));
        }
    }

    public static class StatusCommand
    extends Command {
        public StatusCommand(int n) {
            super(CommandMap.STATUS.getCommand(), n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        OK,
        ERROR,
        ABORTED,
        EXCEPTION,
        UNKNOWN;


        public String getReason() {
            return this.name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        STARTING,
        STOPPING,
        STOPPED,
        RUNNING,
        FIRST_LINE,
        BREAKPOINT,
        STEP,
        DEBUGGER,
        EXCEPTION,
        UNKNOWN;


        public String getState() {
            return this.name().toLowerCase();
        }
    }
}

