/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class Utils {
    private static final int WAIT_FINISHED_TIMEOUT = 10000;

    public static boolean replaceDocument(final StyledDocument styledDocument, final String string) {
        if (styledDocument == null) {
            return true;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    int n;
                    int n2;
                    String string4 = Utils.filterEndLines(styledDocument.getText(0, styledDocument.getLength()));
                    String string2 = Utils.filterEndLines(string);
                    if (string4.equals(string2)) {
                        return;
                    }
                    char[] cArray = string4.toCharArray();
                    char[] cArray2 = string2.toCharArray();
                    int n3 = cArray2.length - (n2 = cArray.length);
                    int n4 = n3 < 0 ? n2 + n3 : n2;
                    for (n = 0; n < n4 && cArray[n] == cArray2[n]; ++n) {
                    }
                    n4 = n3 < 0 ? n - n3 : n;
                    int n5 = n2 - 1;
                    while (n5 >= n4 && cArray[n5] == cArray2[n5 + n3]) {
                        n2 = n5--;
                    }
                    String string3 = string2.substring(n, n2 + n3);
                    int n6 = n2 - n;
                    if (styledDocument instanceof AbstractDocument) {
                        ((AbstractDocument)((Object)styledDocument)).replace(n, n6, string3, null);
                    } else {
                        if (n6 > 0) {
                            styledDocument.remove(n, n6);
                        }
                        if (string3.length() > 0) {
                            styledDocument.insertString(n, string3, null);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        };
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
        return true;
    }

    private static String filterEndLines(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            return "";
        }
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\r') continue;
            if (n != i) {
                cArray[n] = c;
            }
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public static void focusNextComponent(Component component) {
        Container container = component.getFocusCycleRootAncestor();
        if (container == null) {
            return;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy == null) {
            return;
        }
        Component component2 = focusTraversalPolicy.getComponentAfter(container, component);
        if (component2 != null) {
            component2.requestFocus();
        }
    }

    public static void scrollToVisible(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jComponent.scrollRectToVisible(new Rectangle(10, jComponent.getHeight()));
            }
        });
    }

    public static void runInAwtDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void makeTextAreaLikeTextField(JTextArea jTextArea, JTextField jTextField) {
        jTextArea.setBorder(jTextField.getBorder());
        jTextArea.setFocusTraversalKeys(0, jTextField.getFocusTraversalKeys(0));
        jTextArea.setFocusTraversalKeys(1, jTextField.getFocusTraversalKeys(1));
    }

    public static void waitFinished(RequestProcessor.Task task) {
        if (task.getDelay() > 0 && !task.isFinished()) {
            try {
                task.waitFinished(10000L);
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.getDefault().notify((Throwable)interruptedException);
            }
        }
    }
}

