/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddPushRegistryPanel;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.MIDletScanner;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomizerPushReg
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener,
ChangeListener,
TableModelListener {
    static final long serialVersionUID = 1191422396924194938L;
    static final String[] PROPERTY_GROUP = new String[]{"manifest.pushregistry"};
    protected final JTable table;
    protected final StorableTableModel tableModel;
    private final DefaultComboBoxModel cbmClassesForAdd = new DefaultComboBoxModel();
    private VisualPropertySupport vps;
    private String configuration;
    private String configurationProfileValue;
    private String defaultProfileValue;
    protected HashSet<String> classes;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bMoveDown;
    private JButton bMoveUp;
    private JButton bRemove;
    private JCheckBox cDefault;
    private ErrorPanel errorPanel;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerPushReg() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.tableModel.addTableModelListener(this);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(200);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setForeground(bl ? jTable.getSelectionForeground() : (n2 == 0 && CustomizerPushReg.this.classes != null && !CustomizerPushReg.this.classes.contains(object) ? Color.RED : jTable.getForeground()));
                return component;
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    CustomizerPushReg.this.bEditActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.bMoveUp = new JButton();
        this.bMoveDown = new JButton();
        this.errorPanel = new ErrorPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Table"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPushReg.this.bAddActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Edit"));
        this.bEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPushReg.this.bEditActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Remove"));
        this.bRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPushReg.this.bRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bMoveUp, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_MoveUp"));
        this.bMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPushReg.this.bMoveUpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.bMoveUp, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bMoveDown, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_MoveDown"));
        this.bMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPushReg.this.bMoveDownActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.bMoveDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPushReg.class, (String)"ACSN_Push"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPushReg.class, (String)"ACSD_Push"));
    }

    private void bEditActionPerformed(ActionEvent actionEvent) {
        final int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        final AddPushRegistryPanel addPushRegistryPanel = new AddPushRegistryPanel(this.cbmClassesForAdd, (String)this.tableModel.getValueAt(n, 0), (String)this.tableModel.getValueAt(n, 1), (String)this.tableModel.getValueAt(n, 2));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addPushRegistryPanel, NbBundle.getMessage(CustomizerPushReg.class, (String)"TITLE_EditPush"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    CustomizerPushReg.this.tableModel.setRow(n, addPushRegistryPanel.getClazz(), addPushRegistryPanel.getSender(), addPushRegistryPanel.getString());
                    CustomizerPushReg.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        addPushRegistryPanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void bAddActionPerformed(ActionEvent actionEvent) {
        final AddPushRegistryPanel addPushRegistryPanel = new AddPushRegistryPanel(this.cbmClassesForAdd);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addPushRegistryPanel, NbBundle.getMessage(CustomizerPushReg.class, (String)"TITLE_AddPush"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    int n = CustomizerPushReg.this.tableModel.addRow(addPushRegistryPanel.getClazz(), addPushRegistryPanel.getSender(), addPushRegistryPanel.getString());
                    CustomizerPushReg.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        addPushRegistryPanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void bMoveDownActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n >= this.tableModel.getRowCount() - 1) {
            return;
        }
        this.tableModel.moveDown(n);
        this.table.getSelectionModel().setSelectionInterval(++n, n);
    }

    private void bMoveUpActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n <= 0) {
            return;
        }
        this.tableModel.moveUp(n);
        this.table.getSelectionModel().setSelectionInterval(--n, n);
    }

    private void bRemoveActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.tableModel.removeRow(n);
        int n2 = this.tableModel.getRowCount();
        if (n2 <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (n < n2) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        } else {
            this.table.getSelectionModel().setSelectionInterval(n2 - 1, n2 - 1);
        }
    }

    public void initValues(ProjectProperties projectProperties, String string) {
        this.configuration = string;
        this.configurationProfileValue = (String)projectProperties.get(VisualPropertySupport.translatePropertyName(string, "platform.profile", false));
        this.defaultProfileValue = (String)projectProperties.get("platform.profile");
        this.configuration = string;
        this.classes = null;
        MIDletScanner mIDletScanner = MIDletScanner.getDefault(projectProperties);
        mIDletScanner.scan(this.cbmClassesForAdd, null, string, this);
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.vps.register(this.cDefault, string, this);
    }

    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    private boolean isMIDP10() {
        String string = null;
        if (this.configuration != null) {
            string = this.configurationProfileValue;
        }
        if (string == null) {
            string = this.defaultProfileValue;
        }
        return string != null && string.equals("MIDP-1.0");
    }

    public void initGroupValues(boolean bl) {
        this.vps.register(this.tableModel, new String[]{"manifest.pushregistry"}, bl);
        this.bAdd.setEnabled(!bl);
        this.bEdit.setEnabled(!bl);
        this.bRemove.setEnabled(!bl);
        this.table.setEnabled(!bl);
        this.lTable.setEnabled(!bl);
        this.table.setBackground(UIManager.getDefaults().getColor(bl ? "TextField.inactiveBackground" : "Table.background"));
        this.valueChanged(null);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.classes != null && !this.classes.containsAll(this.tableModel.getClasses())) {
            this.errorPanel.setErrorBundleMessage("ERR_CustMIDlets_WrongMIDlets");
        } else {
            this.errorPanel.setErrorBundleMessage(this.isMIDP10() ? "ERR_Push_NotUsed" : null);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.table.isEnabled() && this.table.getSelectedRow() >= 0;
        this.bEdit.setEnabled(bl);
        this.bRemove.setEnabled(bl);
        this.bMoveUp.setEnabled(bl && this.table.getSelectedRow() > 0);
        this.bMoveDown.setEnabled(bl && this.table.getSelectedRow() < this.tableModel.getRowCount() - 1);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.classes = new HashSet();
        for (int i = 0; i < this.cbmClassesForAdd.getSize(); ++i) {
            this.classes.add((String)this.cbmClassesForAdd.getElementAt(i));
        }
        this.tableModel.fireTableDataChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        public static final String PREFIX = "MIDlet-Push-";
        private static final int[] COLUMN_MAP = new int[]{1, 2, 0};
        private HashMap<String, String> map = new HashMap();
        private int rows = 0;
        private static final long serialVersionUID = 920375326055211848L;

        private StorableTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        public Set<String> getClasses() {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                hashSet.add((String)this.getValueAt(i, 0));
            }
            return hashSet;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Column_Class");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Column_Sender");
                }
                case 2: {
                    return NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Column_String");
                }
            }
            return null;
        }

        public int addRow(String string, String string2, String string3) {
            ++this.rows;
            this.setRow(this.rows - 1, string3 + ',' + string + ',' + string2);
            this.fireTableRowsInserted(this.rows - 1, this.rows - 1);
            return this.rows - 1;
        }

        private String getRow(int n) {
            assert (n < this.rows);
            String string = this.map.get(PREFIX + String.valueOf(n + 1));
            return string == null ? ",," : string;
        }

        private void setRow(int n, String string) {
            assert (n < this.rows);
            this.map.put(PREFIX + String.valueOf(n + 1), string);
        }

        public void removeRow(int n) {
            for (int i = n; i < this.rows - 1; ++i) {
                this.setRow(i, this.getRow(i + 1));
            }
            this.map.remove(PREFIX + String.valueOf(this.rows));
            --this.rows;
            this.fireTableRowsDeleted(n, n);
        }

        public void moveUp(int n) {
            String string = this.getRow(n);
            this.setRow(n, this.getRow(n - 1));
            this.setRow(n - 1, string);
            this.fireTableRowsUpdated(n - 1, n);
        }

        public void moveDown(int n) {
            String string = this.getRow(n);
            this.setRow(n, this.getRow(n + 1));
            this.setRow(n + 1, string);
            this.fireTableRowsUpdated(n, n + 1);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n2 < 3);
            return this.getRow(n).split(",", 3)[COLUMN_MAP[n2]].trim();
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            return new Object[]{this.map};
        }

        @Override
        public synchronized void setDataDelegates(Object[] objectArray) {
            this.map = objectArray[0] == null ? new HashMap() : (HashMap)objectArray[0];
            this.rows = 0;
            for (String string : this.map.keySet()) {
                if (!string.startsWith(PREFIX)) continue;
                try {
                    int n = Integer.parseInt(string.substring(PREFIX.length()));
                    if (n <= this.rows) continue;
                    this.rows = n;
                }
                catch (NumberFormatException numberFormatException) {
                    assert (false) : numberFormatException;
                }
            }
            this.fireTableDataChanged();
        }

        public void setRow(int n, String string, String string2, String string3) {
            this.setRow(n, string3 + ',' + string + ',' + string2);
            this.fireTableRowsUpdated(n, n);
        }
    }
}

