/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.ConfigurationsChildren;
import org.netbeans.modules.mobility.project.ui.DecoratedNode;
import org.netbeans.modules.mobility.project.ui.OneConfigurationNode;
import org.netbeans.modules.mobility.project.ui.actions.AddConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.SelectConfigurationAction;
import org.netbeans.modules.mobility.project.ui.customizer.CloneConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.VisualConfigSupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PasteAction;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigurationsNode
extends DecoratedNode
implements PropertyChangeListener,
AntProjectListener {
    private final ConfigurationsChildren kids;
    private final Map<J2MEProject, HashSet<Node>> map = new HashMap<J2MEProject, HashSet<Node>>();
    private PasteType pType;

    ConfigurationsNode(J2MEProject j2MEProject) {
        this(j2MEProject, new ConfigurationsChildren(j2MEProject));
    }

    private ConfigurationsNode(J2MEProject j2MEProject, ConfigurationsChildren configurationsChildren) {
        super(Children.create((ChildFactory)configurationsChildren, (boolean)true), Lookups.singleton((Object)j2MEProject));
        this.kids = configurationsChildren;
        this.setDisplayName(NbBundle.getMessage(ConfigurationsNode.class, (String)"LBL_ProjectConfigurations"));
        this.setIconBaseWithExtension("org/netbeans/modules/mobility/project/ui/resources/configs.gif");
        ProjectConfigurationsHelper projectConfigurationsHelper = j2MEProject.getConfigurationHelper();
        projectConfigurationsHelper.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)projectConfigurationsHelper));
        AntProjectHelper antProjectHelper = (AntProjectHelper)j2MEProject.getLookup().lookup(AntProjectHelper.class);
        antProjectHelper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)antProjectHelper));
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        javaPlatformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)javaPlatformManager));
        this.checkBroken();
    }

    public Action[] getActions(boolean bl) {
        if (((Project)this.getLookup().lookup(Project.class)).getProjectDirectory().isValid()) {
            return new Action[]{AddConfigurationAction.getStaticInstance(), null, SelectConfigurationAction.getStaticInstance(), null, SystemAction.get(PasteAction.class)};
        }
        return new Action[0];
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.checkBroken();
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        this.checkBroken();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof ProjectConfigurationsHelper && "configurations".equals(propertyChangeEvent.getPropertyName()) && this.isAlive()) {
            this.kids.update();
        }
        this.checkBroken();
    }

    @Override
    protected boolean isBroken() {
        J2MEProject j2MEProject = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        return j2MEProject.hasBrokenLinks();
    }

    @Override
    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasteType getPasteType(Transferable transferable, DataFlavor[] dataFlavorArray) {
        DataFlavor[] dataFlavorArray2 = this;
        synchronized (this) {
            if (this.pType == null) {
                class CfgPasteType
                extends PasteType {
                    CfgPasteType() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Transferable paste() throws IOException {
                        J2MEProject j2MEProject = (J2MEProject)ConfigurationsNode.this.getLookup().lookup(J2MEProject.class);
                        if (j2MEProject == null) {
                            return null;
                        }
                        J2MEProjectProperties j2MEProjectProperties = new J2MEProjectProperties(j2MEProject, (AntProjectHelper)j2MEProject.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)j2MEProject.getLookup().lookup(ReferenceHelper.class), j2MEProject.getConfigurationHelper());
                        ArrayList<ProjectConfiguration> arrayList = new ArrayList<ProjectConfiguration>(Arrays.asList(j2MEProjectProperties.getConfigurations()));
                        int n = arrayList.size();
                        ProjectConfiguration projectConfiguration = null;
                        ProjectConfiguration projectConfiguration2 = null;
                        for (J2MEProject j2MEProject2 : ConfigurationsNode.this.map.keySet()) {
                            HashSet hashSet = (HashSet)ConfigurationsNode.this.map.get(j2MEProject2);
                            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size() + hashSet.size());
                            J2MEProjectProperties j2MEProjectProperties2 = new J2MEProjectProperties(j2MEProject2, (AntProjectHelper)j2MEProject2.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)j2MEProject2.getLookup().lookup(ReferenceHelper.class), j2MEProject2.getConfigurationHelper());
                            for (ProjectConfiguration projectConfiguration3 : arrayList) {
                                arrayList2.add(projectConfiguration3.getDisplayName());
                            }
                            for (ProjectConfiguration projectConfiguration3 : hashSet) {
                                String string;
                                String[] stringArray;
                                projectConfiguration2 = projectConfiguration = (ProjectConfiguration)projectConfiguration3.getLookup().lookup(ProjectConfiguration.class);
                                boolean bl = j2MEProject2.isUsingDefaultLibs(projectConfiguration2);
                                ProjectConfiguration projectConfiguration4 = j2MEProject.getConfigurationHelper().getConfigurationByName(projectConfiguration.getDisplayName());
                                if (projectConfiguration4 != null) {
                                    stringArray = new CloneConfigurationPanel(arrayList2);
                                    string = new DialogDescriptor((Object)stringArray, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_DuplConfiguration", (Object)projectConfiguration.getDisplayName()), true, 2, NotifyDescriptor.OK_OPTION, null);
                                    stringArray.setDialogDescriptor((DialogDescriptor)string);
                                    String string2 = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)string)) ? stringArray.getName() : null;
                                    if (string2 == null) continue;
                                    projectConfiguration2 = new PrototypeConfiguration(string2);
                                    arrayList2.add(string2);
                                }
                                stringArray = j2MEProjectProperties2.keySet().toArray(new String[j2MEProjectProperties2.size()]);
                                string = "configs." + projectConfiguration.getDisplayName();
                                for (int i = 0; i < stringArray.length; ++i) {
                                    if (!stringArray[i].startsWith(string)) continue;
                                    j2MEProjectProperties.put("configs." + projectConfiguration2.getDisplayName() + stringArray[i].substring(string.length()), j2MEProjectProperties2.get(stringArray[i]));
                                }
                                if (bl) {
                                    j2MEProjectProperties.put("configs." + projectConfiguration2.getDisplayName() + ".libs.classpath", j2MEProjectProperties2.get("libs.classpath"));
                                    j2MEProjectProperties.put("configs." + projectConfiguration2.getDisplayName() + ".extra.classpath", j2MEProjectProperties2.get("extra.classpath"));
                                }
                                arrayList.add(projectConfiguration2);
                            }
                        }
                        ConfigurationsNode.this.map.clear();
                        Object object = this;
                        synchronized (object) {
                            ConfigurationsNode.this.pType = null;
                        }
                        if (arrayList.size() == n) {
                            return null;
                        }
                        j2MEProjectProperties.setConfigurations(arrayList.toArray(new ProjectConfiguration[arrayList.size()]));
                        object = projectConfiguration2;
                        EventQueue.invokeLater(new Runnable((ProjectConfiguration)object, j2MEProjectProperties, j2MEProject){
                            final /* synthetic */ ProjectConfiguration val$lcfg;
                            final /* synthetic */ J2MEProjectProperties val$targetProperties;
                            final /* synthetic */ J2MEProject val$targetProject;
                            {
                                this.val$lcfg = projectConfiguration;
                                this.val$targetProperties = j2MEProjectProperties;
                                this.val$targetProject = j2MEProject;
                            }

                            public void run() {
                                assert (this.val$lcfg != null);
                                try {
                                    Children.MUTEX.writeAccess(new Runnable(){

                                        public void run() {
                                            val$targetProperties.store();
                                        }
                                    });
                                    this.val$targetProject.getConfigurationHelper().setActiveConfiguration(this.val$lcfg);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    Exceptions.printStackTrace((Throwable)illegalArgumentException);
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                        });
                        return null;
                    }
                }
                this.pType = (ConfigurationsNode)this.new CfgPasteType();
            }
            // ** MonitorExit[var6_3] (shouldn't be in output)
            for (DataFlavor dataFlavor : dataFlavorArray) {
                Object object;
                Node node;
                if (!"application".equals(dataFlavor.getPrimaryType())) continue;
                if ("x-java-openide-multinode".equals(dataFlavor.getSubType())) {
                    node = NodeTransfer.nodes((Transferable)transferable, (int)3);
                    if (node == null) {
                        return null;
                    }
                    object = node;
                    int n = ((Node)object).length;
                    for (int i = 0; i < n; ++i) {
                        J2MEProject j2MEProject;
                        Node node2 = object[i];
                        if (!(node2 instanceof OneConfigurationNode) || (j2MEProject = (J2MEProject)node2.getLookup().lookup(J2MEProject.class)) == null) continue;
                        HashSet<Object> hashSet = this.map.get(j2MEProject);
                        if (hashSet == null) {
                            hashSet = new HashSet();
                            this.map.put(j2MEProject, hashSet);
                        }
                        hashSet.add(node2);
                    }
                    if (this.map.size() != 0) {
                        return this.pType;
                    }
                }
                if (!"x-java-openide-nodednd".equals(dataFlavor.getSubType())) continue;
                node = NodeTransfer.node((Transferable)transferable, (int)3);
                if (node instanceof OneConfigurationNode && (object = (J2MEProject)node.getLookup().lookup(J2MEProject.class)) != null) {
                    HashSet<Object> hashSet = this.map.get(object);
                    if (hashSet == null) {
                        hashSet = new HashSet();
                        this.map.put((J2MEProject)object, hashSet);
                    }
                    hashSet.add(node);
                }
                if (this.map.size() == 0) continue;
                return this.pType;
            }
            return null;
        }
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        PasteType pasteType = this.getPasteType(transferable, dataFlavorArray);
        return pasteType;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        PasteType pasteType = this.getDropType(transferable, 0, 0);
        if (pasteType != null) {
            list.add(pasteType);
        }
    }

    private static class PrototypeConfiguration
    implements ProjectConfiguration {
        private final String name;

        PrototypeConfiguration(String string) {
            this.name = string;
        }

        public String getDisplayName() {
            return this.name;
        }
    }
}

