/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JCheckTree;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.selector.ui.BuilderUsageCalculator;
import org.netbeans.modules.profiler.selector.ui.CancellableController;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.utilities.trees.NodeFilter;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootSelectorTree
extends JCheckTree {
    private static NodeFilter<SelectorNode> DEFAULT_FILTER_INNER = new NodeFilter<SelectorNode>(){

        public boolean match(SelectorNode selectorNode) {
            return true;
        }

        public boolean maymatch(SelectorNode selectorNode) {
            return true;
        }
    };
    public static NodeFilter<SelectorNode> DEFAULT_FILTER = DEFAULT_FILTER_INNER;
    private static final String EMPTY_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_EmptyString");
    private static final String LOADING_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_LoadingString");
    private static final String ROOT_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_RootString");
    private static final String NO_PROJECT_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_NoProjectString");
    private static final TreeModel DEFAULTMODEL = new DefaultTreeModel(new DefaultMutableTreeNode(EMPTY_STRING));
    public static final String SELECTION_TREE_VIEW_LIST_PROPERTY = "SELECTION_TREE_VIEW_LIST";
    private final Set<ClientUtils.SourceCodeSelection> currentSelectionSet = new HashSet<ClientUtils.SourceCodeSelection>();
    private ProgressDisplayer progress = ProgressDisplayer.DEFAULT;
    private NodeFilter<SelectorNode> nodeFilter = DEFAULT_FILTER_INNER;
    private Lookup context = Lookup.EMPTY;
    private SelectionTreeBuilder.Type builderType = null;

    public RootSelectorTree(BuilderUsageCalculator builderUsageCalculator) {
        this(ProgressDisplayer.DEFAULT, DEFAULT_FILTER_INNER);
    }

    public RootSelectorTree(ProgressDisplayer progressDisplayer) {
        this(progressDisplayer, DEFAULT_FILTER_INNER);
    }

    public RootSelectorTree(NodeFilter<SelectorNode> nodeFilter) {
        this(ProgressDisplayer.DEFAULT, nodeFilter);
    }

    public RootSelectorTree(ProgressDisplayer progressDisplayer, NodeFilter<SelectorNode> nodeFilter) {
        this.progress = progressDisplayer;
        this.nodeFilter = nodeFilter;
        this.init();
    }

    public void setContext(Lookup lookup) {
        this.context = lookup;
        this.firePropertyChange(SELECTION_TREE_VIEW_LIST_PROPERTY, null, null);
    }

    public void setSelection(final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        new SwingWorker(false){

            protected void doInBackground() {
                RootSelectorTree.this.applySelection(sourceCodeSelectionArray);
            }

            protected void done() {
                RootSelectorTree.this.treeDidChange();
            }
        }.execute();
    }

    public ClientUtils.SourceCodeSelection[] getSelection() {
        return this.currentSelectionSet.toArray(new ClientUtils.SourceCodeSelection[this.currentSelectionSet.size()]);
    }

    public List<SelectionTreeBuilder.Type> getBuilderTypes() {
        class TypeEntry {
            SelectionTreeBuilder.Type type;
            int frequency;

            public TypeEntry(SelectionTreeBuilder.Type type) {
                this.type = type;
                this.frequency = 0;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                TypeEntry typeEntry = (TypeEntry)object;
                return this.type == typeEntry.type || this.type != null && this.type.equals((Object)typeEntry.type);
            }

            public int hashCode() {
                int n = 5;
                n = 53 * n + (this.type != null ? this.type.hashCode() : 0);
                return n;
            }
        }
        ArrayList<TypeEntry> arrayList = new ArrayList<TypeEntry>();
        for (Object object : Lookup.getDefault().lookupAll(SelectionTreeBuilderFactory.class)) {
            Collection object2 = object.createBuildersFor(this.context);
            for (SelectionTreeBuilder selectionTreeBuilder : object2) {
                if (selectionTreeBuilder.estimatedNodeCount() == -1) continue;
                SelectionTreeBuilder.Type type = selectionTreeBuilder.getType();
                TypeEntry typeEntry = new TypeEntry(type);
                if (arrayList.contains(typeEntry)) {
                    int n = arrayList.indexOf(typeEntry);
                    typeEntry = (TypeEntry)arrayList.get(n);
                    typeEntry.frequency = typeEntry.frequency + (selectionTreeBuilder.isPreferred() ? 2 : 1);
                    continue;
                }
                arrayList.add(typeEntry);
            }
        }
        Collections.sort(arrayList, new Comparator<TypeEntry>(){

            @Override
            public int compare(TypeEntry typeEntry, TypeEntry typeEntry2) {
                if (typeEntry.frequency > typeEntry2.frequency) {
                    return 1;
                }
                if (typeEntry.frequency < typeEntry2.frequency) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (TypeEntry typeEntry : arrayList) {
            arrayList2.add(typeEntry.type);
        }
        return arrayList2;
    }

    public void setBuilderType(SelectionTreeBuilder.Type type) {
        this.builderType = type;
        this.refreshTree();
    }

    public void reset() {
        this.setModel(DEFAULTMODEL);
        this.currentSelectionSet.clear();
        this.context = Lookup.EMPTY;
    }

    public static boolean canBeShown() {
        return Lookup.getDefault().lookup(SelectionTreeBuilderFactory.class) != null;
    }

    private void init() {
        UIUtils.makeTreeAutoExpandable((JTree)((Object)this), (boolean)true);
        this.addCheckTreeListener(new JCheckTree.CheckTreeListener(){

            public void checkTreeChanged(Collection<CheckTreeNode> collection) {
            }

            public void checkNodeToggled(TreePath treePath, boolean bl) {
                if (!bl) {
                    SelectorNode selectorNode = (SelectorNode)treePath.getLastPathComponent();
                    Collection collection = selectorNode.getRootMethods(true);
                    if (selectorNode.isFullyChecked()) {
                        ArrayList<ClientUtils.SourceCodeSelection> arrayList = new ArrayList<ClientUtils.SourceCodeSelection>();
                        for (ClientUtils.SourceCodeSelection sourceCodeSelection : collection) {
                            for (ClientUtils.SourceCodeSelection sourceCodeSelection2 : RootSelectorTree.this.currentSelectionSet) {
                                if (!sourceCodeSelection.contains(sourceCodeSelection2)) continue;
                                arrayList.add(sourceCodeSelection2);
                            }
                        }
                        RootSelectorTree.this.removeSelection(arrayList.toArray(new ClientUtils.SourceCodeSelection[arrayList.size()]));
                        RootSelectorTree.this.applySelection(collection.toArray(new ClientUtils.SourceCodeSelection[collection.size()]));
                    } else {
                        Object object4;
                        Object object2;
                        Object object3;
                        ContainerNode containerNode = selectorNode.getParent();
                        ArrayList arrayList = new ArrayList();
                        if (containerNode != null) {
                            object3 = containerNode.children();
                            while (object3.hasMoreElements()) {
                                object2 = (SelectorNode)object3.nextElement();
                                if (object2 == selectorNode || !object2.isFullyChecked()) continue;
                                arrayList.addAll(object2.getRootMethods(true));
                            }
                            arrayList.removeAll(collection);
                        }
                        object3 = new ArrayList();
                        for (Object object4 : collection) {
                            for (ClientUtils.SourceCodeSelection sourceCodeSelection : RootSelectorTree.this.currentSelectionSet) {
                                if (!sourceCodeSelection.contains(object4) && !object4.contains(sourceCodeSelection)) continue;
                                object3.add(sourceCodeSelection);
                            }
                        }
                        object3.addAll(collection);
                        object2 = (TreeNode)RootSelectorTree.this.getModel().getRoot();
                        object4 = new ArrayList();
                        int n = object2.getChildCount();
                        for (int i = 0; i < n; ++i) {
                            RootSelectorTree.calculateInflatedSelection((SelectorNode)containerNode, (SelectorNode)object2.getChildAt(i), (Collection)object4, (Collection)object3);
                        }
                        RootSelectorTree.addRequiredPackages((Collection)object4, arrayList);
                        RootSelectorTree.this.removeSelection(object3.toArray(new ClientUtils.SourceCodeSelection[object3.size()]));
                        RootSelectorTree.this.applySelection(arrayList.toArray(new ClientUtils.SourceCodeSelection[arrayList.size()]));
                    }
                }
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){
            private volatile boolean openingSubtree = false;

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            public void treeWillExpand(final TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (!(treeNode instanceof DefaultMutableTreeNode)) {
                    return;
                }
                final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                if (defaultMutableTreeNode.getChildCount() == -1) {
                    if (this.openingSubtree) {
                        throw new ExpandVetoException(treeExpansionEvent);
                    }
                    this.openingSubtree = true;
                    new SwingWorker(){

                        protected void doInBackground() {
                            RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, false);
                        }

                        protected void nonResponding() {
                            RootSelectorTree.this.progress.showProgress(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"NodeLoadingMessage"));
                        }

                        protected void done() {
                            RootSelectorTree.this.progress.close();
                            RootSelectorTree.this.expandPath(treeExpansionEvent.getPath());
                            RootSelectorTree.this.doLayout();
                            openingSubtree = false;
                        }
                    }.execute();
                    throw new ExpandVetoException(treeExpansionEvent);
                }
                RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, false);
            }
        });
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setModel(DEFAULTMODEL);
    }

    private static void checkNodeChildren(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, bl, null);
    }

    private static void checkNodeChildren(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, CancellableController cancellableController) {
        if (cancellableController != null && cancellableController.isCancelled()) {
            return;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (defaultMutableTreeNode instanceof CheckTreeNode && ((CheckTreeNode)defaultMutableTreeNode).isFullyChecked()) {
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                if (!(treeNode instanceof CheckTreeNode)) continue;
                ((CheckTreeNode)treeNode).setChecked(true);
                if (!bl) continue;
                RootSelectorTree.checkNodeChildren((DefaultMutableTreeNode)((CheckTreeNode)treeNode), bl, cancellableController);
            }
        }
    }

    private void applySelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : sourceCodeSelectionArray) {
                this.applySelection((SelectorNode)treeNode2, sourceCodeSelection);
            }
        }
        this.currentSelectionSet.addAll(Arrays.asList(sourceCodeSelectionArray));
    }

    private void applySelection(SelectorNode selectorNode, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        ClientUtils.SourceCodeSelection sourceCodeSelection2 = selectorNode.getSignature();
        if (sourceCodeSelection2 != null) {
            if (sourceCodeSelection2.equals((Object)sourceCodeSelection) || sourceCodeSelection.contains(sourceCodeSelection2)) {
                selectorNode.setChecked(true);
                return;
            }
            if (!sourceCodeSelection2.contains(sourceCodeSelection)) {
                return;
            }
        }
        Enumeration enumeration = selectorNode.children();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SelectorNode)) continue;
            this.applySelection((SelectorNode)e, sourceCodeSelection);
        }
    }

    private void removeSelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : sourceCodeSelectionArray) {
                this.removeSelection((SelectorNode)treeNode2, sourceCodeSelection);
            }
        }
        this.currentSelectionSet.removeAll(Arrays.asList(sourceCodeSelectionArray));
    }

    private void removeSelection(SelectorNode selectorNode, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        ClientUtils.SourceCodeSelection sourceCodeSelection2 = selectorNode.getSignature();
        if (sourceCodeSelection2 != null) {
            if (sourceCodeSelection2.equals((Object)sourceCodeSelection)) {
                selectorNode.setChecked(false);
                return;
            }
            if (!sourceCodeSelection2.contains(sourceCodeSelection)) {
                return;
            }
        }
        Enumeration enumeration = selectorNode.children();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SelectorNode)) continue;
            this.removeSelection((SelectorNode)e, sourceCodeSelection);
        }
    }

    private static void calculateInflatedSelection(SelectorNode selectorNode, SelectorNode selectorNode2, Collection<ClientUtils.SourceCodeSelection> collection, Collection<ClientUtils.SourceCodeSelection> collection2) {
        if (selectorNode == null || selectorNode2 == null || collection == null || collection2 == null) {
            return;
        }
        if (selectorNode2.isFullyChecked() || selectorNode2.isPartiallyChecked()) {
            if (selectorNode2.getSignature() != null && selectorNode2.isFullyChecked() && !collection2.contains(selectorNode2.getSignature())) {
                collection.add(selectorNode2.getSignature());
            }
            if (selectorNode2.getSignature() == null || selectorNode.getSignature() == null || selectorNode2.getSignature().contains(selectorNode.getSignature())) {
                int n = selectorNode2.getChildCount();
                for (int i = 0; i < n; ++i) {
                    SelectorNode selectorNode3 = (SelectorNode)selectorNode2.getChildAt(i);
                    RootSelectorTree.calculateInflatedSelection(selectorNode, selectorNode3, collection, collection2);
                }
            }
        }
    }

    private static void addRequiredPackages(Collection<ClientUtils.SourceCodeSelection> collection, Collection<ClientUtils.SourceCodeSelection> collection2) {
        for (ClientUtils.SourceCodeSelection sourceCodeSelection : collection) {
            boolean bl = true;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection2 : collection2) {
                bl = bl && !sourceCodeSelection.contains(sourceCodeSelection2);
            }
            if (!bl) continue;
            collection2.add(sourceCodeSelection);
        }
    }

    private void refreshTree() {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(LOADING_STRING)));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.getTreeRoot()));
        this.applyCurrentSelection();
        this.treeDidChange();
    }

    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ROOT_STRING);
        if (this.builderType != null) {
            for (SelectionTreeBuilderFactory selectionTreeBuilderFactory : Lookup.getDefault().lookupAll(SelectionTreeBuilderFactory.class)) {
                Collection collection = selectionTreeBuilderFactory.createBuildersFor(this.context);
                for (SelectionTreeBuilder selectionTreeBuilder : collection) {
                    if (!selectionTreeBuilder.getType().equals((Object)this.builderType)) continue;
                    for (SelectorNode selectorNode : selectionTreeBuilder.buildSelectionTree()) {
                        defaultMutableTreeNode.add((MutableTreeNode)selectorNode);
                    }
                }
            }
        }
        return defaultMutableTreeNode;
    }

    private void applyCurrentSelection() {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : this.currentSelectionSet) {
                this.applySelection((SelectorNode)treeNode2, sourceCodeSelection);
            }
        }
    }
}

