/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.JTreeTable;

public class JTreeTablePanel
extends JPanel {
    CustomTreeTableViewport treeTableViewport;
    protected JPanel scrollBarPanel;
    protected JScrollBar scrollBar;
    protected JScrollPane treeTableScrollPane;
    protected JTreeTable treeTable;
    private boolean columnMarginChanged = false;
    private boolean internalScrollBarChange = false;

    public JTreeTablePanel(JTreeTable jTreeTable) {
        super(new BorderLayout());
        this.treeTable = jTreeTable;
        this.initComponents();
        this.hookHeaderColumnResize();
        this.hookScrollBarValueChange();
        this.hookTreeCollapsedExpanded();
    }

    public void setCorner(String string, Component component) {
        this.treeTableScrollPane.setCorner(string, component);
    }

    public JScrollPane getScrollPane() {
        return this.treeTableScrollPane;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.updateScrollBarMaximum();
        this.updateScrollBarWidth();
    }

    private void hookHeaderColumnResize() {
        this.treeTable.getTableHeader().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
                JTreeTablePanel.this.internalScrollBarChange = true;
                JTreeTablePanel.this.columnMarginChanged = true;
                JTreeTablePanel.this.updateScrollBarMaximum();
                JTreeTablePanel.this.treeTableViewport.repaint();
                JTreeTablePanel.this.updateScrollBarWidth();
                JTreeTablePanel.this.internalScrollBarChange = false;
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    private void hookScrollBarValueChange() {
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!JTreeTablePanel.this.internalScrollBarChange) {
                    JTreeTablePanel.this.treeTable.setTreeCellOffsetX(adjustmentEvent.getValue());
                }
            }
        });
    }

    private void hookTreeCollapsedExpanded() {
        this.treeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                JTreeTablePanel.this.internalScrollBarChange = true;
                JTreeTablePanel.this.updateScrollBarMaximum();
                JTreeTablePanel.this.internalScrollBarChange = false;
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                JTreeTablePanel.this.internalScrollBarChange = true;
                JTreeTablePanel.this.updateScrollBarMaximum();
                JTreeTablePanel.this.internalScrollBarChange = false;
            }
        });
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeTableScrollPane = new JScrollPane(22, 31);
        this.treeTableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.treeTableViewport = new CustomTreeTableViewport(this.treeTable);
        this.treeTableScrollPane.setViewport(this.treeTableViewport);
        this.treeTableScrollPane.addMouseWheelListener(this.treeTable);
        this.treeTableScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().getModel().getExtent() == JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
                    JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().setEnabled(false);
                } else {
                    JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().setEnabled(true);
                }
            }
        });
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.setUnitIncrement(10);
        this.scrollBarPanel = new JPanel(new BorderLayout());
        this.scrollBarPanel.add((Component)this.scrollBar, "West");
        this.treeTable.setTreeCellOffsetX(0);
        this.scrollBarPanel.setVisible(false);
        this.add((Component)this.treeTableScrollPane, "Center");
        this.add((Component)this.scrollBarPanel, "South");
    }

    private void updateScrollBarMaximum() {
        int n = this.treeTable.getTree().getPreferredSize().width + 3;
        int n2 = this.treeTable.getColumnModel().getColumn(0).getWidth();
        if (this.columnMarginChanged && this.treeTable.getTreeCellOffsetX() > 0 && n - this.treeTable.getTreeCellOffsetX() < n2) {
            this.columnMarginChanged = false;
            if (n - n2 >= 0) {
                this.treeTable.setTreeCellOffsetX(n - n2);
            }
        }
        int n3 = n - n2;
        if (!this.isShowing()) {
            return;
        }
        if (n3 <= 0) {
            this.treeTable.setTreeCellOffsetX(0);
            this.scrollBarPanel.setVisible(false);
        } else {
            int n4 = this.treeTable.getTreeCellOffsetX();
            int n5 = n;
            this.scrollBarPanel.setVisible(true);
            this.scrollBar.setValues(n4, n5, 0, n3 + n5);
        }
    }

    private void updateScrollBarWidth() {
        this.scrollBar.setPreferredSize(new Dimension(this.treeTable.getTableHeader().getHeaderRect((int)0).width, this.scrollBar.getPreferredSize().height));
        this.scrollBar.setBlockIncrement((int)((float)this.scrollBar.getModel().getExtent() * 0.95f));
        this.scrollBar.invalidate();
        this.revalidate();
    }

    private class CustomTreeTableViewport
    extends JViewport {
        private JTableHeader tableHeader;

        public CustomTreeTableViewport(JTreeTable jTreeTable) {
            this.setView(jTreeTable);
            this.setBackground(jTreeTable.getBackground());
            this.tableHeader = jTreeTable.getTableHeader();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.paintVerticalLines(graphics);
        }

        private int getEmptySpaceY() {
            if (this.getView() == null) {
                return 0;
            }
            return this.getView().getHeight();
        }

        private void paintVerticalLines(Graphics graphics) {
            int n = this.getEmptySpaceY();
            if (n > 0) {
                graphics.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
                for (int i = 0; i < this.tableHeader.getColumnModel().getColumnCount(); ++i) {
                    Rectangle rectangle = this.tableHeader.getHeaderRect(i);
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n, rectangle.x + rectangle.width - 1, this.getHeight() - 1);
                }
            }
        }
    }
}

