/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.gsf.embedding.CssEmbeddingProvider;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssHtmlTranslator
implements CssEmbeddingProvider.Translator {
    private static final Logger LOGGER = Logger.getLogger(CssHtmlTranslator.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String CSS_MIME_TYPE = "text/x-css";
    public static final String HTML_MIME_TYPE = "text/html";
    protected static final String END_OF_LAST_SEQUENCE = "end_of_last_sequence";
    protected static final String IN_STYLE = "in_style";
    protected static final String IN_INLINED_STYLE = "in_inlined_style";
    private static final String QUTE_CUT = "quote_cut";

    @Override
    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)snapshot.getText(), (Language)HTMLTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
        ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
        this.extractCssFromHTML(snapshot, (TokenSequence<HTMLTokenId>)tokenSequence, hashMap, arrayList);
        return arrayList;
    }

    protected void extractCssFromHTML(Snapshot snapshot, TokenSequence<HTMLTokenId> tokenSequence, HashMap<String, Object> hashMap, List<Embedding> list) {
        block0: while (tokenSequence.moveNext()) {
            Token token;
            TokenId tokenId;
            int n;
            Token token2 = tokenSequence.token();
            TokenId tokenId2 = token2.id();
            if (tokenId2 == HTMLTokenId.STYLE) {
                hashMap.put(IN_STYLE, Boolean.TRUE);
                int n2 = tokenSequence.offset();
                int n3 = n2 + token2.length();
                list.add(snapshot.create(n2, n3 - n2, CSS_MIME_TYPE));
                continue;
            }
            hashMap.remove(IN_STYLE);
            if (hashMap.get(IN_INLINED_STYLE) != null) {
                if (tokenId2 == HTMLTokenId.VALUE_CSS) {
                    int n4 = tokenSequence.offset();
                    CharSequence charSequence = token2.text();
                    n = token2.length();
                    if (CharSequenceUtilities.endsWith((CharSequence)charSequence, (CharSequence)"\"") || CharSequenceUtilities.endsWith((CharSequence)charSequence, (CharSequence)"'")) {
                        --n;
                    }
                    list.add(snapshot.create(n4, n, CSS_MIME_TYPE));
                } else {
                    hashMap.remove(IN_INLINED_STYLE);
                    int n5 = tokenSequence.offset();
                    if (hashMap.get(QUTE_CUT) != null) {
                        --n5;
                    }
                    hashMap.remove(QUTE_CUT);
                    list.add(snapshot.create((CharSequence)"\n}\n", CSS_MIME_TYPE));
                }
            }
            if (tokenId2 != HTMLTokenId.TAG_OPEN) continue;
            while (tokenSequence.moveNext() && (tokenId = (token = tokenSequence.token()).id()) != HTMLTokenId.TAG_CLOSE_SYMBOL) {
                if (tokenId != HTMLTokenId.VALUE_CSS) continue;
                n = tokenSequence.offset();
                String string = ((Object)token.text()).toString();
                if (string.startsWith("\"") || string.startsWith("'")) {
                    ++n;
                    string = string.substring(1);
                }
                int n6 = n + string.length();
                if (string.endsWith("\"") || string.endsWith("'")) {
                    --n6;
                    hashMap.put(QUTE_CUT, Boolean.TRUE);
                    string = string.substring(0, string.length() - 1);
                }
                list.add(snapshot.create((CharSequence)"\n SELECTOR {\n\t", CSS_MIME_TYPE));
                list.add(snapshot.create(n, n6 - n, CSS_MIME_TYPE));
                hashMap.put(IN_INLINED_STYLE, Boolean.TRUE);
                continue block0;
            }
        }
    }
}

