/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.AstPath;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlStructureScanner
implements StructureScanner {
    private static final Logger LOGGER = Logger.getLogger(HtmlStructureScanner.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public List<? extends StructureItem> scan(ParserResult parserResult) {
        HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
        AstNode astNode = htmlParserResult.root();
        if (LOG) {
            LOGGER.log(Level.FINE, "HTML parser tree output:");
            LOGGER.log(Level.FINE, astNode.toString());
        }
        ArrayList<? extends StructureItem> arrayList = new ArrayList<StructureItem>(1);
        arrayList.addAll(new HtmlStructureItem(new HtmlElementHandle(astNode, parserResult.getSnapshot().getSource().getFileObject()), parserResult.getSnapshot()).getNestedItems());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<OffsetRange>> folds(final ParserResult parserResult) {
        final BaseDocument baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
        if (baseDocument == null) {
            return Collections.emptyMap();
        }
        AstNode astNode = ((HtmlParserResult)parserResult).root();
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        AstNodeVisitor astNodeVisitor = new AstNodeVisitor(){

            public void visit(AstNode astNode) {
                if (astNode.type() == AstNode.NodeType.OPEN_TAG || astNode.type() == AstNode.NodeType.COMMENT) {
                    try {
                        int[] nArray = astNode.getLogicalRange();
                        int n = nArray[0];
                        int n2 = nArray[1];
                        int n3 = HtmlStructureScanner.documentPosition(n, parserResult.getSnapshot());
                        int n4 = HtmlStructureScanner.documentPosition(n2, parserResult.getSnapshot());
                        if (n4 > baseDocument.getLength() && n3 > (n4 = baseDocument.getLength())) {
                            n3 = n4;
                        }
                        if (Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3) < Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4)) {
                            if (astNode.type() == AstNode.NodeType.TAG) {
                                arrayList.add(new OffsetRange(n3, n4));
                            } else {
                                arrayList2.add(new OffsetRange(n3, n4));
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.log(Level.INFO, null, badLocationException);
                    }
                }
            }
        };
        baseDocument.readLock();
        try {
            AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)astNodeVisitor);
        }
        finally {
            baseDocument.readUnlock();
        }
        hashMap.put("tags", arrayList);
        hashMap.put("comments", arrayList2);
        return hashMap;
    }

    public static int documentPosition(int n, Snapshot snapshot) {
        return snapshot.getOriginalOffset(n);
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HtmlStructureItem
    implements StructureItem {
        private Snapshot snapshot;
        private HtmlElementHandle handle;
        private int myIndexInParent = -1;
        private List<StructureItem> items = null;

        private HtmlStructureItem(HtmlElementHandle htmlElementHandle, Snapshot snapshot) {
            this.handle = htmlElementHandle;
            this.snapshot = snapshot;
        }

        public String getName() {
            return this.handle.getName();
        }

        public String getSortText() {
            return Integer.toHexString(10000 + (int)this.getPosition());
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendHtml(this.getName());
            AstNode astNode = this.handle.node();
            String string = this.getAttributeValue(astNode, "id");
            String string2 = this.getAttributeValue(astNode, "class");
            if (string != null) {
                htmlFormatter.appendHtml("&nbsp;<font color=808080>id=" + string + "</font>");
            }
            if (string2 != null) {
                htmlFormatter.appendHtml("&nbsp;<font color=808080>class=" + string2 + "</font>");
            }
            return htmlFormatter.getText();
        }

        private String getAttributeValue(AstNode astNode, String string) {
            String string2 = (String)astNode.getAttribute(string.toLowerCase(Locale.ENGLISH));
            if (string2 == null) {
                string2 = (String)astNode.getAttribute(string.toUpperCase(Locale.ENGLISH));
            }
            return string2;
        }

        public ElementHandle getElementHandle() {
            return this.handle;
        }

        synchronized int indexInParent() {
            if (this.myIndexInParent == -1) {
                AstNode astNode = this.handle.node().parent();
                this.myIndexInParent = astNode == null ? -2 : AstPath.indexInSimilarNodes((AstNode)astNode, (AstNode)this.handle.node());
            }
            return this.myIndexInParent;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HtmlStructureItem)) {
                return false;
            }
            HtmlStructureItem htmlStructureItem = (HtmlStructureItem)object;
            AstNode astNode = ((HtmlStructureItem)object).handle.node();
            AstNode astNode2 = this.handle.node();
            if (astNode.type() == astNode2.type() && astNode.name().equals(astNode2.name())) {
                return this.indexInParent() == htmlStructureItem.indexInParent();
            }
            return false;
        }

        public int hashCode() {
            return this.handle.node().name().hashCode() + this.indexInParent();
        }

        public ElementKind getKind() {
            return ElementKind.TAG;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return false;
        }

        public synchronized List<? extends StructureItem> getNestedItems() {
            if (this.items == null) {
                this.items = new ArrayList<StructureItem>(this.handle.node().children().size());
                for (AstNode astNode : this.handle.node().children()) {
                    if (astNode.type() != AstNode.NodeType.OPEN_TAG) continue;
                    HtmlElementHandle htmlElementHandle = new HtmlElementHandle(astNode, this.handle.getFileObject());
                    this.items.add(new HtmlStructureItem(htmlElementHandle, this.snapshot));
                }
            }
            return this.items;
        }

        public long getPosition() {
            return HtmlStructureScanner.documentPosition(this.handle.from(), this.snapshot);
        }

        public long getEndPosition() {
            return HtmlStructureScanner.documentPosition(this.handle.to(), this.snapshot);
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }
}

