/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxTree;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParserResult
extends ParserResult {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private static final String ID_ATTR_NAME = "id";
    private List<SyntaxElement> elements;
    private AstNode parseTreeRoot = null;
    private DTD dtd = null;
    private List<Error> errors;

    HtmlParserResult(Parser parser, Snapshot snapshot, List<SyntaxElement> list) {
        super(snapshot);
        this.elements = list;
        this.root();
    }

    public synchronized AstNode root() {
        if (this.parseTreeRoot == null) {
            this.parseTreeRoot = SyntaxTree.makeTree(this.elementsList(), (DTD)this.dtd());
            this.analyzeParseResult();
        }
        return this.parseTreeRoot;
    }

    public List<SyntaxElement> elementsList() {
        return this.elements;
    }

    public synchronized DTD dtd() {
        if (this.dtd == null) {
            for (SyntaxElement syntaxElement : this.elementsList()) {
                String string;
                if (syntaxElement.type() != 1 || (string = ((SyntaxElement.Declaration)syntaxElement).getPublicIdentifier()) == null) continue;
                this.dtd = Registry.getDTD((String)string, null);
                break;
            }
            if (this.dtd == null) {
                this.dtd = Registry.getDTD((String)FALLBACK_DOCTYPE, null);
            }
        }
        return this.dtd;
    }

    public Set<SyntaxElement.TagAttribute> elementsIds() {
        HashSet<SyntaxElement.TagAttribute> hashSet = new HashSet<SyntaxElement.TagAttribute>(this.elementsList().size() / 10);
        for (SyntaxElement syntaxElement : this.elementsList()) {
            SyntaxElement.TagAttribute tagAttribute;
            if (syntaxElement.type() != 4 || (tagAttribute = ((SyntaxElement.Tag)syntaxElement).getAttribute(ID_ATTR_NAME)) == null) continue;
            hashSet.add(tagAttribute);
        }
        return hashSet;
    }

    public List<? extends Error> getDiagnostics() {
        return this.errors;
    }

    protected void invalidate() {
    }

    private void analyzeParseResult() {
        final ArrayList<Error> arrayList = new ArrayList<Error>();
        AstNodeUtils.visitChildren((AstNode)this.root(), (AstNodeVisitor)new AstNodeVisitor(){

            public void visit(AstNode astNode) {
                if (astNode.type() == AstNode.NodeType.OPEN_TAG || astNode.type() == AstNode.NodeType.ENDTAG || astNode.type() == AstNode.NodeType.UNKNOWN_TAG) {
                    for (AstNode.Description description : astNode.getDescriptions()) {
                        if (description.getType() < 1) continue;
                        Error error = DefaultError.createDefaultError((String)"tag_error", (String)description.getText(), (String)description.getText(), (FileObject)HtmlParserResult.this.getSnapshot().getSource().getFileObject(), (int)HtmlParserResult.this.getSnapshot().getOriginalOffset(description.getFrom()), (int)HtmlParserResult.this.getSnapshot().getOriginalOffset(description.getTo()), (boolean)false, (Severity)(description.getType() == 1 ? Severity.WARNING : Severity.ERROR));
                        arrayList.add(error);
                    }
                }
            }
        });
        this.errors = arrayList;
    }
}

