/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlHintsProvider
implements HintsProvider {
    private boolean cancelled = false;
    private static final HtmlRule ERROR_RULE = new HtmlRule(HintSeverity.ERROR, true);
    private static final HtmlRule WARNING_RULE = new HtmlRule(HintSeverity.WARNING, true);
    static final String DISABLE_ERROR_CHECKS_KEY = "disable_error_checking";

    public void computeHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list) {
    }

    public void computeSuggestions(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n, int n2) {
    }

    public void computeErrors(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, List<Error> list2) {
        Snapshot snapshot = ruleContext.parserResult.getSnapshot();
        FileObject fileObject = snapshot.getSource().getFileObject();
        if (HtmlHintsProvider.isErrorCheckingEnabled(fileObject)) {
            for (Error error : ruleContext.parserResult.getDiagnostics()) {
                assert (error.getDescription() != null);
                DisableErrorChecksFix disableErrorChecksFix = new DisableErrorChecksFix(snapshot);
                Hint hint = new Hint((Rule)HtmlHintsProvider.getRule(error.getSeverity()), error.getDescription(), error.getFile(), new OffsetRange(error.getStartPosition(), error.getEndPosition()), Collections.singletonList(disableErrorChecksFix), 20);
                list.add(hint);
            }
        } else {
            EnableErrorChecksFix enableErrorChecksFix = new EnableErrorChecksFix(snapshot);
            Hint hint = new Hint((Rule)new HtmlRule(HintSeverity.WARNING, false), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE_DESCR"), fileObject, new OffsetRange(0, 0), Collections.singletonList(enableErrorChecksFix), 50);
            list.add(hint);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static HtmlRule getRule(Severity severity) {
        switch (severity) {
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    public static boolean isErrorCheckingEnabled(FileObject fileObject) {
        return fileObject.getAttribute(DISABLE_ERROR_CHECKS_KEY) == null;
    }

    private static void forceReparse(final Document document) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NbEditorDocument nbEditorDocument = (NbEditorDocument)document;
                nbEditorDocument.runAtomic(new Runnable(){

                    public void run() {
                        MutableTextInput mutableTextInput = (MutableTextInput)document.getProperty(MutableTextInput.class);
                        if (mutableTextInput != null) {
                            mutableTextInput.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static final class EnableErrorChecksFix
    implements HintFix {
        private Snapshot snapshot;

        public EnableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document document;
            FileObject fileObject = this.snapshot.getSource().getFileObject();
            if (fileObject != null) {
                fileObject.setAttribute(HtmlHintsProvider.DISABLE_ERROR_CHECKS_KEY, null);
            }
            if ((document = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(document);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class DisableErrorChecksFix
    implements HintFix {
        private static String VALUE = "true";
        private Snapshot snapshot;

        public DisableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document document;
            FileObject fileObject = this.snapshot.getSource().getFileObject();
            if (fileObject != null) {
                fileObject.setAttribute(HtmlHintsProvider.DISABLE_ERROR_CHECKS_KEY, (Object)VALUE);
            }
            if ((document = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(document);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HtmlRule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        private HtmlRule(HintSeverity hintSeverity, boolean bl) {
            this.severity = hintSeverity;
            this.showInTasklist = bl;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext ruleContext) {
            return true;
        }

        public String getDisplayName() {
            return "html";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

