/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.HtmlSyntaxSupport;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.Utils;
import org.netbeans.modules.html.editor.completion.HtmlCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCompletionQuery {
    private static final String SCRIPT_TAG_NAME = "SCRIPT";
    private static final String STYLE_TAG_NAME = "STYLE";
    private static boolean lowerCase;
    private static boolean isXHtml;
    private static HtmlCompletionQuery DEFAULT;

    public static HtmlCompletionQuery getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new HtmlCompletionQuery();
        }
        return DEFAULT;
    }

    public CompletionResult query(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        if (document == null) {
            return null;
        }
        HtmlSyntaxSupport htmlSyntaxSupport = HtmlSyntaxSupport.get((Document)document);
        if (htmlSyntaxSupport == null) {
            return null;
        }
        DTD dTD = htmlSyntaxSupport.getDTD();
        return this.query(document, n, htmlSyntaxSupport, dTD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletionResult query(Document document, int n, HtmlSyntaxSupport htmlSyntaxSupport, DTD dTD) {
        assert (document != null);
        assert (htmlSyntaxSupport != null);
        assert (dTD != null);
        assert (n >= 0);
        BaseDocument baseDocument = (BaseDocument)document;
        lowerCase = true;
        int n2 = -1;
        if (baseDocument.getLength() == 0) {
            return null;
        }
        isXHtml = Utils.isXHTMLPublicId((String)dTD.getIdentifier());
        baseDocument.readLock();
        try {
            Object object;
            int n3;
            boolean bl;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(HTMLTokenId.language());
            if (tokenSequence == null) {
                tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(n);
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                    tokenSequence = tokenSequence.embedded(HTMLTokenId.language());
                } else {
                    CompletionResult completionResult = null;
                    return completionResult;
                }
            }
            if (tokenSequence == null) {
                CompletionResult completionResult = null;
                return completionResult;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                CompletionResult completionResult = null;
                return completionResult;
            }
            Token token = tokenSequence.token();
            boolean bl2 = bl = tokenSequence.offset() < n;
            if (!bl) {
                if (tokenSequence.movePrevious()) {
                    token = tokenSequence.token();
                } else {
                    CompletionResult completionResult = null;
                    return completionResult;
                }
            }
            Token token2 = token;
            while (token2.id() != HTMLTokenId.TAG_OPEN && token2.id() != HTMLTokenId.TAG_CLOSE && tokenSequence.movePrevious()) {
                token2 = tokenSequence.token();
            }
            if (tokenSequence.index() > 0) {
                String string = ((Object)token2.text()).toString();
                for (n3 = 0; n3 < string.length(); ++n3) {
                    char c = string.charAt(n3);
                    if (!Character.isLetter(c)) continue;
                    lowerCase = isXHtml || !Character.isUpperCase(string.charAt(n3));
                    break;
                }
            }
            tokenSequence.move(token.offset(tokenHierarchy));
            int n4 = token.offset(tokenHierarchy);
            n3 = n - n4;
            String string = ((Object)token.text()).toString();
            if (n3 < string.length()) {
                string = string.substring(0, n - n4);
            }
            TokenId tokenId = token.id();
            List<CompletionItem> list = null;
            int n5 = 1;
            int n6 = string.lastIndexOf(38);
            if ((tokenId == HTMLTokenId.TEXT || tokenId == HTMLTokenId.VALUE) && n6 > -1) {
                object = string.substring(n6 + 1);
                n2 = n;
                list = this.translateCharRefs(n - n5, dTD.getCharRefList((String)object));
            } else if (tokenId == HTMLTokenId.CHARACTER) {
                if (bl || !string.endsWith(";")) {
                    n2 = n4 + 1;
                    list = this.translateCharRefs(n4, dTD.getCharRefList(string.substring(1)));
                }
            } else if (tokenId == HTMLTokenId.TAG_OPEN) {
                n2 = n4;
                list = this.translateTags(n4 - 1, dTD.getElementList(string));
            } else if (tokenId != HTMLTokenId.BLOCK_COMMENT && string.endsWith("<")) {
                n2 = n;
                list = this.translateTags(n - 1, dTD.getElementList(""));
            } else if (tokenId == HTMLTokenId.TEXT && string.endsWith("</")) {
                n2 = n;
                list = this.getPossibleEndTags((Document)baseDocument, n, "", dTD);
            } else if (tokenId == HTMLTokenId.TAG_OPEN_SYMBOL && string.endsWith("</")) {
                n2 = n;
                list = this.getPossibleEndTags((Document)baseDocument, n, "", dTD);
            } else if (tokenId == HTMLTokenId.TAG_CLOSE) {
                n2 = n4;
                list = this.getPossibleEndTags((Document)baseDocument, n, string, dTD);
            } else if (tokenId == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                list = this.getAutocompletedEndTag((Document)baseDocument, n, dTD);
            } else if (tokenId == HTMLTokenId.WS || tokenId == HTMLTokenId.ARGUMENT) {
                object = null;
                try {
                    object = htmlSyntaxSupport.getElementChain(n);
                    if (object == null || object.getType() == 4 && ">".equals(object.getText())) {
                        object = htmlSyntaxSupport.getElementChain(n - 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    CompletionResult completionResult = null;
                    baseDocument.readUnlock();
                    return completionResult;
                }
                if (object == null) {
                    CompletionResult completionResult = null;
                    return completionResult;
                }
                if (object.getElementOffset() == n) {
                    object = htmlSyntaxSupport.getElementChain(n - 1);
                }
                if (object == null) {
                    CompletionResult completionResult = null;
                    return completionResult;
                }
                if (object.getType() == 4) {
                    Object object2;
                    SyntaxElement.Tag tag = (SyntaxElement.Tag)object;
                    DTD.Element element = dTD.getElement(tag.getName());
                    if (element == null) {
                        CompletionResult completionResult = null;
                        return completionResult;
                    }
                    String string2 = tokenId == HTMLTokenId.ARGUMENT ? string : "";
                    n5 = string2.length();
                    List list2 = element.getAttributeList(string2);
                    List list3 = tag.getAttributes();
                    ArrayList<String> arrayList = new ArrayList<String>(list3.size());
                    Object object3 = list3.iterator();
                    while (object3.hasNext()) {
                        object2 = (SyntaxElement.TagAttribute)object3.next();
                        arrayList.add(object2.getName());
                    }
                    Object object4 = object3 = token == null ? null : ((Object)token.text()).toString();
                    if (object3 == null) {
                        object3 = "";
                    }
                    object2 = new ArrayList();
                    for (DTD.Attribute attribute : list2) {
                        String string3 = attribute.getName();
                        if (!string3.equals(string2) && (arrayList.contains(isXHtml ? string3 : string3.toUpperCase()) || arrayList.contains(isXHtml ? string3 : string3.toLowerCase(Locale.ENGLISH))) && (!((String)object3).equals(string3) || string2.length() <= 0)) continue;
                        object2.add(attribute);
                    }
                    n2 = n - n5;
                    list = this.translateAttribs(n2, (List<DTD.Attribute>)object2, element);
                }
            } else if (tokenId == HTMLTokenId.VALUE || tokenId == HTMLTokenId.OPERATOR || tokenId == HTMLTokenId.WS) {
                if (tokenId == HTMLTokenId.WS) {
                    tokenSequence.move(token.offset(tokenHierarchy));
                    tokenSequence.movePrevious();
                    object = tokenSequence.token();
                    if (object.id() != HTMLTokenId.OPERATOR) {
                        CompletionResult completionResult = null;
                        return completionResult;
                    }
                }
                object = null;
                try {
                    object = htmlSyntaxSupport.getElementChain(n);
                }
                catch (BadLocationException badLocationException) {
                    CompletionResult completionResult = null;
                    baseDocument.readUnlock();
                    return completionResult;
                }
                if (object == null) {
                    CompletionResult completionResult = null;
                    return completionResult;
                }
                if (object.getType() == 2 && (object = object.getPrevious()) == null) {
                    CompletionResult completionResult = null;
                    return completionResult;
                }
                if (object.getType() == 4) {
                    DTD.Attribute attribute;
                    SyntaxElement.Tag tag = (SyntaxElement.Tag)object;
                    DTD.Element element = dTD.getElement(tag.getName());
                    if (element == null) {
                        CompletionResult completionResult = null;
                        return completionResult;
                    }
                    tokenSequence.move(token.offset(tokenHierarchy));
                    tokenSequence.moveNext();
                    Token token3 = tokenSequence.token();
                    while (token3.id() != HTMLTokenId.ARGUMENT && tokenSequence.movePrevious()) {
                        token3 = tokenSequence.token();
                    }
                    if (token3.id() != HTMLTokenId.ARGUMENT) {
                        CompletionResult completionResult = null;
                        return completionResult;
                    }
                    String string4 = ((Object)token3.text()).toString();
                    if (isXHtml) {
                        string4 = string4.toLowerCase(Locale.ENGLISH);
                    }
                    if ((attribute = element.getAttribute(string4)) == null || attribute.getType() != 1) {
                        CompletionResult completionResult = null;
                        return completionResult;
                    }
                    if (tokenId != HTMLTokenId.VALUE) {
                        n2 = n;
                        list = this.translateValues(n2, attribute.getValueList(""));
                    } else {
                        String string5 = null;
                        if (string != null && string.length() > 0) {
                            if (string.substring(0, 1).equals("'")) {
                                string5 = "'";
                            }
                            if (string.substring(0, 1).equals("\"")) {
                                string5 = "\"";
                            }
                        }
                        n2 = n4 + (string5 != null ? 1 : 0);
                        list = this.translateValues(n4, attribute.getValueList(string5 == null ? string : string.substring(1)), string5);
                    }
                }
            } else if (tokenId == HTMLTokenId.SCRIPT) {
                list = this.addEndTag(SCRIPT_TAG_NAME, string, n);
            } else if (tokenId == HTMLTokenId.STYLE) {
                list = this.addEndTag(STYLE_TAG_NAME, string, n);
            }
            object = list == null ? null : new CompletionResult(list, n2);
            return object;
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        finally {
            baseDocument.readUnlock();
        }
        return null;
    }

    private List<CompletionItem> addEndTag(String string, String string2, int n) {
        int n2 = this.getLastCommonCharIndex("</" + string + ">", isXHtml ? string2.trim() : string2.toUpperCase().trim());
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 == string2.trim().length()) {
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(1);
            string = isXHtml ? string : (lowerCase ? string.toLowerCase(Locale.ENGLISH) : string);
            arrayList.add(HtmlCompletionItem.createEndTag(string, n - n2, null, -1));
            return arrayList;
        }
        return null;
    }

    public List getPossibleEndTags(Document document, int n, String string, DTD dTD) throws BadLocationException {
        string = isXHtml ? string : string.toUpperCase();
        int n2 = string.length();
        HtmlSyntaxSupport htmlSyntaxSupport = HtmlSyntaxSupport.get((Document)document);
        SyntaxElement syntaxElement = htmlSyntaxSupport.getElementChain(n);
        Stack<String> stack = new Stack<String>();
        ArrayList<HtmlCompletionItem> arrayList = new ArrayList<HtmlCompletionItem>();
        HashSet<String> hashSet = new HashSet<String>();
        if (syntaxElement == null) {
            if (n > 0) {
                syntaxElement = htmlSyntaxSupport.getElementChain(n - 1);
                if (syntaxElement == null) {
                    return arrayList;
                }
            } else {
                return arrayList;
            }
        }
        int n3 = 0;
        for (syntaxElement = syntaxElement.getPrevious(); syntaxElement != null; syntaxElement = syntaxElement.getPrevious()) {
            DTD.Element element;
            String string2;
            if (syntaxElement.getType() == 5) {
                string2 = ((SyntaxElement.Named)syntaxElement).getName().trim();
                if (string2.length() == 0) continue;
                element = dTD.getElement(string2);
                if (element != null) {
                    String string3 = ((SyntaxElement.Named)syntaxElement).getName();
                    stack.push(isXHtml ? string3 : string3.toUpperCase());
                    continue;
                }
                stack.push(string2);
                continue;
            }
            if (syntaxElement.getType() != 4 || ((SyntaxElement.Tag)syntaxElement).isEmpty()) continue;
            string2 = ((SyntaxElement.Named)syntaxElement).getName();
            element = dTD.getElement(string2);
            if (element != null) {
                string2 = element.getName();
                if (element.isEmpty()) continue;
            }
            if (stack.empty()) {
                if (string2.startsWith(string) && !hashSet.contains(string2)) {
                    hashSet.add(string2);
                    if (element != null) {
                        string2 = isXHtml ? string2 : (lowerCase ? string2.toLowerCase(Locale.ENGLISH) : string2);
                        arrayList.add(HtmlCompletionItem.createEndTag(string2, n - 2 - n2, string2, n3));
                    } else {
                        arrayList.add(HtmlCompletionItem.createEndTag(string2, n - 2 - n2, null, n3));
                    }
                }
                if (element == null || element.hasOptionalEnd()) continue;
                break;
            }
            if (stack.peek().equals(string2)) {
                stack.pop();
                continue;
            }
            if (element != null && !element.hasOptionalEnd()) break;
        }
        return arrayList;
    }

    public List getAutocompletedEndTag(Document document, int n, DTD dTD) {
        ArrayList<HtmlCompletionItem> arrayList = new ArrayList<HtmlCompletionItem>();
        HtmlSyntaxSupport htmlSyntaxSupport = HtmlSyntaxSupport.get((Document)document);
        try {
            SyntaxElement syntaxElement = htmlSyntaxSupport.getElementChain(n - 1);
            if (syntaxElement != null && syntaxElement.getType() == 4) {
                String string = ((SyntaxElement.Named)syntaxElement).getName();
                DTD.Element element = dTD.getElement(string);
                if (!(((SyntaxElement.Tag)syntaxElement).isEmpty() || element != null && element.isEmpty())) {
                    if (element != null) {
                        string = lowerCase ? string.toLowerCase(Locale.ENGLISH) : string.toUpperCase(Locale.ENGLISH);
                    }
                    HtmlCompletionItem htmlCompletionItem = HtmlCompletionItem.createAutocompleteEndTag(string, n);
                    arrayList.add(htmlCompletionItem);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return arrayList;
    }

    private int getLastCommonCharIndex(String string, String string2) {
        int n;
        for (n = 0; n < string.length() && n < string2.length(); ++n) {
            if (string.charAt(n) == string2.charAt(n)) continue;
            --n;
            break;
        }
        return n;
    }

    List<CompletionItem> translateCharRefs(int n, List list) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        for (DTD.CharRef charRef : list) {
            String string = charRef.getName();
            arrayList.add(HtmlCompletionItem.createCharacterReference(string, charRef.getValue(), n, string));
        }
        return arrayList;
    }

    List<CompletionItem> translateTags(int n, List list) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((DTD.Element)iterator.next()).getName();
            string = isXHtml ? string : (lowerCase ? string.toLowerCase(Locale.ENGLISH) : string.toUpperCase());
            arrayList.add(HtmlCompletionItem.createTag(string, n, string));
        }
        return arrayList;
    }

    List<CompletionItem> translateAttribs(int n, List<DTD.Attribute> list, DTD.Element element) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        String string = element.getName() + "#";
        for (DTD.Attribute attribute : list) {
            String string2 = attribute.getName();
            switch (attribute.getType()) {
                case 0: {
                    arrayList.add(HtmlCompletionItem.createBooleanAttribute(string2, n, attribute.isRequired(), string + string2));
                    break;
                }
                case 1: 
                case 2: {
                    arrayList.add(HtmlCompletionItem.createAttribute(string2, n, attribute.isRequired(), string + string2));
                }
            }
        }
        return arrayList;
    }

    List<CompletionItem> translateValues(int n, List list) {
        return this.translateValues(n, list, null);
    }

    List<CompletionItem> translateValues(int n, List list, String string) {
        if (list == null) {
            return new ArrayList<CompletionItem>(0);
        }
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        if (string != null) {
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(HtmlCompletionItem.createAttributeValue(((DTD.Value)iterator.next()).getName(), n));
        }
        return arrayList;
    }

    static {
        isXHtml = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompletionResult {
        private List<CompletionItem> items;
        int anchor;

        CompletionResult(List<CompletionItem> list, int n) {
            this.items = list;
            this.anchor = n;
        }

        public int getAnchor() {
            return this.anchor;
        }

        public List<CompletionItem> getItems() {
            return this.items;
        }
    }
}

