/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.dtd.ReaderProvider;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public class NbReaderProvider
implements ReaderProvider {
    private static final String DTD_FOLDER = "DTDs";
    private static final String CATALOG_FILE_NAME = "catalog";
    private static boolean setUp = false;
    Map mapping = null;
    boolean valid = false;
    FileObject dtdSetFolder;
    static Map folder2provider = new HashMap();

    public static synchronized void setupReaders() {
        if (!setUp) {
            FileObject fileObject = FileUtil.getConfigRoot();
            fileObject.addFileChangeListener((FileChangeListener)new RootFolderListener());
            FileObject fileObject2 = fileObject.getFileObject(DTD_FOLDER);
            if (fileObject2 != null) {
                fileObject2.addFileChangeListener((FileChangeListener)new DTDFolderListener());
                NbReaderProvider.processSubfolders(fileObject2);
            }
            setUp = true;
        }
    }

    public NbReaderProvider(FileObject fileObject) {
        this.dtdSetFolder = fileObject;
        this.revalidate(true);
        fileObject.addFileChangeListener((FileChangeListener)new ProviderFolderListener());
    }

    public Collection getIdentifiers() {
        return this.valid ? this.mapping.keySet() : new HashSet(0);
    }

    public Reader getReaderForIdentifier(String string, String string2) {
        if (!this.valid) {
            return null;
        }
        String string3 = (String)this.mapping.get(string);
        if (string3 == null) {
            return null;
        }
        if (this.dtdSetFolder == null) {
            return null;
        }
        FileObject fileObject = this.dtdSetFolder.getFileObject(string3);
        if (string3 == null) {
            return null;
        }
        try {
            return new InputStreamReader(fileObject.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private void invalidate() {
        if (this.valid) {
            this.valid = false;
            Registry.invalidateReaderProvider((ReaderProvider)this);
        }
    }

    private boolean revalidate(boolean bl) {
        Object object;
        if (this.mapping == null || bl) {
            object = this.dtdSetFolder.getFileObject(CATALOG_FILE_NAME);
            if (object == null) {
                this.mapping = null;
            } else {
                try {
                    this.mapping = this.parseCatalog(new InputStreamReader(object.getInputStream()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.mapping = null;
                }
            }
            if (this.mapping == null) {
                this.invalidate();
                return false;
            }
        }
        object = this.mapping.values();
        boolean bl2 = true;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.dtdSetFolder.getFileObject(string) != null) continue;
            bl2 = false;
            break;
        }
        if (!bl2) {
            this.invalidate();
        }
        this.valid = bl2;
        return this.valid;
    }

    private Map parseCatalog(Reader reader) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        while (true) {
            String string;
            try {
                string = lineNumberReader.readLine();
            }
            catch (IOException iOException) {
                return null;
            }
            if (string == null) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens() || !"PUBLIC".equals(stringTokenizer.nextToken()) || !stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken("\"");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken("\"");
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken(" \t\n\r\f");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private static void processSubfolders(FileObject fileObject) {
        Enumeration enumeration = fileObject.getFolders(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            NbReaderProvider.addFolder(fileObject2);
        }
    }

    private static void removeSubfolders() {
        Iterator iterator = folder2provider.entrySet().iterator();
        folder2provider = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ReaderProvider readerProvider = (ReaderProvider)entry.getValue();
            Registry.unregisterReaderProvider((ReaderProvider)readerProvider);
        }
    }

    private static void addFolder(FileObject fileObject) {
        NbReaderProvider nbReaderProvider = new NbReaderProvider(fileObject);
        folder2provider.put(fileObject.getNameExt(), nbReaderProvider);
        Registry.registerReaderProvider((ReaderProvider)nbReaderProvider);
    }

    private static void removeFolder(FileObject fileObject) {
        NbReaderProvider nbReaderProvider = (NbReaderProvider)folder2provider.remove(fileObject.getNameExt());
        if (nbReaderProvider != null) {
            Registry.unregisterReaderProvider((ReaderProvider)nbReaderProvider);
        }
    }

    private static class DTDFolderListener
    extends FileChangeAdapter {
        private DTDFolderListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            NbReaderProvider.addFolder(fileObject);
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            NbReaderProvider.removeFolder(fileObject);
        }
    }

    private static class RootFolderListener
    extends FileChangeAdapter {
        private RootFolderListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (NbReaderProvider.DTD_FOLDER.equals(fileObject.getNameExt())) {
                fileObject.addFileChangeListener((FileChangeListener)new DTDFolderListener());
                NbReaderProvider.processSubfolders(fileObject);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (NbReaderProvider.DTD_FOLDER.equals(fileObject.getNameExt())) {
                NbReaderProvider.removeSubfolders();
            }
        }
    }

    private class ProviderFolderListener
    extends FileChangeAdapter {
        private ProviderFolderListener() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (!NbReaderProvider.this.valid) {
                boolean bl = true;
                NbReaderProvider.this.revalidate(bl);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (NbReaderProvider.this.valid) {
                NbReaderProvider.this.revalidate(true);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            NbReaderProvider.this.invalidate();
            NbReaderProvider.this.revalidate(true);
        }

        public void fileChanged(FileEvent fileEvent) {
            NbReaderProvider.this.invalidate();
            NbReaderProvider.this.revalidate(true);
        }
    }
}

