/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstNode {
    private String name;
    private NodeType nodeType;
    private int startOffset;
    private int endOffset;
    private int logicalEndOffset;
    private List<AstNode> children = null;
    private AstNode parent = null;
    private Map<String, Object> attributes = null;
    private DTD.Content content = null;
    private DTD.ContentModel contentModel = null;
    private DTD.Element dtdElement = null;
    private Collection<Description> descriptions = null;
    private List<String> stack = null;
    private AstNode matchingNode = null;

    AstNode(String string, NodeType nodeType, int n, int n2, DTD.Element element, List<String> list) {
        this(string, nodeType, n, n2);
        this.dtdElement = element;
        this.contentModel = element != null ? element.getContentModel() : null;
        this.content = this.contentModel != null ? this.contentModel.getContent() : null;
        this.stack = list;
    }

    AstNode(String string, NodeType nodeType, int n, int n2) {
        this.name = string;
        this.nodeType = nodeType;
        this.startOffset = n;
        this.endOffset = n2;
        this.logicalEndOffset = n2;
    }

    public AstNode getMatchingTag() {
        return this.matchingNode;
    }

    public int[] getLogicalRange() {
        return new int[]{this.startOffset, this.logicalEndOffset};
    }

    void setLogicalEndOffset(int n) {
        this.logicalEndOffset = n;
    }

    void setMatchingNode(AstNode astNode) {
        this.matchingNode = astNode;
    }

    public boolean needsToHaveMatchingTag() {
        if (this.type() == NodeType.OPEN_TAG) {
            return !this.getDTDElement().hasOptionalEnd();
        }
        if (this.type() == NodeType.ENDTAG) {
            return !this.getDTDElement().hasOptionalStart();
        }
        return false;
    }

    DTD.Element getDTDElement() {
        return this.dtdElement;
    }

    boolean reduce(DTD.Element element) {
        if (this.contentModel == null) {
            return false;
        }
        if (this.contentModel.getExcludes().contains(element)) {
            return false;
        }
        if (this.contentModel.getIncludes().contains(element)) {
            return true;
        }
        DTD.Content content = this.content.reduce(element.getName());
        if (content != null) {
            this.content = content;
            return true;
        }
        for (Object e : this.contentModel.getContent().getPossibleElements()) {
            DTD.Content content2;
            DTD.Element element2 = (DTD.Element)e;
            if (element2 == null || !element2.hasOptionalStart() || !element2.hasOptionalEnd() || (content2 = element2.getContentModel().getContent().reduce(element.getName())) == null) continue;
            this.content = DTD.Content.EMPTY_CONTENT;
            return true;
        }
        return false;
    }

    boolean isResolved() {
        DTD.ContentLeaf contentLeaf;
        if (this.content == null) {
            return false;
        }
        if (this.content instanceof DTD.ContentLeaf && ("CDATA".equals((contentLeaf = (DTD.ContentLeaf)this.content).getElementName()) || "EMPTY".equals(contentLeaf.getElementName()))) {
            return true;
        }
        if (this.content.getPossibleElements().size() == 1 && this.content.getPossibleElements().iterator().next() == null) {
            return true;
        }
        return this.content == DTD.Content.EMPTY_CONTENT || this.content.isDiscardable();
    }

    Collection<DTD.Element> getUnresolvedElements() {
        if (!this.isResolved()) {
            return this.content.getPossibleElements();
        }
        return null;
    }

    Collection<DTD.Element> getAllPossibleElements() {
        if (this.content == null) {
            System.out.println("getPossibleElements() == null for " + this.toString());
            return null;
        }
        ArrayList<DTD.Element> arrayList = new ArrayList<DTD.Element>();
        arrayList.addAll(this.content.getPossibleElements());
        arrayList.addAll(this.contentModel.getIncludes());
        arrayList.removeAll(this.contentModel.getExcludes());
        return arrayList;
    }

    synchronized void addDescriptionToNode(String string, String string2, int n) {
        int n2 = this.startOffset();
        int n3 = this.endOffset();
        if (this.type() == NodeType.OPEN_TAG && (n3 = n2 + 1 + this.name().length()) == this.endOffset() - 1) {
            ++n3;
        }
        this.addDescription(Description.create(string, string2, n, n2, n3));
    }

    synchronized void addDescriptionsToNode(Collection<String[]> collection, int n) {
        for (String[] stringArray : collection) {
            this.addDescriptionToNode(stringArray[0], stringArray[1], n);
        }
    }

    synchronized void addDescription(Description description) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Description>(2);
        }
        this.descriptions.add(description);
    }

    synchronized void addDescriptions(Collection<Description> collection) {
        if (this.descriptions == null) {
            this.descriptions = new LinkedHashSet<Description>(2);
        }
        this.descriptions.addAll(collection);
    }

    public Collection<Description> getDescriptions() {
        return this.descriptions == null ? Collections.emptyList() : this.descriptions;
    }

    public String name() {
        return this.name;
    }

    public NodeType type() {
        return this.nodeType;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public List<AstNode> children() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    void addChild(AstNode astNode) {
        if (this.children == null) {
            this.children = new LinkedList<AstNode>();
        }
        this.children.add(astNode);
        astNode.setParent(this);
    }

    void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, object);
    }

    public Collection<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public Object getAttribute(String string) {
        return this.attributes == null ? null : this.attributes.get(string);
    }

    public String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = this.type() == NodeType.OPEN_TAG || this.type() == NodeType.ENDTAG;
        if (bl) {
            stringBuffer.append(this.type() == NodeType.OPEN_TAG ? "<" : "");
            stringBuffer.append(this.type() == NodeType.ENDTAG ? "</" : "");
        }
        stringBuffer.append(this.name());
        if (bl) {
            stringBuffer.append('>');
        } else {
            stringBuffer.append(':');
            stringBuffer.append((Object)this.type());
        }
        stringBuffer.append('(');
        stringBuffer.append(this.startOffset());
        stringBuffer.append('-');
        stringBuffer.append(this.endOffset());
        if (this.logicalEndOffset != this.endOffset) {
            stringBuffer.append('/');
            stringBuffer.append(this.logicalEndOffset);
        }
        stringBuffer.append(')');
        DTD.Element element = this.getDTDElement();
        if (element != null) {
            stringBuffer.append("[");
            stringBuffer.append(element.hasOptionalStart() ? "O" : "R");
            stringBuffer.append(element.hasOptionalEnd() ? "O" : "R");
            if (element.isEmpty()) {
                stringBuffer.append("E");
            }
            stringBuffer.append(this.isResolved() ? "" : "!");
            stringBuffer.append("]");
        }
        for (Description object : this.getDescriptions()) {
            stringBuffer.append(object.getKey());
            stringBuffer.append(' ');
        }
        if (this.stack != null) {
            stringBuffer.append(";S:");
            for (String string : this.stack) {
                stringBuffer.append(string);
                stringBuffer.append(',');
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    String signature() {
        return this.name() + "[" + (Object)((Object)this.type()) + "]";
    }

    public AstNode parent() {
        return this.parent;
    }

    public AstPath path() {
        return new AstPath(null, this);
    }

    private void setParent(AstNode astNode) {
        this.parent = astNode;
    }

    public static final class Description {
        public static final int INFORMATION = 0;
        public static final int WARNING = 1;
        public static final int ERROR = 2;
        private String key;
        private String text;
        private int from;
        private int to;
        private int type;

        public static Description create(String string, String string2, int n, int n2, int n3) {
            return new Description(string, string2, n, n2, n3);
        }

        private Description(String string, String string2, int n, int n2, int n3) {
            this.key = string;
            this.text = string2;
            this.type = n;
            this.from = n2;
            this.to = n3;
        }

        public String getKey() {
            return this.key;
        }

        public int getType() {
            return this.type;
        }

        public int getFrom() {
            return this.from;
        }

        public String getText() {
            return this.text;
        }

        public int getTo() {
            return this.to;
        }

        public String toString() {
            return this.dump(null);
        }

        public String dump(String string) {
            String string2 = "";
            switch (this.getType()) {
                case 0: {
                    string2 = "Information";
                    break;
                }
                case 1: {
                    string2 = "Warning";
                    break;
                }
                case 2: {
                    string2 = "Error";
                }
            }
            String string3 = string == null ? "" : string.substring(this.getFrom(), this.getTo());
            return string2 + ":" + this.getKey() + " [" + this.getFrom() + " - " + this.getTo() + "]: '" + string3 + (this.getText() != null ? "'; msg=" + this.getText() : "");
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Description description = (Description)object;
            if (this.key == null ? description.key != null : !this.key.equals(description.key)) {
                return false;
            }
            if (this.from != description.from) {
                return false;
            }
            if (this.to != description.to) {
                return false;
            }
            return this.type == description.type;
        }

        public int hashCode() {
            int n = 3;
            n = 23 * n + (this.key != null ? this.key.hashCode() : 0);
            n = 23 * n + this.from;
            n = 23 * n + this.to;
            n = 23 * n + this.type;
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        UNKNOWN_TAG,
        ROOT,
        COMMENT,
        DECLARATION,
        ERROR,
        TEXT,
        TAG,
        UNMATCHED_TAG,
        OPEN_TAG,
        ENDTAG,
        ENTITY_REFERENCE;

    }
}

