/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.HtmlSyntaxSupport;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.modules.editor.structure.formatting.JoinedTokenSequence;
import org.netbeans.modules.editor.structure.formatting.TagBasedLexerFormatter;

public class HtmlLexerFormatter
extends TagBasedLexerFormatter {
    public static final String HTML_FORMATTER_ACTS_ON_TOP_LEVEL = "HTML_FORMATTER_ACTS_ON_TOP_LEVEL";
    private static final String[] UNFORMATTABLE_TAGS = new String[]{"pre", "script", "code", "textarea"};
    private final LanguagePath languagePath;

    public HtmlLexerFormatter(LanguagePath languagePath) {
        this.languagePath = languagePath;
    }

    protected int getTagEndingAtPosition(JoinedTokenSequence joinedTokenSequence, int n) throws BadLocationException {
        if (n >= 0) {
            int n2 = joinedTokenSequence.offset();
            joinedTokenSequence.move(n);
            joinedTokenSequence.moveNext();
            Token token = joinedTokenSequence.token();
            if (token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL && !((Object)token.text()).toString().endsWith("/>")) {
                while (joinedTokenSequence.movePrevious()) {
                    int n3 = joinedTokenSequence.offset();
                    if (!this.isOpeningTag(joinedTokenSequence, n3) && !this.isClosingTag(joinedTokenSequence, n3)) continue;
                    int n4 = joinedTokenSequence.offset();
                    joinedTokenSequence.move(n2);
                    joinedTokenSequence.moveNext();
                    return n4;
                }
            }
            joinedTokenSequence.move(n2);
            joinedTokenSequence.moveNext();
        }
        return -1;
    }

    protected int getTagEndOffset(JoinedTokenSequence joinedTokenSequence, int n) {
        boolean bl;
        int n2 = joinedTokenSequence.offset();
        joinedTokenSequence.move(n);
        joinedTokenSequence.moveNext();
        for (bl = true; bl && joinedTokenSequence.token().id() != HTMLTokenId.TAG_CLOSE_SYMBOL; bl &= joinedTokenSequence.moveNext()) {
        }
        int n3 = joinedTokenSequence.offset() + joinedTokenSequence.token().length();
        joinedTokenSequence.move(n2);
        joinedTokenSequence.moveNext();
        return bl ? n3 : -1;
    }

    protected boolean isJustBeforeClosingTag(JoinedTokenSequence joinedTokenSequence, int n) throws BadLocationException {
        return super.isJustBeforeClosingTag(joinedTokenSequence, n + "</".length());
    }

    protected boolean isClosingTag(JoinedTokenSequence joinedTokenSequence, int n) {
        Token token = this.getTokenAtOffset(joinedTokenSequence, n);
        return token != null && token.id() == HTMLTokenId.TAG_CLOSE;
    }

    protected boolean isOpeningTag(JoinedTokenSequence joinedTokenSequence, int n) {
        Token token = this.getTokenAtOffset(joinedTokenSequence, n);
        return token != null && token.id() == HTMLTokenId.TAG_OPEN;
    }

    protected String extractTagName(JoinedTokenSequence joinedTokenSequence, int n) {
        return ((Object)this.getTokenAtOffset(joinedTokenSequence, n).text()).toString().trim();
    }

    protected boolean areTagNamesEqual(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    protected int getOpeningSymbolOffset(JoinedTokenSequence joinedTokenSequence, int n) {
        int n2 = joinedTokenSequence.offset();
        joinedTokenSequence.move(n);
        boolean bl = true;
        while ((bl = joinedTokenSequence.movePrevious()) && joinedTokenSequence.token().id() != HTMLTokenId.TAG_OPEN_SYMBOL) {
        }
        if (bl) {
            int n3 = joinedTokenSequence.offset();
            joinedTokenSequence.move(n2);
            joinedTokenSequence.moveNext();
            return n3;
        }
        joinedTokenSequence.move(n2);
        joinedTokenSequence.moveNext();
        return -1;
    }

    protected boolean isClosingTagRequired(BaseDocument baseDocument, String string) {
        HtmlSyntaxSupport htmlSyntaxSupport = HtmlSyntaxSupport.get((Document)baseDocument);
        DTD dTD = htmlSyntaxSupport.getDTD();
        if (dTD == null) {
            return false;
        }
        DTD.Element element = dTD.getElement(string.toUpperCase());
        if (element == null) {
            return true;
        }
        return !element.isEmpty();
    }

    protected boolean isUnformattableToken(JoinedTokenSequence joinedTokenSequence, int n) {
        Token token = this.getTokenAtOffset(joinedTokenSequence, n);
        return token.id() == HTMLTokenId.BLOCK_COMMENT;
    }

    protected boolean isUnformattableTag(String string) {
        for (int i = 0; i < UNFORMATTABLE_TAGS.length; ++i) {
            if (!string.equalsIgnoreCase(UNFORMATTABLE_TAGS[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isTopLevelLanguage(BaseDocument baseDocument) {
        return super.isTopLevelLanguage(baseDocument) || baseDocument.getProperty((Object)HTML_FORMATTER_ACTS_ON_TOP_LEVEL) != null;
    }

    protected LanguagePath supportedLanguagePath() {
        return this.languagePath;
    }
}

