/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HtmlSyntax;
import org.netbeans.editor.ext.html.HtmlSyntaxSupport;
import org.netbeans.editor.ext.html.HtmlTokenContext;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.modules.editor.structure.formatting.TagBasedFormatter;

public class HtmlFormatter
extends TagBasedFormatter {
    private static final String[] UNFORMATTABLE_TAGS = new String[]{"pre", "script", "code", "textarea"};

    public HtmlFormatter(Class clazz) {
        super(clazz);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof HtmlSyntax;
    }

    protected ExtSyntaxSupport getSyntaxSupport(BaseDocument baseDocument) {
        return HtmlSyntaxSupport.get((Document)baseDocument);
    }

    protected TokenItem getTagTokenEndingAtPosition(BaseDocument baseDocument, int n) throws BadLocationException {
        HtmlSyntaxSupport htmlSyntaxSupport;
        TokenItem tokenItem;
        if (n >= 0 && (tokenItem = (htmlSyntaxSupport = HtmlSyntaxSupport.get((Document)baseDocument)).getTokenChain(n, n + 1)).getTokenID() == HtmlTokenContext.TAG_CLOSE_SYMBOL && !tokenItem.getImage().endsWith("/>")) {
            while ((tokenItem = tokenItem.getPrevious()) != null && !this.isOpeningTag(tokenItem) && !this.isClosingTag(tokenItem)) {
            }
            return tokenItem;
        }
        return null;
    }

    protected int getTagEndOffset(TokenItem tokenItem) {
        TokenItem tokenItem2;
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getTokenID() != HtmlTokenContext.TAG_CLOSE_SYMBOL; tokenItem2 = tokenItem2.getNext()) {
        }
        return tokenItem2 == null ? -1 : tokenItem2.getOffset();
    }

    protected boolean isJustBeforeClosingTag(BaseDocument baseDocument, int n) throws BadLocationException {
        return super.isJustBeforeClosingTag(baseDocument, n + "</".length());
    }

    protected boolean isClosingTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == HtmlTokenContext.TAG_CLOSE;
    }

    protected boolean isOpeningTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == HtmlTokenContext.TAG_OPEN;
    }

    protected String extractTagName(TokenItem tokenItem) {
        return tokenItem.getImage().trim();
    }

    protected boolean areTagNamesEqual(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    protected int getOpeningSymbolOffset(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem;
        while ((tokenItem2 = tokenItem2.getPrevious()) != null && tokenItem2.getTokenID() != HtmlTokenContext.TAG_OPEN_SYMBOL) {
        }
        if (tokenItem2 != null) {
            return tokenItem2.getOffset();
        }
        return -1;
    }

    protected boolean isClosingTagRequired(BaseDocument baseDocument, String string) {
        HtmlSyntaxSupport htmlSyntaxSupport = HtmlSyntaxSupport.get((Document)baseDocument);
        DTD dTD = htmlSyntaxSupport.getDTD();
        if (dTD == null) {
            return false;
        }
        DTD.Element element = dTD.getElement(string.toUpperCase());
        if (element == null) {
            return true;
        }
        return !element.isEmpty();
    }

    protected boolean isUnformattableToken(TokenItem tokenItem) {
        return tokenItem.getTokenID() == HtmlTokenContext.BLOCK_COMMENT;
    }

    protected boolean isUnformattableTag(String string) {
        for (int i = 0; i < UNFORMATTABLE_TAGS.length; ++i) {
            if (!string.equalsIgnoreCase(UNFORMATTABLE_TAGS[i])) continue;
            return true;
        }
        return false;
    }
}

