/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ViewRevisionAction
extends AbstractAction
implements Runnable {
    private final VCSContext ctx;
    private ViewRevisionPanel settings;

    public ViewRevisionAction(VCSContext vCSContext) {
        this(Utils.getActionName(ViewRevisionAction.class, (String)"CTL_MenuItem_ViewRevision", (VCSContext)vCSContext), vCSContext);
    }

    public ViewRevisionAction(String string, VCSContext vCSContext) {
        super(string);
        this.ctx = vCSContext;
    }

    public boolean isEnabled() {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (File file : this.ctx.getRootFiles()) {
            if (file.isDirectory() || (fileStatusCache.getStatus(file).getStatus() & 0xFF8) == 0) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Title", (Object)Utils.getContextDisplayName((VCSContext)this.ctx));
        this.settings = new ViewRevisionPanel(this.ctx);
        JButton jButton = new JButton(NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Action_View"));
        this.settings.putClientProperty("OKButton", jButton);
        this.settings.refreshComponents();
        jButton.setToolTipText(NbBundle.getMessage(ViewRevisionAction.class, (String)"TT_ViewRevisionDialog_Action_View"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.settings, string, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, new HelpCtx(ViewRevisionAction.class), null);
        dialogDescriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ViewRevisionAction.class, (String)"ACSD_ViewRevisionDialog"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        this.settings.saveSettings();
        Utils.createTask((Runnable)this).schedule(0);
    }

    public void run() {
        String string = this.settings.getRevision();
        File file = Utils.getTempFolder();
        for (File file2 : this.ctx.getRootFiles()) {
            if (file2.isDirectory()) continue;
            try {
                ViewRevisionAction.view(file2, string, file);
            }
            catch (Exception exception) {}
        }
    }

    public static void view(File file, final String string, File file2) throws Exception {
        if (file2 == null) {
            file2 = Utils.getTempFolder();
        }
        File file3 = VersionsCache.getInstance().getRemoteFile(file, string, null);
        File file4 = new File(file2, file.getName());
        file4.deleteOnExit();
        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file4), (InputStream)new FileInputStream(file3));
        Utils.associateEncoding((File)file, (File)file4);
        final FileObject fileObject = FileUtil.toFileObject((File)file4);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        final OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (editorCookie != null) {
                    Utils.openFile((FileObject)fileObject, (String)string);
                } else if (openCookie != null) {
                    openCookie.open();
                } else {
                    Utils.openFile((FileObject)fileObject, (String)string);
                }
            }
        });
    }
}

