/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.checkout;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.executor.CheckoutExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public final class CheckoutAction
extends SystemAction {
    private static final String SHOW_CHECKOUT_COMPLETED = "checkoutAction.showCheckoutCompleted";

    public CheckoutAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getBundle(CheckoutAction.class).getString("CTL_MenuItem_Checkout_Label");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CheckoutAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.perform();
    }

    public CheckoutExecutor checkout(String string, String string2, String string3, String string4, boolean bl, ExecutorGroup executorGroup) {
        Object[] objectArray;
        Serializable serializable;
        StringTokenizer stringTokenizer;
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        String string5 = string2;
        if (string5 == null || string5.length() == 0) {
            string5 = ".";
        }
        if ((stringTokenizer = new StringTokenizer(string5, ",;")).countTokens() == 1) {
            checkoutCommand.setModule(string5);
        } else {
            serializable = new ArrayList<String[]>();
            while (stringTokenizer.hasMoreTokens()) {
                objectArray = stringTokenizer.nextToken().trim();
                serializable.add((String[])objectArray);
            }
            objectArray = serializable.toArray(new String[serializable.size()]);
            checkoutCommand.setModules((String[])objectArray);
        }
        checkoutCommand.setDisplayName(NbBundle.getMessage(CheckoutAction.class, (String)"BK1006"));
        if (string3 != null) {
            checkoutCommand.setCheckoutByRevision(string3);
        } else {
            checkoutCommand.setResetStickyOnes(true);
        }
        checkoutCommand.setPruneDirectories(CvsModuleConfig.getDefault().getAutoPruneDirectories());
        checkoutCommand.setRecursive(true);
        serializable = new File(string4);
        objectArray = new File[]{serializable};
        checkoutCommand.setFiles((File[])objectArray);
        CvsVersioningSystem cvsVersioningSystem = CvsVersioningSystem.getInstance();
        GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
        globalOptions.setCVSRoot(string);
        boolean bl2 = false;
        if (executorGroup == null) {
            bl2 = true;
            executorGroup = new ExecutorGroup(NbBundle.getMessage(CheckoutAction.class, (String)"BK1013"));
        }
        CheckoutExecutor checkoutExecutor = new CheckoutExecutor(cvsVersioningSystem, checkoutCommand, globalOptions);
        executorGroup.addExecutor(checkoutExecutor);
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean(SHOW_CHECKOUT_COMPLETED, true) && bl) {
            executorGroup.addBarrier(new CheckoutCompletedController(checkoutExecutor, (File)serializable));
        }
        if (bl2) {
            executorGroup.execute();
        }
        return checkoutExecutor;
    }

    public void perform() {
        CheckoutWizard checkoutWizard = new CheckoutWizard();
        if (!checkoutWizard.show()) {
            return;
        }
        final String string = checkoutWizard.getTag();
        final String string2 = checkoutWizard.getModules();
        final String string3 = checkoutWizard.getWorkingDir();
        final String string4 = checkoutWizard.getCvsRoot();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CheckoutAction.this.checkout(string4, string2, string, string3, true, null);
            }
        });
    }

    private class CheckoutCompletedController
    implements Runnable {
        private final CheckoutExecutor executor;
        private final File workingFolder;

        public CheckoutCompletedController(CheckoutExecutor checkoutExecutor, File file) {
            this.executor = checkoutExecutor;
            this.workingFolder = file;
        }

        public void run() {
            if (!this.executor.isSuccessful()) {
                return;
            }
            HashMap hashMap = new HashMap();
            hashMap.put(null, new HashSet());
            File file = FileUtil.normalizeFile((File)this.workingFolder);
            this.refreshRecursively(file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                String string = NbBundle.getMessage(CheckoutAction.class, (String)"BK1007");
                this.executor.getGroup().progress(string);
                for (String string2 : this.executor.getExpandedModules()) {
                    if (".".equals(string2)) {
                        ProjectUtilities.scanForProjects((FileObject)fileObject, hashMap);
                        break;
                    }
                    FileObject fileObject2 = fileObject.getFileObject(string2);
                    if (fileObject2 == null) continue;
                    this.executor.getGroup().progress(string);
                    ProjectUtilities.scanForProjects((FileObject)fileObject2, hashMap);
                }
            }
            ProjectUtilities.openCheckedOutProjects(hashMap, (File)this.workingFolder);
        }

        private void refreshRecursively(File file) {
            if (file == null) {
                return;
            }
            this.refreshRecursively(file.getParentFile());
            CvsVersioningSystem.getInstance().getStatusCache().refresh(file, 0);
        }
    }
}

