/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.view;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ViewAction
extends ContextAction {
    private final VCSContext context;
    private static final String HG_SCRIPTS_DIR = "scripts";

    public ViewAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        final File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        RequestProcessor requestProcessor = RequestProcessor.getDefault();
        requestProcessor.post(new Runnable(){

            public void run() {
                ViewAction.performView(file);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void performView(File file) {
        OutputLogger outputLogger = OutputLogger.getLogger(file.getAbsolutePath());
        try {
            try {
                outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_TITLE"));
                outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_TITLE_SEP"));
                String string = "hgk";
                if (Utilities.isWindows()) {
                    string = string + ".cmd";
                }
                boolean bl = false;
                if (HgUtils.isInUserPath(string)) {
                    bl = true;
                } else if (HgUtils.isSolaris()) {
                    File file2 = new File("/usr/demo/mercurial", string);
                    if (file2.exists() && file2.isFile()) {
                        bl = true;
                    }
                } else if (Utilities.isWindows()) {
                    bl = HgUtils.isInUserPath(HG_SCRIPTS_DIR + File.separator + string);
                }
                boolean bl2 = HgConfigFiles.getSysInstance().containsProperty("extensions", "hgext.hgk");
                if (!bl) {
                    outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND_INFO"));
                    outputLogger.output("");
                    outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND"));
                    outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND_TITLE"));
                }
                if (!bl2) {
                    boolean bl3 = false;
                    bl3 = HgUtils.confirmDialog(ViewAction.class, "MSG_VIEW_SETHGK_PROP_CONFIRM_TITLE", "MSG_VIEW_SETHGK_PROP_CONFIRM_QUERY");
                    if (!bl3) {
                        outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_NOTSETHGK_PROP_INFO"));
                        outputLogger.output("");
                        outputLogger.closeLog();
                        Object var8_10 = null;
                        outputLogger.closeLog();
                        return;
                    }
                    outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_SETHGK_PROP_DO_INFO"));
                    HgConfigFiles hgConfigFiles = HgConfigFiles.getSysInstance();
                    if (hgConfigFiles.getException() == null) {
                        hgConfigFiles.setProperty("hgext.hgk", "");
                    } else {
                        Mercurial.LOG.log(Level.WARNING, ViewAction.class.getName() + ": Cannot set hgk property");
                        Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
                        HgModuleConfig.notifyParsingError();
                    }
                }
                outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_LAUNCH_INFO", (Object)file.getAbsolutePath()));
                outputLogger.output("");
                HgCommand.doView(file, outputLogger);
            }
            catch (HgException hgException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                Object var8_12 = null;
                outputLogger.closeLog();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            outputLogger.closeLog();
            throw throwable;
        }
        Object var8_11 = null;
        outputLogger.closeLog();
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

