/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.status.VersioningPanel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class HgVersioningTopComponent
extends TopComponent {
    private static final long serialVersionUID = 1L;
    private VersioningPanel syncPanel;
    private VCSContext context;
    private String contentTitle;
    private String branchTitle;
    private long lastUpdateTimestamp;
    private static final String PREFERRED_ID = "hgversioning";
    private static HgVersioningTopComponent instance;

    public HgVersioningTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/mercurial/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.syncPanel = new VersioningPanel(this);
        this.add(this.syncPanel);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.syncPanel.focus();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    private void refreshContent() {
        if (this.syncPanel == null) {
            return;
        }
        this.updateTitle();
        this.syncPanel.setContext(this.context);
    }

    public void setContentTitle(String string) {
        this.contentTitle = string;
        this.updateTitle();
    }

    void setBranchTitle(String string) {
        this.branchTitle = string;
        this.updateTitle();
    }

    public void contentRefreshed() {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.updateTitle();
    }

    private void updateTitle() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (HgVersioningTopComponent.this.contentTitle == null) {
                    HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
                } else {
                    File file = HgUtils.getRootFile(HgVersioningTopComponent.this.context);
                    String string = "";
                    if (file != null) {
                        string = file.getName();
                    }
                    if (HgVersioningTopComponent.this.branchTitle == null) {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_MultiTitle", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(string.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + string + "]")));
                    } else {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title_ContentBranch", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(string.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + string + "] "), (Object)HgVersioningTopComponent.this.branchTitle));
                    }
                }
            }
        });
    }

    String getContentTitle() {
        return this.contentTitle;
    }

    public static synchronized HgVersioningTopComponent getDefault() {
        if (instance == null) {
            instance = new HgVersioningTopComponent();
        }
        return instance;
    }

    public static synchronized HgVersioningTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Mercurial.LOG.log(Level.FINE, "Cannot find hgversioning component. It will not be located properly in the window system.");
            return HgVersioningTopComponent.getDefault();
        }
        if (topComponent instanceof HgVersioningTopComponent) {
            return (HgVersioningTopComponent)topComponent;
        }
        Mercurial.LOG.log(Level.FINE, "There seem to be multiple components with the 'hgversioning' ID. That is a potential source of errors and unexpected behavior.");
        return HgVersioningTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void performRefreshAction() {
        this.syncPanel.performRefreshAction();
    }

    public void setContext(VCSContext vCSContext) {
        this.syncPanel.cancelRefresh();
        if (vCSContext == null) {
            this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"MSG_Preparing"));
            this.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.context = vCSContext;
            this.syncPanel.setContext(vCSContext);
            this.setBranchTitle(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_VersioningView_UnnamedBranchTitle"));
            this.refreshContent();
        }
        this.setToolTipText(this.getContextFilesList(vCSContext, NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title")));
    }

    private String getContextFilesList(VCSContext vCSContext, String string) {
        if (vCSContext == null || vCSContext.getRootFiles().size() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<html>");
        for (File file : vCSContext.getRootFiles()) {
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append("<br>");
        }
        stringBuffer.delete(stringBuffer.length() - 4, Integer.MAX_VALUE);
        return stringBuffer.toString();
    }

    public boolean hasContext() {
        return this.context != null && this.context.getRootFiles().size() > 0;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return HgVersioningTopComponent.getDefault();
        }
    }
}

