/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rollback;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VerifyAction
extends ContextAction {
    private final VCSContext context;

    public VerifyAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        VerifyAction.verify(this.context);
    }

    public static void verify(VCSContext vCSContext) {
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                try {
                    block4: {
                        try {
                            outputLogger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_TITLE"));
                            outputLogger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_TITLE_SEP"));
                            outputLogger.output(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_INFO", (Object)file.getAbsolutePath()));
                            List<String> list = HgCommand.doVerify(file, outputLogger);
                            if (list == null || list.isEmpty()) break block4;
                            outputLogger.output(list);
                        }
                        catch (HgException hgException) {
                            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                            Object var5_5 = null;
                            outputLogger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_DONE"));
                            outputLogger.output("");
                        }
                    }
                    Object var5_4 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_DONE"));
                    outputLogger.output("");
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_DONE"));
                    outputLogger.output("");
                    throw throwable;
                }
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_PROGRESS"));
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

