/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.push;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.hooks.spi.HgHookContext;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.pull.PullAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushAction
extends ContextAction {
    private final VCSContext context;

    public PushAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            outputLogger.closeLog();
            return;
        }
        PushAction.push(this.context);
    }

    @Override
    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.getRootFile(this.context) != null && set != null && set.size() != 0;
    }

    public static void push(final VCSContext vCSContext) {
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                PushAction.getDefaultAndPerformPush(vCSContext, file, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_PROGRESS"));
    }

    public static void notifyUpdatedFiles(File file, List<String> list) {
        for (String string : list) {
            if (!string.startsWith("getting ")) continue;
            String string2 = string.substring(8);
            File file2 = new File(file, string2);
            Mercurial.getInstance().notifyFileChanged(file2);
        }
    }

    static void getDefaultAndPerformPush(VCSContext vCSContext, File file, OutputLogger outputLogger) {
        HgURL hgURL;
        String string = HgRepositoryContextCache.getInstance().getPushDefault(vCSContext);
        if (string == null) {
            string = HgRepositoryContextCache.getInstance().getPullDefault(vCSContext);
        }
        if (string == null) {
            PushAction.notifyDefaultPushUrlNotSpecified(outputLogger);
            return;
        }
        try {
            hgURL = new HgURL(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            PushAction.notifyDefaultPushUrlInvalid(string, uRISyntaxException.getReason(), outputLogger);
            return;
        }
        String string2 = HgProjectUtils.getProjectName(file);
        String string3 = hgURL.isFile() ? HgProjectUtils.getProjectName(new File(hgURL.getPath())) : null;
        PushAction.performPush(file, hgURL, string2, string3, outputLogger, true);
    }

    private static void notifyDefaultPushUrlNotSpecified(OutputLogger outputLogger) {
        String string = PushAction.getMessage("MSG_PUSH_TITLE", new String[0]);
        outputLogger.outputInRed(string);
        outputLogger.outputInRed(PushAction.getMessage("MSG_PUSH_TITLE_SEP", new String[0]));
        outputLogger.output(PushAction.getMessage("MSG_NO_DEFAULT_PUSH_SET_MSG", new String[0]));
        outputLogger.outputInRed(PushAction.getMessage("MSG_PUSH_DONE", new String[0]));
        outputLogger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)PushAction.getMessage("MSG_NO_DEFAULT_PUSH_SET", new String[0]), string, 1));
    }

    private static void notifyDefaultPushUrlInvalid(String string, String string2, OutputLogger outputLogger) {
        String string3 = PushAction.getMessage("MSG_PUSH_TITLE", new String[0]);
        String string4 = PushAction.getMessage("MSG_DEFAULT_PUSH_INVALID", string);
        outputLogger.outputInRed(string3);
        outputLogger.outputInRed(PushAction.getMessage("MSG_PUSH_TITLE_SEP", new String[0]));
        outputLogger.output(string4);
        outputLogger.outputInRed(PushAction.getMessage("MSG_PUSH_DONE", new String[0]));
        outputLogger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string4, string3, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void performPush(File file, HgURL hgURL, String string, String string2, OutputLogger outputLogger, boolean bl) {
        block50: {
            block48: {
                block47: {
                    block46: {
                        try {
                            try {
                                Object object;
                                boolean bl2;
                                File file2;
                                boolean bl3;
                                block53: {
                                    boolean bl4;
                                    String string3;
                                    block49: {
                                        block54: {
                                            List<String> list;
                                            List<String> list2;
                                            block52: {
                                                block51: {
                                                    bl3 = hgURL.isFile();
                                                    string3 = bl3 ? hgURL.getPath() : null;
                                                    file2 = bl3 ? new File(string3) : null;
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE"));
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE_SEP"));
                                                    if (string2 == null) {
                                                        outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSHING_TO_NONAME", (Object)(bl3 ? HgUtils.stripDoubleSlash(string3) : hgURL)));
                                                    } else {
                                                        outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSHING_TO", (Object)string2, (Object)(bl3 ? HgUtils.stripDoubleSlash(string3) : hgURL)));
                                                    }
                                                    list2 = HgCommand.doOutgoing(file, hgURL, outputLogger, bl);
                                                    if (list2 == null) break block51;
                                                    if (!list2.isEmpty()) break block52;
                                                }
                                                Object var20_12 = null;
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                                                outputLogger.output("");
                                                return;
                                            }
                                            ArrayList<HgLogMessage> arrayList = new ArrayList<HgLogMessage>();
                                            HgCommand.processLogMessages(file, null, list2, arrayList);
                                            bl2 = HgCommand.isNoChanges(list2.get(list2.size() - 1));
                                            if (bl3 && !bl2 && !PullAction.confirmWithLocalChanges(file2, PushAction.class, "MSG_PUSH_LOCALMODS_CONFIRM_TITLE", "MSG_PUSH_LOCALMODS_CONFIRM_QUERY", list2, outputLogger)) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_LOCALMODS_CANCEL"));
                                                outputLogger.output("");
                                                break block46;
                                            }
                                            if (bl2) {
                                                list = list2;
                                            } else {
                                                Object object2;
                                                object = Mercurial.getInstance().getHooks();
                                                bl4 = false;
                                                HgHookContext hgHookContext = null;
                                                if (object.size() > 0) {
                                                    object2 = new HgHookContext.LogEntry[arrayList.size()];
                                                    for (int i = 0; i < arrayList.size(); ++i) {
                                                        object2[i] = new HgHookContext.LogEntry((HgLogMessage)arrayList.get(i));
                                                    }
                                                    hgHookContext = new HgHookContext(new File[]{file}, null, (HgHookContext.LogEntry[])object2);
                                                }
                                                object2 = object.iterator();
                                                while (object2.hasNext()) {
                                                    HgHook hgHook = (HgHook)object2.next();
                                                    try {
                                                        hgHook.beforePush(hgHookContext);
                                                    }
                                                    catch (IOException iOException) {}
                                                }
                                                list = HgCommand.doPush(file, hgURL, outputLogger, bl);
                                                object2 = object.iterator();
                                                while (object2.hasNext()) {
                                                    HgHook hgHook = (HgHook)object2.next();
                                                    hgHook.afterPush(hgHookContext);
                                                }
                                            }
                                            if (!list.isEmpty() && HgCommand.isErrorAbortPush(list.get(list.size() - 1))) {
                                                outputLogger.output(list);
                                                outputLogger.output("");
                                                HgUtils.warningDialog(PushAction.class, "MSG_PUSH_ERROR_TITLE", "MSG_PUSH_ERROR_QUERY");
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_ERROR_CANCELED"));
                                                break block47;
                                            }
                                            if (list == null || list.isEmpty()) break block53;
                                            if (!HgCommand.isNoChanges(list2.get(list2.size() - 1))) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_CHANGESETS_TO_PUSH"));
                                                if (arrayList.size() > 0) {
                                                    for (HgLogMessage hgLogMessage : arrayList) {
                                                        HgUtils.logHgLog(hgLogMessage, outputLogger);
                                                    }
                                                } else {
                                                    for (String string4 : list2) {
                                                        if (string4.indexOf("changeset:") == 0) {
                                                            outputLogger.outputInRed(string4);
                                                            continue;
                                                        }
                                                        if (string4.equals("")) continue;
                                                        outputLogger.output(HgUtils.replaceHttpPassword(string4));
                                                    }
                                                }
                                                outputLogger.output("");
                                            }
                                            outputLogger.output(HgUtils.replaceHttpPassword(list));
                                            if (string2 == null) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TO_NONAME", (Object)(bl3 ? HgUtils.stripDoubleSlash(string3) : hgURL)));
                                            } else {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TO", (Object)string2, (Object)(bl3 ? HgUtils.stripDoubleSlash(string3) : hgURL)));
                                            }
                                            if (string == null) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_FROM_NONAME", (Object)file));
                                            } else {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_FROM", (Object)string, (Object)file));
                                            }
                                            boolean bl5 = false;
                                            if (bl3) {
                                                bl5 = HgCommand.isHeadsCreated(list.get(list.size() - 1));
                                            }
                                            bl4 = false;
                                            if (bl5) break block54;
                                            if (bl2) {
                                                break block48;
                                            }
                                            if (bl3) {
                                                list = HgCommand.doUpdateAll(file2, false, null, false);
                                                outputLogger.output(list);
                                                if (string2 != null) {
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_UPDATE_DONE", (Object)string2, (Object)HgUtils.stripDoubleSlash(string3)));
                                                } else {
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_UPDATE_DONE_NONAME", (Object)HgUtils.stripDoubleSlash(string3)));
                                                }
                                                boolean bl6 = HgCommand.isMergeAbortUncommittedMsg(list.get(list.size() - 1));
                                                if (bl6) {
                                                    bl4 = HgUtils.confirmDialog(PushAction.class, "MSG_PUSH_MERGE_CONFIRM_TITLE", "MSG_PUSH_MERGE_UNCOMMITTED_CONFIRM_QUERY");
                                                    break block49;
                                                } else {
                                                    PushAction.notifyUpdatedFiles(file2, list);
                                                }
                                            }
                                            break block49;
                                        }
                                        bl4 = HgUtils.confirmDialog(PushAction.class, "MSG_PUSH_MERGE_CONFIRM_TITLE", "MSG_PUSH_MERGE_CONFIRM_QUERY");
                                    }
                                    if (bl4) {
                                        outputLogger.output("");
                                        outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_MERGE_DO"));
                                        MergeAction.doMergeAction(file2, null, outputLogger);
                                    } else {
                                        List<String> list = HgCommand.getHeadRevisions(string3);
                                        if (list != null && list.size() > 1) {
                                            MergeAction.printMergeWarning(list, outputLogger);
                                        }
                                    }
                                }
                                if (bl3 && !bl2) {
                                    HgUtils.forceStatusRefresh(file2);
                                    object = FileUtil.toFileObject((File)file2);
                                    try {
                                        object.getFileSystem().refresh(true);
                                    }
                                    catch (Exception exception) {
                                    }
                                }
                                break block50;
                            }
                            catch (HgException hgException) {
                                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                                Object var20_17 = null;
                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                                outputLogger.output("");
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var20_18 = null;
                            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                            outputLogger.output("");
                            throw throwable;
                        }
                    }
                    Object var20_13 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                    outputLogger.output("");
                    return;
                }
                Object var20_14 = null;
                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                outputLogger.output("");
                return;
            }
            Object var20_15 = null;
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
            outputLogger.output("");
            return;
        }
        Object var20_16 = null;
        outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
        outputLogger.output("");
    }

    private static String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(PushAction.class, (String)string, (Object[])stringArray);
    }
}

