/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.ignore;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IgnoreAction
extends ContextAction {
    private final VCSContext context;
    private int mActionStatus;
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    public IgnoreAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    protected int getFileEnabledStatus() {
        return 6;
    }

    protected int getDirectoryEnabledStatus() {
        return 6;
    }

    public int getActionStatus(File[] fileArray) {
        int n = -1;
        if (fileArray.length == 0) {
            return 0;
        }
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().equals(".hg") || fileArray[i].isDirectory() || SharabilityQuery.getSharability((File)fileArray[i]) == 2) {
                n = 0;
                break;
            }
            FileInformation fileInformation = fileStatusCache.getStatus(fileArray[i]);
            if (fileInformation.getStatus() == 4) {
                if (n == 2) {
                    n = 0;
                    break;
                }
                n = 1;
                continue;
            }
            if (fileInformation.getStatus() == 2) {
                if (n == 1) {
                    n = 0;
                    break;
                }
                n = 2;
                continue;
            }
            n = 0;
            break;
        }
        return n == -1 ? 0 : n;
    }

    public boolean isEnabled() {
        Set set = this.context != null ? this.context.getRootFiles() : null;
        File file = HgUtils.getRootFile(this.context);
        return file != null && set != null && set.size() != 0;
    }

    public void performAction(ActionEvent actionEvent) {
        Set set;
        final File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        if (set == null || set.size() == 0) {
            return;
        }
        final File[] fileArray = set.toArray(new File[this.context.getRootFiles().size()]);
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                try {
                    IgnoreAction.this.mActionStatus = IgnoreAction.this.getActionStatus(fileArray);
                    if (IgnoreAction.this.mActionStatus == 0) {
                        outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE"));
                        outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE_SEP"));
                        outputLogger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_ONLY_LOCALLY_NEW"));
                        outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_DONE"));
                        outputLogger.output("");
                        return;
                    }
                    if (IgnoreAction.this.mActionStatus == 1) {
                        HgUtils.addIgnored(file, fileArray);
                        outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE"));
                        outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE_SEP"));
                        outputLogger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_INIT_SEP", (Object)file.getName()));
                    } else {
                        HgUtils.removeIgnored(file, fileArray);
                        outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_TITLE"));
                        outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_TITLE_SEP"));
                        outputLogger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_INIT_SEP", (Object)file.getName()));
                    }
                }
                catch (IOException iOException) {
                    Mercurial.LOG.log(Level.FINE, "IgnoreAction(): File {0} - {1}", new Object[]{file.getAbsolutePath(), iOException.toString()});
                }
                for (File file2 : fileArray) {
                    Mercurial.getInstance().getFileStatusCache().refresh(file2, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                    outputLogger.output("\t" + file2.getAbsolutePath());
                }
                if (IgnoreAction.this.mActionStatus == 1) {
                    outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_DONE"));
                } else {
                    outputLogger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_DONE"));
                }
                outputLogger.output("");
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(IgnoreAction.class, (String)"LBL_Ignore_Progress"));
    }
}

