/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.diff.DiffFileTable;
import org.netbeans.modules.mercurial.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiDiffPanel
extends JPanel
implements ActionListener,
DiffSetupSource,
PropertyChangeListener {
    private Setup[] setups;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private final VCSContext context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentIndex = -1;
    private int currentModelIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private RequestProcessor.Task refreshTask;
    private JComponent diffView;
    private DiffFileTable fileTable;
    private boolean dividerSet;
    private HgProgressSupport executeStatusSupport;
    private boolean fileTableSetSelectedIndexContext;
    private JButton commitButton;
    private JToolBar controlsToolBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JSplitPane splitPane;

    public MultiDiffPanel(VCSContext vCSContext, int n, String string) {
        this.context = vCSContext;
        this.contextName = string;
        this.currentType = n;
        this.initComponents();
        this.setupComponents();
        this.refreshSetups();
        this.refreshComponents();
        this.refreshTask = Utils.createTask((Runnable)new RefreshViewTask());
        this.refreshStatuses();
    }

    public MultiDiffPanel(File file, String string, String string2) {
        this.context = null;
        this.contextName = file.getName();
        this.initComponents();
        this.setupComponents();
        this.fileTable.getComponent().setVisible(false);
        this.commitButton.setVisible(false);
        this.setups = new Setup[]{new Setup(file, string, string2)};
        this.setDiffIndex(0, 0);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
    }

    public void setSelectedIndex(int n) {
        if (this.fileTableSetSelectedIndexContext) {
            return;
        }
        this.setDiffIndex(n, 0);
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    private void cancelBackgroundTasks() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
        }
    }

    void componentClosed() {
        this.setups = null;
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
    }

    void requestActive() {
        if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void setupComponents() {
        this.fileTable = new DiffFileTable(this);
        this.splitPane.setTopComponent(this.fileTable.getComponent());
        this.splitPane.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent")));
        this.commitButton.addActionListener(this);
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_CommitDiff_Tooltip"));
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MultiDiffPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MultiDiffPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private void refreshComponents() {
        int n;
        DiffController diffController = this.setups != null && this.currentModelIndex != -1 ? this.setups[this.currentModelIndex].getView() : null;
        int n2 = n = diffController != null ? diffController.getDifferenceIndex() : -1;
        if (diffController != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || n < diffController.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || n > 0);
        this.dividerSet = false;
        this.updateSplitLocation();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            Mercurial.getInstance().getFileStatusCache().addPropertyChangeListener(this);
        }
        JComponent jComponent = (JComponent)this.getParent();
        jComponent.getActionMap().put("jumpNext", this.nextAction);
        jComponent.getActionMap().put("jumpPrev", this.prevAction);
    }

    private void updateSplitLocation() {
        Dimension dimension;
        if (this.dividerSet) {
            return;
        }
        JComponent jComponent = (JComponent)this.getParent();
        Dimension dimension2 = dimension = jComponent == null ? new Dimension() : jComponent.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MultiDiffPanel.this.updateSplitLocation();
                }
            });
        }
        this.dividerSet = true;
        JTable jTable = this.fileTable.getTable();
        int n = jTable.getPreferredSize().height + jTable.getTableHeader().getPreferredSize().height;
        if (n > dimension.height / 3) {
            n = dimension.height / 3;
        }
        if (n <= jTable.getTableHeader().getPreferredSize().height) {
            n = jTable.getTableHeader().getPreferredSize().height * 3;
        }
        this.splitPane.setDividerLocation(n);
    }

    @Override
    public void removeNotify() {
        Mercurial.getInstance().getFileStatusCache().removePropertyChangeListener(this);
        super.removeNotify();
    }

    private boolean affectsView(PropertyChangeEvent propertyChangeEvent) {
        FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)propertyChangeEvent.getNewValue();
        File file = changedEvent.getFile();
        FileInformation fileInformation = changedEvent.getOldInfo();
        FileInformation fileInformation2 = changedEvent.getNewInfo();
        if (fileInformation == null ? (fileInformation2.getStatus() & this.displayStatuses) == 0 : (fileInformation.getStatus() & this.displayStatuses) + (fileInformation2.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context == null ? false : this.context.contains(file);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDiffIndex(int n, int n2) {
        this.currentIndex = n;
        DiffController diffController = null;
        if (this.currentIndex != -1) {
            File file;
            this.currentModelIndex = this.showingFileTable() ? this.fileTable.getModelIndex(this.currentIndex) : 0;
            diffController = this.setups[this.currentModelIndex].getView();
            TopComponent topComponent = (TopComponent)this.getClientProperty(TopComponent.class);
            if (topComponent != null) {
                FileObject fileObject;
                Node node = Node.EMPTY;
                file = this.setups[this.currentModelIndex].getBaseFile();
                if (file != null && (fileObject = FileUtil.toFileObject((File)file)) != null) {
                    node = new AbstractNode(Children.LEAF, Lookups.singleton((Object)fileObject));
                }
                topComponent.setActivatedNodes(new Node[]{node});
            }
            this.diffView = null;
            boolean bl = false;
            if (diffController != null) {
                if (this.showingFileTable()) {
                    this.fileTableSetSelectedIndexContext = true;
                    this.fileTable.setSelectedIndex(this.currentIndex);
                    this.fileTableSetSelectedIndexContext = false;
                }
                this.diffView = diffController.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.setBottomComponent();
                if (n2 == -1) {
                    n2 = diffController.getDifferenceCount() - 1;
                }
                if (n2 >= 0 && n2 < diffController.getDifferenceCount()) {
                    diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n2);
                }
                if (!SwingUtilities.isDescendingFrom(this, (Component)((Object)(file = WindowManager.getDefault().getRegistry().getActivated())))) {
                    // empty if block
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
            }
        } else {
            this.currentModelIndex = -1;
            this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected"));
            this.setBottomComponent();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    private boolean showingFileTable() {
        return this.fileTable.getComponent().isVisible();
    }

    private void setBottomComponent() {
        int n = this.splitPane.getDividerLocation();
        this.splitPane.setBottomComponent(this.diffView);
        this.splitPane.setDividerLocation(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.commitButton) {
            this.onCommitButton();
        }
    }

    private void onRefreshButton() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        if (this.context == null || this.context.getRootFiles().size() == 0) {
            return;
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
            this.executeStatusSupport = null;
        }
        LifecycleManager.getDefault().saveAll();
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor();
        this.executeStatusSupport = new HgProgressSupport(){

            public void perform() {
                StatusAction.executeStatus(MultiDiffPanel.this.context, this);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiDiffPanel.this.refreshSetups();
                    }
                });
            }
        };
        File file = HgUtils.getRootFile(this.context);
        this.executeStatusSupport.start(requestProcessor, file, NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_Refresh_Progress"));
    }

    private void onUpdateButton() {
        UpdateAction.update(this.context);
    }

    private void onCommitButton() {
        LifecycleManager.getDefault().saveAll();
        CommitAction.commit(this.contextName, this.context);
    }

    private void onNextButton() {
        DiffController diffController;
        int n;
        if (this.showingFileTable()) {
            this.currentIndex = this.fileTable.getSelectedIndex();
            this.currentModelIndex = this.fileTable.getSelectedModelIndex();
        }
        int n2 = n = (diffController = this.setups[this.currentModelIndex].getView()) != null ? diffController.getDifferenceIndex() : -1;
        if (diffController != null) {
            int n3 = diffController.getDifferenceIndex();
            if (n3 < diffController.getDifferenceCount() - 1) {
                n = Math.max(n, n3);
            }
            if (++n >= diffController.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0);
                }
            } else {
                diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffController diffController = this.setups[this.currentModelIndex].getView();
        if (diffController != null) {
            int n = diffController.getDifferenceIndex();
            if (--n < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1);
                }
            } else {
                diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1);
        }
        this.refreshComponents();
    }

    @Override
    public Collection<Setup> getSetups() {
        if (this.setups == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(this.setups);
    }

    @Override
    public String getSetupDisplayName() {
        return this.contextName;
    }

    /*
     * WARNING - void declaration
     */
    private void refreshSetups() {
        String[] stringArray;
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                this.displayStatuses = 6612;
                break;
            }
            case 1: {
                this.displayStatuses = 1696;
                break;
            }
            case 2: {
                this.displayStatuses = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        File[] fileArray = HgUtils.getModifiedFiles(this.context, this.displayStatuses);
        this.setups = this.computeSetups(fileArray);
        boolean bl = false;
        for (Setup setup : this.setups) {
            if (setup.getPropertyName() == null) continue;
            bl = true;
            break;
        }
        if (bl) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "name";
            stringArray2[1] = "property";
            stringArray2[2] = "status";
            stringArray = stringArray2;
            stringArray2[3] = "location";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "name";
            stringArray3[1] = "status";
            stringArray = stringArray3;
            stringArray3[2] = "location";
        }
        this.fileTable.setColumns(stringArray);
        this.fileTable.setTableModel(this.setupToNodes(this.setups));
        if (this.setups.length == 0) {
            void var3_7;
            switch (this.currentType) {
                case 0: {
                    String string = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                    break;
                }
                case 1: {
                    String string = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                    break;
                }
                case 2: {
                    String string = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
                }
            }
            this.setups = null;
            this.fileTable.setTableModel(new Node[0]);
            this.fileTable.getComponent().setEnabled(false);
            this.fileTable.getComponent().setPreferredSize(null);
            Dimension dimension = this.fileTable.getComponent().getPreferredSize();
            this.fileTable.getComponent().setPreferredSize(new Dimension(dimension.width + 1, dimension.height));
            this.diffView = null;
            this.diffView = new NoContentPanel((String)var3_7);
            this.setBottomComponent();
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.revalidate();
            this.repaint();
        } else {
            this.fileTable.getComponent().setEnabled(true);
            this.fileTable.getComponent().setPreferredSize(null);
            Dimension dimension = this.fileTable.getComponent().getPreferredSize();
            this.fileTable.getComponent().setPreferredSize(new Dimension(dimension.width + 1, dimension.height));
            this.setDiffIndex(0, 0);
            this.dpt = new DiffPrepareTask(this.setups);
            this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
        }
    }

    private Setup[] computeSetups(File[] fileArray) {
        ArrayList<Setup> arrayList = new ArrayList<Setup>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.isDirectory()) continue;
            Setup setup = new Setup(file, null, this.currentType);
            setup.setNode(new DiffNode(setup));
            arrayList.add(setup);
        }
        Collections.sort(arrayList, new SetupsComparator());
        return arrayList.toArray(new Setup[arrayList.size()]);
    }

    private Node[] setupToNodes(Setup[] setupArray) {
        ArrayList<DiffNode> arrayList = new ArrayList<DiffNode>(setupArray.length);
        for (Setup setup : setupArray) {
            arrayList.add(setup.getNode());
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("(void) differencesChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.refreshComponents();
        } else if ("status.changed".equals(propertyChangeEvent.getPropertyName())) {
            if (!this.affectsView(propertyChangeEvent)) {
                return;
            }
            this.refreshTask.schedule(200);
        }
    }

    private void initComponents() {
        this.controlsToolBar = new JToolBar();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel2 = new JPanel();
        this.refreshButton = new JButton();
        this.jPanel5 = new JPanel();
        this.commitButton = new JButton();
        this.splitPane = new JSplitPane();
        this.controlsToolBar.setFloatable(false);
        this.controlsToolBar.setRollover(true);
        this.jPanel4.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        this.jPanel3.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jPanel3, -2, -1, -2).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).add((Component)this.jPanel3, -2, -1, -2)));
        this.controlsToolBar.add(this.jPanel4);
        this.jPanel1.setMaximumSize(new Dimension(80, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 80, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel1);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setFocusable(false);
        this.prevButton.setHorizontalTextPosition(0);
        this.prevButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.prevButton);
        this.jPanel2.setMaximumSize(new Dimension(30, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 30, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel2);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiDiffPanel.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        this.controlsToolBar.add(this.refreshButton);
        this.jPanel5.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        GroupLayout groupLayout5 = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel5);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/commit.png")));
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip"));
        this.commitButton.setFocusable(false);
        this.commitButton.setHorizontalTextPosition(0);
        this.commitButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.commitButton);
        this.splitPane.setOrientation(0);
        GroupLayout groupLayout6 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.controlsToolBar, -1, 716, Short.MAX_VALUE).add((Component)this.splitPane, -1, 716, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.controlsToolBar, -2, 25, -2).addPreferredGap(0).add((Component)this.splitPane, -1, 331, Short.MAX_VALUE)));
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        this.onRefreshButton();
    }

    static final class Property {
        final byte[] value;

        Property(Object object) {
            this.value = (byte[])object;
        }

        String getMIME() {
            return "text/plain";
        }

        Reader toReader() {
            if (HgUtils.isBinary(this.value)) {
                return new StringReader(NbBundle.getMessage(MultiDiffPanel.class, (String)"LBL_Diff_NoBinaryDiff"));
            }
            try {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.value), "utf8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Mercurial.LOG.log(Level.SEVERE, "UnsupportedEncodingException " + unsupportedEncodingException);
                return new StringReader("[ERROR: " + unsupportedEncodingException.getLocalizedMessage() + "]");
            }
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MultiDiffPanel.this.refreshSetups();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetupsComparator
    implements Comparator<Setup> {
        private HgUtils.ByImportanceComparator delegate = new HgUtils.ByImportanceComparator();
        private FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();

        @Override
        public int compare(Setup setup, Setup setup2) {
            int n = this.delegate.compare(this.cache.getStatus(setup.getBaseFile()), this.cache.getStatus(setup2.getBaseFile()));
            if (n == 0) {
                return setup.getBaseFile().getName().compareToIgnoreCase(setup2.getBaseFile().getName());
            }
            return n;
        }
    }

    private class DiffPrepareTask
    implements Runnable {
        private final Setup[] prepareSetups;

        public DiffPrepareTask(Setup[] setupArray) {
            this.prepareSetups = setupArray;
        }

        public void run() {
            for (int i = 0; i < this.prepareSetups.length; ++i) {
                if (this.prepareSetups != MultiDiffPanel.this.setups) {
                    return;
                }
                try {
                    this.prepareSetups[i].initSources();
                    final int n = i;
                    StreamSource streamSource = this.prepareSetups[n].getFirstSource();
                    StreamSource streamSource2 = this.prepareSetups[n].getSecondSource();
                    final DiffController diffController = DiffController.create((StreamSource)streamSource, (StreamSource)streamSource2);
                    diffController.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanel.this);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DiffPrepareTask.this.prepareSetups[n].setView(diffController);
                            if (DiffPrepareTask.this.prepareSetups != MultiDiffPanel.this.setups) {
                                return;
                            }
                            if (MultiDiffPanel.this.currentModelIndex == n) {
                                MultiDiffPanel.this.setDiffIndex(MultiDiffPanel.this.currentIndex, 0);
                            }
                        }
                    });
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }
}

