/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportDiffAction
extends ContextAction {
    private final VCSContext context;

    public ImportDiffAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        ImportDiffAction.importDiff(this.context);
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }

    private static void importDiff(VCSContext vCSContext) {
        Object object;
        File file = HgUtils.getRootFile(vCSContext);
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(ImportDiffAction.class, (String)"ACSD_ImportBrowseFolder"), null);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(ImportDiffAction.class, (String)"ImportBrowse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            object = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter((FileFilter)object);
        }
        accessibleJFileChooser.setDialogType(1);
        accessibleJFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ImportDiffAction.class, (String)"Import").charAt(0));
        accessibleJFileChooser.setApproveButtonText(NbBundle.getMessage(ImportDiffAction.class, (String)"Import"));
        accessibleJFileChooser.setCurrentDirectory(new File(HgModuleConfig.getDefault().getImportFolder()));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)accessibleJFileChooser, NbBundle.getMessage(ImportDiffAction.class, (String)"Browse_title"));
        dialogDescriptor.setOptions(new Object[0]);
        object = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        accessibleJFileChooser.addActionListener(new ActionListener((JFileChooser)accessibleJFileChooser, file, (Dialog)object){
            final /* synthetic */ JFileChooser val$fileChooser;
            final /* synthetic */ File val$root;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$fileChooser = jFileChooser;
                this.val$root = file;
                this.val$dialog = dialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection")) {
                    final File file = this.val$fileChooser.getSelectedFile();
                    HgModuleConfig.getDefault().setImportFolder(file.getParent());
                    if (file != null) {
                        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(this.val$root);
                        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                            public void perform() {
                                OutputLogger outputLogger = this.getLogger();
                                ImportDiffAction.performImport(val$root, file, outputLogger);
                            }
                        };
                        hgProgressSupport.start(requestProcessor, this.val$root, NbBundle.getMessage(ImportDiffAction.class, (String)"LBL_ImportDiff_Progress"));
                    }
                }
                this.val$dialog.dispose();
            }
        });
        ((Dialog)object).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void performImport(File file, File file2, OutputLogger outputLogger) {
        try {
            try {
                outputLogger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_TITLE"));
                outputLogger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_TITLE_SEP"));
                List<String> list = HgCommand.doImport(file, file2, outputLogger);
                Mercurial.getInstance().changesetChanged(file);
                outputLogger.output(list);
            }
            catch (HgException hgException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                Object var6_6 = null;
                outputLogger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_DONE"));
                outputLogger.output("");
                Mercurial.getInstance().getRequestProcessor().post(new Runnable(file){
                    final /* synthetic */ File val$repository;
                    {
                        this.val$repository = file;
                    }

                    public void run() {
                        FileUtil.refreshFor((File[])new File[]{this.val$repository});
                    }
                });
                return;
            }
            Object var6_5 = null;
            outputLogger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_DONE"));
            outputLogger.output("");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            outputLogger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_DONE"));
            outputLogger.output("");
            Mercurial.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        Mercurial.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
    }
}

