/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.hooks.spi.HgHookContext;
import org.netbeans.modules.mercurial.ui.commit.CommitTable;
import org.netbeans.modules.versioning.util.AutoResizingPanel;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitPanel
extends AutoResizingPanel
implements PreferenceChangeListener,
TableModelListener {
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    final JLabel filesLabel = new JLabel();
    final JPanel filesPanel = new JPanel();
    final JLabel filesSectionButton = new JLabel();
    final JPanel filesSectionPanel2 = new JPanel();
    final PlaceholderPanel hookSectionPanel = new PlaceholderPanel();
    final JLabel hooksSectionButton = new JLabel();
    final JTabbedPane hooksTabbedPane = new JTabbedPane();
    final JLabel jLabel1 = new JLabel();
    final JLabel jLabel2 = new JLabel();
    final JScrollPane jScrollPane1 = new JScrollPane();
    final JTextArea messageTextArea = new JTextArea();
    final PlaceholderPanel progressPanel = new PlaceholderPanel();
    final JLabel recentLink = new JLabel();
    private CommitTable commitTable;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitPanel() {
        this.initComponents();
        this.hookSectionPanel.setVisible(false);
        this.hooksSectionButton.setVisible(false);
    }

    void setCommitTable(CommitTable commitTable) {
        this.commitTable = commitTable;
    }

    void setErrorLabel(String string) {
        this.jLabel2.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        this.filesPanel.setPreferredSize(new Dimension(0, 2 * this.messageTextArea.getPreferredSize().height));
        HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.recentLink.setCursor(Cursor.getPredefinedCursor(12));
        this.recentLink.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CommitPanel.this.onBrowseRecentMessages();
            }
        });
        JTree jTree = new JTree();
        BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
        Icon icon = basicTreeUI.getExpandedIcon();
        Icon icon2 = basicTreeUI.getCollapsedIcon();
        this.filesSectionButton.setIcon(icon);
        this.hooksSectionButton.setIcon(icon2);
        this.hookSectionPanel.setVisible(false);
        this.initSectionButton(this.filesSectionButton, this.filesSectionPanel2, icon2, icon);
        this.initSectionButton(this.hooksSectionButton, (JPanel)this.hookSectionPanel, icon2, icon);
        final List list = Utils.getStringList((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (list.size() > 0) {
                    CommitPanel.this.messageTextArea.setText((String)list.get(0));
                }
                CommitPanel.this.messageTextArea.selectAll();
            }
        });
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        HgModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    void initHooks(List<HgHook> list, HgHookContext hgHookContext) {
        if (list.size() < 1) {
            this.filesSectionButton.setVisible(false);
            this.hooksSectionButton.setVisible(false);
            this.hooksSectionButton.setVisible(false);
            return;
        }
        if (list.size() == 1) {
            HgHook hgHook = list.get(0);
            this.hookSectionPanel.add((Component)hgHook.createComponent(hgHookContext));
            this.hooksSectionButton.setText(hgHook.getDisplayName());
        } else {
            this.hookSectionPanel.add((Component)this.hooksTabbedPane);
            this.hooksSectionButton.setText(CommitPanel.getMessage("LBL_Advanced"));
            for (HgHook hgHook : list) {
                this.hooksTabbedPane.add((Component)hgHook.createComponent(hgHookContext), hgHook.getDisplayName());
            }
        }
        this.hookSectionPanel.setVisible(true);
        this.hooksSectionButton.setVisible(true);
    }

    private void initSectionButton(final JLabel jLabel, final JPanel jPanel, final Icon icon, final Icon icon2) {
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (jPanel.isVisible()) {
                    jPanel.setVisible(false);
                    jLabel.setIcon(icon);
                } else {
                    jPanel.setVisible(true);
                    jLabel.setIcon(icon2);
                    CommitPanel.this.enlargeVerticallyAsNecessary();
                }
            }
        });
    }

    private void onBrowseRecentMessages() {
        String string = StringSelector.select((String)CommitPanel.getMessage("CTL_CommitForm_RecentTitle"), (String)CommitPanel.getMessage("CTL_CommitForm_RecentPrompt"), (List)Utils.getStringList((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage"));
        if (string != null) {
            this.messageTextArea.replaceSelection(string);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.commitTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        this.jLabel1.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)CommitPanel.getMessage("CTL_CommitForm_Message"));
        this.recentLink.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/recent_messages.png")));
        this.recentLink.setToolTipText(CommitPanel.getMessage("CTL_CommitForm_RecentMessages"));
        this.messageTextArea.setColumns(60);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(80, 18));
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.messageTextArea.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitForm_Message"));
        this.messageTextArea.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitForm_Message"));
        Mnemonics.setLocalizedText((JLabel)this.filesSectionButton, (String)CommitPanel.getMessage("LBL_CommitDialog_FilesToCommit"));
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)CommitPanel.getMessage("CTL_CommitForm_FilesToCommit"));
        this.filesSectionPanel2.setLayout(new BoxLayout(this.filesSectionPanel2, 1));
        this.filesSectionPanel2.add(this.filesLabel);
        this.filesSectionPanel2.add(this.makeVerticalStrut(this.filesLabel, this.filesPanel, 0));
        this.filesSectionPanel2.add(this.filesPanel);
        this.filesLabel.setAlignmentX(0.0f);
        this.filesPanel.setAlignmentX(0.0f);
        Mnemonics.setLocalizedText((JLabel)this.hooksSectionButton, (String)CommitPanel.getMessage("LBL_Advanced"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)"jLabel2");
        VerticallyNonResizingPanel verticallyNonResizingPanel = new VerticallyNonResizingPanel();
        verticallyNonResizingPanel.setLayout(new BoxLayout((Container)verticallyNonResizingPanel, 0));
        verticallyNonResizingPanel.add(this.jLabel1);
        verticallyNonResizingPanel.add(Box.createHorizontalGlue());
        verticallyNonResizingPanel.add(this.recentLink);
        this.jLabel1.setAlignmentY(1.0f);
        this.recentLink.setAlignmentY(1.0f);
        VerticallyNonResizingPanel verticallyNonResizingPanel2 = new VerticallyNonResizingPanel();
        verticallyNonResizingPanel2.setLayout(new BoxLayout((Container)verticallyNonResizingPanel2, 0));
        verticallyNonResizingPanel2.add(this.jLabel2);
        verticallyNonResizingPanel2.add(this.makeFlexibleHorizontalStrut(15, 90, Short.MAX_VALUE));
        verticallyNonResizingPanel2.add((Component)this.progressPanel);
        this.jLabel2.setAlignmentY(0.5f);
        this.progressPanel.setAlignmentY(0.5f);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add((Component)verticallyNonResizingPanel);
        this.add(this.makeVerticalStrut(this.jLabel1, this.jScrollPane1, 0));
        this.add(this.jScrollPane1);
        this.add(this.makeVerticalStrut(this.jScrollPane1, this.filesSectionButton, 0));
        this.add(this.filesSectionButton);
        this.add(this.makeVerticalStrut(this.filesSectionButton, this.filesSectionPanel2, 0));
        this.add(this.filesSectionPanel2);
        this.add(this.makeVerticalStrut(this.filesSectionPanel2, this.hooksSectionButton, 0));
        this.add(this.hooksSectionButton);
        this.add(this.makeVerticalStrut(this.hooksSectionButton, (JComponent)this.hookSectionPanel, 0));
        this.add((Component)this.hookSectionPanel);
        this.add(this.makeVerticalStrut((JComponent)this.hookSectionPanel, this.jLabel2, 0));
        this.add((Component)verticallyNonResizingPanel2);
        verticallyNonResizingPanel.setAlignmentX(0.0f);
        this.jScrollPane1.setAlignmentX(0.0f);
        this.filesSectionButton.setAlignmentX(0.0f);
        this.filesSectionPanel2.setAlignmentX(0.0f);
        this.hooksSectionButton.setAlignmentX(0.0f);
        this.hookSectionPanel.setAlignmentX(0.0f);
        verticallyNonResizingPanel2.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createEmptyBorder(26, this.getContainerGap(7), 0, 15));
        this.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitDialog"));
        this.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitDialog"));
    }

    private Component makeVerticalStrut(JComponent jComponent, JComponent jComponent2, int n) {
        int n2 = LayoutStyle.getSharedInstance().getPreferredGap(jComponent, jComponent2, n, 5, (Container)((Object)this));
        return Box.createVerticalStrut(n2);
    }

    private Component makeFlexibleHorizontalStrut(int n, int n2, int n3) {
        return new Box.Filler(new Dimension(n, 0), new Dimension(n2, 0), new Dimension(n3, 0));
    }

    private int getContainerGap(int n) {
        return LayoutStyle.getSharedInstance().getContainerGap((JComponent)((Object)this), n, null);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CommitPanel.class, (String)string);
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }
}

