/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.options.HgExtProperties;
import org.netbeans.modules.mercurial.options.LabelsPanel;
import org.netbeans.modules.mercurial.options.MercurialPanel;
import org.netbeans.modules.mercurial.options.PropertiesPanel;
import org.netbeans.modules.mercurial.options.PropertiesTable;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class MercurialOptionsPanelController
extends OptionsPanelController
implements ActionListener {
    private MercurialPanel panel;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean changed;

    public MercurialOptionsPanelController() {
        this.panel = new MercurialPanel(this);
        this.panel.execPathBrowseButton.addActionListener(this);
        this.panel.exportFilenameBrowseButton.addActionListener(this);
        String string = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.annotationTextField.toolTipText", (Object[])MercurialAnnotator.LABELS);
        this.panel.annotationTextField.setToolTipText(string);
        this.panel.addButton.addActionListener(this);
        this.panel.manageButton.addActionListener(this);
    }

    public void update() {
        this.getPanel().load();
        this.changed = false;
    }

    public void applyChanges() {
        if (!this.validateFields().booleanValue()) {
            return;
        }
        this.getPanel().store();
        Mercurial.getInstance().getMercurialAnnotator().refresh();
        Mercurial.getInstance().refreshAllAnnotations();
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        return this.getPanel().valid();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MercurialOptionsPanelController.class);
    }

    public JComponent getComponent(Lookup lookup) {
        return this.getPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.execPathBrowseButton) {
            this.onExecPathBrowseClick();
        } else if (actionEvent.getSource() == this.panel.exportFilenameBrowseButton) {
            this.onExportFilenameBrowseClick();
        } else if (actionEvent.getSource() == this.panel.addButton) {
            this.onAddClick();
        } else if (actionEvent.getSource() == this.panel.manageButton) {
            this.onManageClick();
        }
    }

    private File getExportFile() {
        String string = this.panel.exportFilenameTextField.getText();
        return FileUtil.normalizeFile((File)new File(string));
    }

    private File getExecutableFile() {
        String string = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(string));
    }

    private Boolean validateFields() {
        String string = this.panel.userNameTextField.getText();
        if (!HgModuleConfig.getDefault().isUserNameValid(string).booleanValue()) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_USER_NAME_TEXT"), NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_FIELD_TITLE"), 2);
            return false;
        }
        String string2 = this.panel.executablePathTextField.getText();
        String string3 = null;
        if (Utilities.isWindows()) {
            string3 = MercurialOptionsPanelController.getHgWindowsExecutableParent(string2);
        }
        if (string3 == null && string2.endsWith("hg")) {
            string3 = string2.substring(0, string2.length() - "hg".length());
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (!HgModuleConfig.getDefault().isExecPathValid(string3).booleanValue()) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_EXEC_PATH_TEXT"), NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_FIELD_TITLE"), 2);
            return false;
        }
        if (!HgUtils.isAnnotationFormatValid(HgUtils.createAnnotationFormat(this.panel.annotationTextField.getText()))) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_ANNOTATION_FORMAT_TEXT"), NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_FIELD_TITLE"), 2);
            return false;
        }
        return true;
    }

    private static String getHgWindowsExecutableParent(String string) {
        for (String string2 : HgCommand.HG_WINDOWS_EXECUTABLES) {
            if (!string.endsWith(string2)) continue;
            return string.substring(0, string.length() - string2.length());
        }
        return null;
    }

    private void onExportFilenameBrowseClick() {
        File file = this.getExecutableFile();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"ACSD_ExportBrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"ExportBrowse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
        }
        accessibleJFileChooser.showDialog(this.panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.panel.exportFilenameTextField.setText(file2.getAbsolutePath());
        }
    }

    private void onExecPathBrowseClick() {
        File file = this.getExportFile();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        accessibleJFileChooser.showDialog(this.panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.panel.executablePathTextField.setText(file2.getAbsolutePath());
        }
    }

    private MercurialPanel getPanel() {
        if (this.panel == null) {
            this.panel = new MercurialPanel(this);
        }
        return this.panel;
    }

    void changed() {
        if (!this.changed) {
            this.changed = true;
            this.pcs.firePropertyChange("changed", false, true);
        }
        this.pcs.firePropertyChange("valid", null, null);
    }

    private void onAddClick() {
        Object object;
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<Object> arrayList = new ArrayList<Object>(MercurialAnnotator.LABELS.length);
        for (int i = 0; i < MercurialAnnotator.LABELS.length; ++i) {
            object = new LabelVariable(MercurialAnnotator.LABELS[i], "{" + MercurialAnnotator.LABELS[i] + "} - " + NbBundle.getMessage(MercurialPanel.class, (String)("MercurialPanel.label." + MercurialAnnotator.LABELS[i])));
            arrayList.add(object);
        }
        labelsPanel.labelsList.setListData(arrayList.toArray(new LabelVariable[arrayList.size()]));
        String string = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.labelVariables.title");
        object = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.labelVariables.acsd");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, string);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription((String)object);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            Object[] objectArray = labelsPanel.labelsList.getSelectedValues();
            String string2 = "";
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = string2 + "{" + ((LabelVariable)objectArray[i]).getVariable() + "}";
            }
            String string3 = this.panel.annotationTextField.getText();
            int n = this.panel.annotationTextField.getCaretPosition();
            if (n < 0) {
                n = string3.length();
            }
            StringBuffer stringBuffer = new StringBuffer(string3.length() + string2.length());
            stringBuffer.append(string3.substring(0, n));
            stringBuffer.append(string2);
            if (n < string3.length()) {
                stringBuffer.append(string3.substring(n, string3.length()));
            }
            this.panel.annotationTextField.setText(stringBuffer.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(n + string2.length());
        }
    }

    private void onManageClick() {
        PropertiesPanel propertiesPanel = new PropertiesPanel();
        PropertiesTable propertiesTable = new PropertiesTable(propertiesPanel.labelForTable, PropertiesTable.PROPERTIES_COLUMNS, new String[]{"value"});
        propertiesPanel.setPropertiesTable(propertiesTable);
        JComponent jComponent = propertiesTable.getComponent();
        propertiesPanel.propsPanel.setLayout(new BorderLayout());
        propertiesPanel.propsPanel.add((Component)jComponent, "Center");
        HgExtProperties hgExtProperties = new HgExtProperties(propertiesPanel, propertiesTable, null);
        JButton jButton = new JButton(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_OK"));
        JButton jButton2 = new JButton(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertiesPanel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_PropertiesDialog_Title", null), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(MercurialOptionsPanelController.class), null);
        propertiesPanel.putClientProperty("contentTitle", null);
        propertiesPanel.putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_PropertiesDialog_Title"));
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            hgExtProperties.setProperties();
        }
    }

    private class LabelVariable {
        private String description;
        private String variable;

        public LabelVariable(String string, String string2) {
            this.description = string2;
            this.variable = string;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

