/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.MercurialInterceptor;
import org.netbeans.modules.mercurial.MercurialVCS;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.HyperlinkProvider;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mercurial {
    public static final int HG_FETCH_20_REVISIONS = 20;
    public static final int HG_FETCH_50_REVISIONS = 50;
    public static final int HG_FETCH_ALL_REVISIONS = -1;
    public static final int HG_NUMBER_FETCH_OPTIONS = 3;
    public static final int HG_NUMBER_TO_FETCH_DEFAULT = 7;
    public static final int HG_MAX_REVISION_COMBO_SIZE = 10;
    public static final String MERCURIAL_OUTPUT_TAB_TITLE = NbBundle.getMessage(Mercurial.class, (String)"CTL_Mercurial_DisplayName");
    public static final String CHANGESET_STR = "changeset:";
    static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    public static final String PROP_CHANGESET_CHANGED = "changesetChanged";
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial");
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private static final int STATUS_DIFFABLE = 1272;
    private static final String MERCURIAL_SUPPORTED_VERSION_093 = "0.9.3";
    private static final String MERCURIAL_SUPPORTED_VERSION_094 = "0.9.4";
    private static final String MERCURIAL_SUPPORTED_VERSION_095 = "0.9.5";
    private static final String MERCURIAL_SUPPORTED_VERSION_100 = "1.0";
    private static Mercurial instance;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Set<File> knownRoots = Collections.synchronizedSet(new HashSet());
    private MercurialAnnotator mercurialAnnotator;
    private MercurialInterceptor mercurialInterceptor;
    private FileStatusCache fileStatusCache;
    private HashMap<HgURL, RequestProcessor> processorsToUrl;
    private boolean goodVersion;
    private String version;
    private String runVersion;
    private boolean checkedVersion;
    private boolean gotVersion;
    private Lookup.Result<? extends HgHook> hooksResult;
    private Lookup.Result<? extends HyperlinkProvider> hpResult;
    private final Map<File, File> foldersToRoot = new HashMap<File, File>();

    public static synchronized Mercurial getInstance() {
        if (instance == null) {
            instance = new Mercurial();
            instance.init();
        }
        return instance;
    }

    private Mercurial() {
    }

    private void init() {
        this.setDefaultPath();
        this.fileStatusCache = new FileStatusCache();
        this.mercurialAnnotator = new MercurialAnnotator();
        this.mercurialInterceptor = new MercurialInterceptor();
        this.checkVersion();
    }

    private void setDefaultPath() {
        String string;
        String string2;
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String string3 = HgModuleConfig.getDefault().getExecutableBinaryPath();
            if (string3 == null || string3.length() == 0) {
                String[] stringArray = new String[]{"/Library/Frameworks/Python.framework/Versions/Current/bin", "/usr/bin", "/usr/local/bin", "/opt/local/bin/", "/sw/bin"};
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!HgModuleConfig.getDefault().isExecPathValid(stringArray[i]).booleanValue()) continue;
                    HgModuleConfig.getDefault().setExecutableBinaryPath(stringArray[i]);
                    break;
                }
            }
        } else if (Utilities.isWindows() && ((string2 = HgModuleConfig.getDefault().getExecutableBinaryPath()) == null || string2.length() == 0) && (string = HgUtils.findInUserPath(HgCommand.HG_WINDOWS_EXECUTABLES)) != null && !string.equals("")) {
            HgModuleConfig.getDefault().setExecutableBinaryPath(string);
        }
    }

    public void checkVersion() {
        this.checkedVersion = false;
        this.runVersion = null;
        this.gotVersion = false;
        RequestProcessor requestProcessor = this.getRequestProcessor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    Mercurial.this.checkVersionIntern();
                }
            }
        };
        requestProcessor.post(runnable);
    }

    private void checkVersionIntern() {
        this.version = HgCommand.getHgVersion();
        LOG.log(Level.FINE, "version: {0}", this.version);
        if (this.version != null) {
            this.goodVersion = this.isGoodVersion(this.version);
            if (!this.goodVersion) {
                Preferences preferences = HgModuleConfig.getDefault().getPreferences();
                this.runVersion = preferences.get("runVersion", null);
                if (this.runVersion != null && this.runVersion.equals(this.version)) {
                    this.goodVersion = true;
                }
            }
        } else {
            this.goodVersion = false;
        }
        this.gotVersion = true;
    }

    private boolean isGoodVersion(String string) {
        if (string.startsWith(MERCURIAL_SUPPORTED_VERSION_093) || string.startsWith(MERCURIAL_SUPPORTED_VERSION_094) || string.startsWith(MERCURIAL_SUPPORTED_VERSION_095) || string.startsWith(MERCURIAL_SUPPORTED_VERSION_100)) {
            return true;
        }
        return !string.startsWith("0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkVersionNotify(boolean bl) {
        Object object = this;
        synchronized (object) {
            if (!this.gotVersion) {
                LOG.log(Level.FINE, "Call to hg version not finished");
                if (bl) {
                    this.checkVersionIntern();
                }
                return true;
            }
        }
        if (this.version != null && !this.goodVersion) {
            if (this.runVersion == null || !this.runVersion.equals(this.version)) {
                object = HgModuleConfig.getDefault().getPreferences();
                OutputLogger outputLogger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
                ((Preferences)object).put("runVersion", this.version);
                outputLogger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_USING_UNRECOGNIZED_VERSION_MSG", (Object)this.version));
                outputLogger.closeLog();
            }
            this.goodVersion = true;
            return true;
        }
        if (this.version != null) {
            return true;
        }
        if (this.version == null) {
            object = HgModuleConfig.getDefault().getPreferences();
            ((Preferences)object).remove("runVersion");
            OutputLogger outputLogger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_OUTPUT_MSG"));
            HgUtils.warningDialog(Mercurial.class, "MSG_VERSION_NONE_TITLE", "MSG_VERSION_NONE_MSG");
            outputLogger.closeLog();
            return false;
        }
        return false;
    }

    public MercurialAnnotator getMercurialAnnotator() {
        return this.mercurialAnnotator;
    }

    MercurialInterceptor getMercurialInterceptor() {
        return this.mercurialInterceptor;
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public boolean isAdministrative(File file) {
        String string = file.getName();
        return this.isAdministrative(string) && file.isDirectory();
    }

    public boolean isAdministrative(String string) {
        return string.equals(".hg");
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof MercurialVCS && !HgUtils.isPartOfMercurialMetadata(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getRepositoryRoot(File file) {
        File file2 = this.getTopmostManagedParent(file);
        if (file2 != null) {
            if (file.isFile()) {
                file = file.getParentFile();
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.add(file2);
            while (file != null && !file.getAbsolutePath().equals(file2.getAbsolutePath())) {
                File file3;
                Map<File, File> map = this.foldersToRoot;
                synchronized (map) {
                    file3 = this.foldersToRoot.get(file);
                }
                if (file3 != null) {
                    this.addFoldersToRoot(arrayList, file3);
                    return file3;
                }
                arrayList.add(file);
                if (this.canWrite(file)) {
                    this.addFoldersToRoot(arrayList, file);
                    return file;
                }
                file = file.getParentFile();
            }
            this.addFoldersToRoot(arrayList, file2);
            return file2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFoldersToRoot(Collection<File> collection, File file) {
        Map<File, File> map = this.foldersToRoot;
        synchronized (map) {
            if (this.foldersToRoot.size() > 1500) {
                this.foldersToRoot.clear();
            }
            for (File file2 : collection) {
                this.foldersToRoot.put(file2, file);
            }
        }
    }

    File getTopmostManagedParent(File file) {
        long l = System.currentTimeMillis();
        LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        File file2 = this.getKnownParent(file);
        if (file2 != null) {
            LOG.log(Level.FINE, "  getTopmostManagedParent returning known parent " + file2);
            return file2;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            while (file != null) {
                if (this.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> hashSet = new HashSet<File>();
        File file3 = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (Utils.isScanForbidden((File)file)) break;
            if (this.canWrite(file)) {
                LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                hashSet.clear();
                file3 = file;
            } else {
                LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    hashSet.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (hashSet.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(hashSet);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{file3, System.currentTimeMillis() - l});
        }
        if (file3 != null) {
            this.knownRoots.add(file3);
        }
        return file3;
    }

    private File getKnownParent(File file) {
        File[] fileArray = this.knownRoots.toArray(new File[this.knownRoots.size()]);
        File file2 = null;
        for (File file3 : fileArray) {
            if (!Utils.isAncestorOrEqual((File)file3, (File)file) || file2 != null && !Utils.isAncestorOrEqual((File)file2, (File)file3)) continue;
            file2 = file3;
        }
        return file2;
    }

    private boolean canWrite(File file) {
        return new File(file, ".hg").canWrite();
    }

    public HgFileNode[] getNodes(VCSContext vCSContext, int n) {
        File[] fileArray = this.fileStatusCache.listFiles(vCSContext, n);
        HgFileNode[] hgFileNodeArray = new HgFileNode[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            hgFileNodeArray[i] = new HgFileNode(fileArray[i]);
        }
        return hgFileNodeArray;
    }

    public String getMimeType(File file) {
        String string;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            string = "content/unknown";
        } else {
            string = fileObject.getMIMEType();
            if ("content/unknown".equals(string)) {
                string = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return HgUtils.isFileContentBinary(file) ? "application/octet-stream" : string;
        }
        return string;
    }

    public boolean isGoodVersion() {
        return this.goodVersion;
    }

    public boolean isGoodVersionAndNotify() {
        if (!this.checkedVersion) {
            this.checkVersionNotify(false);
            this.checkedVersion = true;
        }
        return this.goodVersion;
    }

    public void versionedFilesChanged() {
        LOG.fine("cleaning unversioned parents cache");
        this.unversionedParents.clear();
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void changesetChanged(File file) {
        this.support.firePropertyChange(PROP_CHANGESET_CHANGED, file, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void getOriginalFile(File file, File file2) {
        FileInformation fileInformation = this.fileStatusCache.getStatus(file);
        LOG.log(Level.FINE, "getOriginalFile: {0} {1}", new Object[]{file, fileInformation});
        if ((fileInformation.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            File file3 = VersionsCache.getInstance().getFileRevision(file, "BASE");
            if (file3 == null) {
                return;
            }
            Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file2), (InputStream)new FileInputStream(file3));
            file3.delete();
        }
        catch (IOException iOException) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.INFO, "Unable to get original file", iOException);
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor((HgURL)null);
    }

    public RequestProcessor getRequestProcessor(File file) {
        return this.getRequestProcessor(new HgURL(file));
    }

    public RequestProcessor getRequestProcessor(HgURL hgURL) {
        RequestProcessor requestProcessor;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((requestProcessor = this.processorsToUrl.get(hgURL)) == null) {
            String string = "Mercurial - " + (hgURL != null ? hgURL.toString() : "ANY_KEY");
            requestProcessor = new RequestProcessor(string, 1, true);
            this.processorsToUrl.put(hgURL, requestProcessor);
        }
        return requestProcessor;
    }

    public void clearRequestProcessor(HgURL hgURL) {
        if (this.processorsToUrl != null & hgURL != null) {
            this.processorsToUrl.remove(hgURL);
        }
    }

    public void notifyFileChanged(File file) {
        this.fileStatusCache.notifyFileChanged(file);
    }

    public OutputLogger getLogger(String string) {
        return OutputLogger.getLogger(string);
    }

    public Boolean isRefreshScheduled(File file) {
        return this.mercurialInterceptor.isRefreshScheduled(file);
    }

    public List<HgHook> getHooks() {
        if (this.hooksResult == null) {
            this.hooksResult = Lookup.getDefault().lookupResult(HgHook.class);
        }
        if (this.hooksResult == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HgHook> arrayList = new ArrayList<HgHook>();
        Collection collection = this.hooksResult.allInstances();
        if (collection.size() > 0) {
            for (HgHook hgHook : collection) {
                arrayList.add(hgHook);
            }
        }
        return arrayList;
    }

    public List<HyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(HyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.EMPTY_LIST;
        }
        Collection collection = this.hpResult.allInstances();
        ArrayList arrayList = new ArrayList(collection.size());
        arrayList.addAll(collection);
        return Collections.unmodifiableList(arrayList);
    }
}

