/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;
import org.netbeans.mobility.antext.EMapFormat;

public class ObfuscateTask
extends Task {
    private static final boolean DELETE_SCRIPT = true;
    private static final String LIBS_OBFUSCATOR_CLASSPATH_PROPERTY_NAME = "libs.{0}.classpath";
    private static final String OBFUSCATOR_TYPE_NONE = "NONE";
    private File srcJar;
    private File destJar;
    private String obfuscatorType = "PROGUARD";
    private Path classPath;
    private String exclude;
    private String extraScript;
    private Path obfuscatorClassPath;
    private int obfuscationLevel;

    public void execute() throws BuildException {
        Object object;
        Appendable appendable;
        Object object2;
        Object object3;
        Object object4;
        if (this.srcJar == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "srcJar"));
        }
        if (this.destJar == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "destJar"));
        }
        if (this.destJar.exists() && this.srcJar.lastModified() <= this.destJar.lastModified()) {
            this.log(Bundle.getMessage("MSG_JarIsUpToDate", this.destJar.getAbsolutePath()), 1);
            return;
        }
        if (this.obfuscatorClassPath == null) {
            this.createObfuscatorClassPath();
        }
        ArrayList<Object> arrayList = Collections.list(new StringTokenizer(Bundle.getMessage("LIST_Obfuscators"), ","));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object4 = (String)arrayList.get(i);
            object3 = this.obfuscatorClassPath.list();
            object2 = this.getProject().getProperty(MessageFormat.format(LIBS_OBFUSCATOR_CLASSPATH_PROPERTY_NAME, ((String)object4).toLowerCase()));
            if (object2 != null) {
                object3 = ObfuscateTask.joinPaths((String[])object3, new Path(this.getProject(), (String)object2).list());
            }
            try {
                if (!ObfuscateTask.isPresent((String[])object3, Bundle.getMessage("COND_" + (String)object4))) {
                    continue;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            arrayList2.add((String)object4);
        }
        if (this.obfuscatorType == null || !arrayList2.contains(this.obfuscatorType)) {
            if (arrayList2.size() <= 0) {
                throw new BuildException(Bundle.getMessage("ERR_NoObfuscator"));
            }
            String string = this.obfuscatorType;
            this.obfuscatorType = (String)arrayList2.get(0);
            if (string == null) {
                this.log(Bundle.getMessage("WARN_ObfuscatorTypeNullMissing", this.obfuscatorType), 1);
            } else {
                this.log(Bundle.getMessage("WARN_ObfuscatorTypeMissing", string, this.obfuscatorType), 1);
            }
        }
        if (!arrayList.contains(this.obfuscatorType)) {
            throw new BuildException(Bundle.getMessage("ERR_UnknownObfuscator", this.obfuscatorType));
        }
        if (this.obfuscationLevel < 0 || this.obfuscationLevel >= 10) {
            this.log(Bundle.getMessage("WARN_InvalidObfuscationLevel", "" + this.obfuscationLevel), 1);
            this.obfuscationLevel = 0;
        }
        if (OBFUSCATOR_TYPE_NONE.equals(this.obfuscatorType) || this.obfuscationLevel == 0) {
            this.doNoObfuscation();
            return;
        }
        String string = Bundle.getMessage("CMD_" + this.obfuscatorType);
        object4 = new HashMap();
        ((HashMap)object4).put("javahome", System.getProperty("java.home"));
        if (this.obfuscatorType != null && (object3 = this.getProject().getProperty(MessageFormat.format(LIBS_OBFUSCATOR_CLASSPATH_PROPERTY_NAME, this.obfuscatorType.toLowerCase()))) != null) {
            this.createObfuscatorClassPath().add(new Path(this.getProject(), (String)object3));
        }
        if (this.obfuscatorClassPath != null && ((String)(object3 = this.obfuscatorClassPath.toString())).length() > 0) {
            ((HashMap)object4).put("obfuscatorclasspath", object3);
        }
        if (this.classPath != null && ((String)(object3 = this.classPath.toString())).length() > 0) {
            ((HashMap)object4).put("classpath", object3);
            object2 = this.classPath.list();
            appendable = new StringBuffer();
            if (object2 != null && ((String[])object2).length > 0) {
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    if (new File(object2[i]).exists()) {
                        if (((StringBuffer)appendable).length() > 0) {
                            ((StringBuffer)appendable).append(File.pathSeparator);
                        }
                        ((StringBuffer)appendable).append("'" + (String)object2[i] + "'");
                        continue;
                    }
                    this.log(Bundle.getMessage("MSG_SkippingPathElement", object2[i]), 3);
                }
                ((HashMap)object4).put("quotedclasspath", ((StringBuffer)appendable).toString());
            }
        }
        ((HashMap)object4).put("srcjar", this.srcJar.getAbsolutePath());
        ((HashMap)object4).put("destjar", this.destJar.getAbsolutePath());
        ((HashMap)object4).put(":", File.pathSeparator);
        ((HashMap)object4).put("/", File.separator);
        object3 = new ArrayList();
        if (this.exclude != null && !"".equals(this.exclude)) {
            object2 = new StringTokenizer(this.exclude, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((ArrayList)object3).add(((StringTokenizer)object2).nextToken());
            }
        }
        this.log(Bundle.getMessage("MSG_ExcludingClasses", ((AbstractCollection)object3).toString()), 3);
        try {
            object2 = File.createTempFile("obfuscator.script.", null);
        }
        catch (IOException iOException) {
            throw new BuildException(Bundle.getMessage("ERR_CannotCreateTempFile", System.getProperty("java.io.tmpdir")));
        }
        try {
            appendable = new PrintWriter(new FileOutputStream((File)object2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            ((File)object2).delete();
            throw new BuildException(Bundle.getMessage("ERR_IOException", ((File)object2).getAbsolutePath()));
        }
        String string2 = "obfuscators/" + this.obfuscatorType.toLowerCase() + "." + this.obfuscationLevel + ".txt";
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new BuildException(Bundle.getMessage("ERR_ObfuscatorScriptIsMissing", string2));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            while ((object = bufferedReader.readLine()) != null) {
                ((PrintWriter)appendable).println((String)object);
            }
        }
        catch (IOException iOException) {
            throw new BuildException(Bundle.getMessage("ERR_ErrorReadingObfsScript", string2));
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        if (this.extraScript != null) {
            ((PrintWriter)appendable).println(this.extraScript);
        }
        object = new HashMap();
        ((HashMap)object).put("leftbrace", "{");
        ((HashMap)object).put("rightbrace", "}");
        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
            ((HashMap)object).put("classname", ((ArrayList)object3).get(i));
            ((HashMap)object).put("slashedclassname", ((String)((ArrayList)object3).get(i)).replace('.', '/'));
            ((PrintWriter)appendable).println(EMapFormat.format(Bundle.getMessage("SCR_ExcludeClasses_" + this.obfuscatorType), (Map<String, Object>)object));
        }
        if (((PrintWriter)appendable).checkError()) {
            ((PrintWriter)appendable).close();
            ((File)object2).delete();
            throw new BuildException(Bundle.getMessage("ERR_IOException", ((File)object2).getAbsolutePath()));
        }
        ((PrintWriter)appendable).close();
        ((HashMap)object4).put("script", ((File)object2).getAbsolutePath());
        string = EMapFormat.format(string, (Map<String, Object>)object4);
        String[] stringArray = Commandline.translateCommandline((String)string);
        this.log(Bundle.getMessage("MSG_ExecCmd", string), 3);
        for (int i = 0; i < stringArray.length; ++i) {
            this.log(">" + stringArray[i] + "<", 3);
        }
        try {
            Execute execute = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.out));
            execute.setAntRun(this.getProject());
            execute.setVMLauncher(true);
            execute.setCommandline(stringArray);
            int n = execute.execute();
            if (n != 0) {
                ((File)object2).delete();
                throw new BuildException(Bundle.getMessage("ERR_ObfuscationFailed", String.valueOf(n)));
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        finally {
            ((File)object2).delete();
        }
    }

    private void doNoObfuscation() {
        this.log(Bundle.getMessage("MSG_CopyingJarFile", this.srcJar.getAbsolutePath(), this.destJar.getAbsolutePath()), 2);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(this.srcJar);
            fileOutputStream = new FileOutputStream(this.destJar);
            byte[] byArray = new byte[16384];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new BuildException(Bundle.getMessage("ERR_CopyingJarFile", this.srcJar.getAbsolutePath(), this.destJar.getAbsolutePath()), (Throwable)iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String[] joinPaths(String[] stringArray, String[] stringArray2) {
        int n = 0;
        if (stringArray != null) {
            n += stringArray.length;
        }
        if (stringArray2 != null) {
            n += stringArray2.length;
        }
        String[] stringArray3 = new String[n];
        int n2 = 0;
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray3, n2, stringArray.length);
            n2 += stringArray.length;
        }
        if (stringArray2 != null) {
            System.arraycopy(stringArray2, 0, stringArray3, n2, stringArray2.length);
        }
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPresent(String[] stringArray, String string) {
        if (string == null) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    File file;
                    if (stringArray[i] == null || !(file = new File(stringArray[i])).exists()) continue;
                    if (file.isDirectory()) {
                        object = new File(file, string2);
                        if (!((File)object).exists() || !((File)object).isFile()) continue;
                        bl = true;
                        break;
                    }
                    object = null;
                    try {
                        object = new ZipFile(file);
                        ZipEntry zipEntry = ((ZipFile)object).getEntry(string2);
                        if (zipEntry == null || zipEntry.isDirectory()) continue;
                        bl = true;
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    finally {
                        if (object != null) {
                            try {
                                ((ZipFile)object).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void setSrcJar(File file) {
        this.srcJar = file;
    }

    public void setDestJar(File file) {
        this.destJar = file;
    }

    public void setObfuscatorType(String string) {
        this.obfuscatorType = string.toUpperCase();
    }

    public void setClassPath(Path path) {
        this.createClassPath().append(path);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public void setExclude(String string) {
        this.exclude = string;
    }

    public void setObfuscatorClassPath(Path path) {
        this.createObfuscatorClassPath().append(path);
    }

    public Path createObfuscatorClassPath() {
        if (this.obfuscatorClassPath == null) {
            this.obfuscatorClassPath = new Path(this.getProject());
        }
        return this.obfuscatorClassPath.createPath();
    }

    public void setObfuscatorClassPathRef(Reference reference) {
        this.createObfuscatorClassPath().setRefid(reference);
    }

    public void setObfuscationLevel(int n) {
        this.obfuscationLevel = n;
    }

    public void setExtraScript(String string) {
        this.extraScript = string;
    }
}

