/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.javame;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.Document;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.io.javame.MEDesignEditorSupport;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MESourceEditorView
implements DataEditorView {
    private static final long serialVersionUID = -1L;
    static final String VIEW_ID = "source";
    private DataObjectContext context;
    private transient CloneableEditor editor;
    private transient JComponent toolbar;

    MESourceEditorView(DataObjectContext dataObjectContext) {
        this.context = dataObjectContext;
        this.init();
    }

    private void init() {
        MEDesignEditorSupport mEDesignEditorSupport = (MEDesignEditorSupport)this.context.getCloneableEditorSupport();
        this.editor = new CloneableEditor((CloneableEditorSupport)mEDesignEditorSupport);
        mEDesignEditorSupport.initializeCloneableEditor(this.editor);
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.CODE;
    }

    public boolean canShowSideWindows() {
        return true;
    }

    public Collection<String> getTags() {
        return Collections.emptySet();
    }

    public String preferredID() {
        return VIEW_ID;
    }

    public String getDisplayName() {
        return ProjectUtils.getSourceEditorViewDisplayName();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MESourceEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.editor;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            Document document;
            JEditorPane jEditorPane = this.editor.getEditorPane();
            if (jEditorPane != null && (document = jEditorPane.getDocument()) instanceof NbDocument.CustomToolbar) {
                this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(jEditorPane);
            }
            if (this.toolbar == null) {
                this.toolbar = new JPanel();
            }
        }
        return this.toolbar;
    }

    public UndoRedo getUndoRedo() {
        return this.editor.getUndoRedo();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return this.getOrder();
    }

    public int getEditPriority() {
        return -this.getOrder();
    }

    public int getOrder() {
        return -1000;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.context);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }
}

