/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.DatasourceComboBoxCustomizer;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceReferencePanel
extends JPanel {
    public static final String IS_VALID = DataSourceReferencePanel.class.getName() + ".IS_VALID";
    private final J2eeModuleProvider provider;
    private final Set<String> refNames;
    private final Set<Datasource> moduleDatasources;
    private final Set<Datasource> serverDatasources;
    private final boolean isDsApiSupportedByServerPlugin;
    private NotificationLineSupport statusLine;
    private JButton addButton;
    private JCheckBox dsCopyToProjectCheck;
    private ButtonGroup dsGroup;
    private JLabel dsReferenceLabel;
    private JTextField dsReferenceText;
    private JComboBox projectDsCombo;
    private JRadioButton projectDsRadio;
    private JComboBox serverDsCombo;
    private JRadioButton serverDsRadio;
    private JLabel warningLabel;

    public DataSourceReferencePanel(J2eeModuleProvider j2eeModuleProvider, Set<String> set, Set<Datasource> set2, Set<Datasource> set3) {
        this.initComponents();
        this.provider = j2eeModuleProvider;
        this.refNames = set;
        this.moduleDatasources = set2;
        this.serverDatasources = set3;
        this.isDsApiSupportedByServerPlugin = this.isDsApiSupportedByServerPlugin();
        this.registerListeners();
        this.setupAddButton();
        this.setupComboBoxes();
        this.handleComboBoxes();
        this.populate();
    }

    public void setNotificationLine(NotificationLineSupport notificationLineSupport) {
        this.statusLine = notificationLineSupport;
        this.verify();
    }

    public String getReferenceName() {
        return this.dsReferenceText.getText().trim();
    }

    public Datasource getDataSource() {
        if (this.projectDsRadio.isSelected()) {
            return (Datasource)this.projectDsCombo.getSelectedItem();
        }
        return (Datasource)this.serverDsCombo.getSelectedItem();
    }

    public boolean copyDataSourceToProject() {
        if (this.projectDsRadio.isSelected()) {
            return false;
        }
        return this.dsCopyToProjectCheck.isSelected();
    }

    private boolean isDsApiSupportedByServerPlugin() {
        return this.provider != null && this.provider.isDatasourceCreationSupported() && Util.isValidServerInstance((J2eeModuleProvider)this.provider);
    }

    private void registerListeners() {
        this.dsReferenceText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                DataSourceReferencePanel.this.verify();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                DataSourceReferencePanel.this.verify();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DataSourceReferencePanel.this.verify();
            }
        });
        this.projectDsRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
                DataSourceReferencePanel.this.handleComboBoxes();
            }
        });
        this.serverDsRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
                DataSourceReferencePanel.this.handleComboBoxes();
            }
        });
        this.projectDsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
            }
        });
        this.serverDsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                DataSourceReferencePanel.this.verify();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                DataSourceReferencePanel.this.verify();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                DataSourceReferencePanel.this.verify();
            }
        });
    }

    private void setupComboBoxes() {
        this.projectDsCombo.setPrototypeDisplayValue("jdbc:pointbase://localhost/sample [pbpublic on PBPUBLIC] ");
        this.projectDsCombo.setRenderer(DatasourceUIHelper.createDatasourceListCellRenderer());
        this.serverDsCombo.setRenderer(DatasourceUIHelper.createDatasourceListCellRenderer());
    }

    private void handleComboBoxes() {
        this.projectDsCombo.setEnabled(this.projectDsRadio.isSelected());
        this.serverDsCombo.setEnabled(this.serverDsRadio.isSelected());
        this.dsCopyToProjectCheck.setEnabled(this.serverDsRadio.isSelected());
    }

    private void populate() {
        DataSourceReferencePanel.populateDataSources(this.moduleDatasources, this.projectDsCombo);
        DataSourceReferencePanel.populateDataSources(this.serverDatasources, this.serverDsCombo);
    }

    private static void populateDataSources(Set<Datasource> set, JComboBox jComboBox) {
        assert (set != null && jComboBox != null);
        ArrayList<Datasource> arrayList = new ArrayList<Datasource>(set);
        Collections.sort(arrayList, DatasourceUIHelper.createDatasourceComparator());
        jComboBox.removeAllItems();
        for (Datasource datasource : arrayList) {
            jComboBox.addItem(datasource);
        }
    }

    private void setupAddButton() {
        if (!this.isDsApiSupportedByServerPlugin) {
            this.addButton.setEnabled(false);
        }
    }

    public void verify() {
        boolean bl = this.verifyComponents();
        this.firePropertyChange(IS_VALID, !bl, bl);
    }

    private boolean verifyComponents() {
        String string = this.dsReferenceText.getText();
        if (string == null || string.trim().length() == 0) {
            this.setInfo("ERR_NO_REFNAME");
            return false;
        }
        if (this.refNames.contains(string = string.trim())) {
            this.setError("ERR_DUPLICATE_REFNAME");
            return false;
        }
        if (this.dsGroup.getSelection() == null) {
            this.setInfo("ERR_NO_DATASOURCE_SELECTED");
            return false;
        }
        if (this.projectDsRadio.isSelected()) {
            if (this.projectDsCombo.getItemCount() == 0 || this.projectDsCombo.getSelectedIndex() == -1) {
                this.setInfo("ERR_NO_DATASOURCE_SELECTED");
                return false;
            }
        } else if (this.serverDsRadio.isSelected() && (this.serverDsCombo.getItemCount() == 0 || this.serverDsCombo.getSelectedIndex() == -1)) {
            this.setInfo("ERR_NO_DATASOURCE_SELECTED");
            return false;
        }
        if (!this.isDsApiSupportedByServerPlugin) {
            this.statusLine.setWarningMessage(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DSC_Warning"));
            return true;
        }
        this.statusLine.clearMessages();
        return true;
    }

    private void setError(String string) {
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(DataSourceReferencePanel.class, (String)string));
        }
    }

    private void setInfo(String string) {
        if (this.statusLine != null) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(DataSourceReferencePanel.class, (String)string));
        }
    }

    private void initComponents() {
        this.dsGroup = new ButtonGroup();
        this.dsReferenceLabel = new JLabel();
        this.dsReferenceText = new JTextField();
        this.projectDsRadio = new JRadioButton();
        this.serverDsRadio = new JRadioButton();
        this.projectDsCombo = new JComboBox();
        this.serverDsCombo = new JComboBox();
        this.dsCopyToProjectCheck = new JCheckBox();
        this.addButton = new JButton();
        this.warningLabel = new JLabel();
        this.dsReferenceLabel.setLabelFor(this.dsReferenceText);
        Mnemonics.setLocalizedText((JLabel)this.dsReferenceLabel, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DsReferenceName"));
        this.dsGroup.add(this.projectDsRadio);
        this.projectDsRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.projectDsRadio, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_ProjectDs"));
        this.projectDsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectDsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.dsGroup.add(this.serverDsRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.serverDsRadio, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_ServerDs"));
        this.serverDsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.serverDsRadio.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.dsCopyToProjectCheck, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DsCopyToProject"));
        this.dsCopyToProjectCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dsCopyToProjectCheck.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DSC_Warning"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.dsCopyToProjectCheck, -1, 560, Short.MAX_VALUE)).add((Component)this.serverDsRadio))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(29, 29, 29).add((Component)this.warningLabel, -1, 486, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectDsRadio).add((Component)this.dsReferenceLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.serverDsCombo, 0, 351, Short.MAX_VALUE).add(1, (Component)this.dsReferenceText, -1, 351, Short.MAX_VALUE).add(1, (Component)this.projectDsCombo, 0, 351, Short.MAX_VALUE)))).addPreferredGap(0).add((Component)this.addButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dsReferenceLabel).add((Component)this.dsReferenceText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectDsRadio).add((Component)this.projectDsCombo, -2, -1, -2).add((Component)this.addButton)).addPreferredGap(0).add((Component)this.warningLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverDsRadio).add((Component)this.serverDsCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.dsCopyToProjectCheck).addContainerGap(-1, Short.MAX_VALUE)));
        this.dsReferenceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_ReferenceName"));
        this.projectDsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_ProjectDataSource"));
        this.serverDsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_ServerDataSource"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_AddDataSource"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_AddDataSourceRef"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_AddDataSourceRef"));
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Datasource datasource = this.handleDataSourceCustomizer();
        if (datasource != null) {
            this.moduleDatasources.add(datasource);
            DataSourceReferencePanel.populateDataSources(this.moduleDatasources, this.projectDsCombo);
            this.projectDsCombo.setSelectedItem(datasource);
        }
    }

    private Datasource handleDataSourceCustomizer() {
        Datasource datasource = null;
        HashSet<Datasource> hashSet = new HashSet<Datasource>(this.moduleDatasources);
        hashSet.addAll(this.serverDatasources);
        DatasourceComboBoxCustomizer datasourceComboBoxCustomizer = new DatasourceComboBoxCustomizer(hashSet);
        if (datasourceComboBoxCustomizer.showDialog()) {
            datasource = this.createDataSource(datasourceComboBoxCustomizer);
        }
        return datasource;
    }

    private Datasource createDataSource(DatasourceComboBoxCustomizer datasourceComboBoxCustomizer) {
        if (this.isDsApiSupportedByServerPlugin) {
            return this.createServerDataSource(datasourceComboBoxCustomizer);
        }
        return this.createProjectDataSource(datasourceComboBoxCustomizer);
    }

    private Datasource createServerDataSource(DatasourceComboBoxCustomizer datasourceComboBoxCustomizer) {
        final Datasource[] datasourceArray = new Datasource[1];
        final String string = datasourceComboBoxCustomizer.getPassword();
        final String string2 = datasourceComboBoxCustomizer.getJndiName();
        final String string3 = datasourceComboBoxCustomizer.getUrl();
        final String string4 = datasourceComboBoxCustomizer.getUsername();
        final String string5 = datasourceComboBoxCustomizer.getDriverClassName();
        ProgressSupport.BackgroundAction backgroundAction = new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context context) {
                String string6 = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_creatingDS");
                context.progress(string6);
                try {
                    datasourceArray[0] = DataSourceReferencePanel.this.provider.createDatasource(string2, string3, string4, string, string5);
                }
                catch (DatasourceAlreadyExistsException datasourceAlreadyExistsException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Datasource datasource : datasourceAlreadyExistsException.getDatasources()) {
                        stringBuilder.append(datasource.toString() + "\n");
                    }
                    String string22 = NbBundle.getMessage(DatasourceUIHelper.class, (String)"ERR_DsConflict", (Object)stringBuilder.toString());
                    Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)datasourceAlreadyExistsException, (String)string22));
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            }

            public boolean isEnabled() {
                return string != null;
            }
        };
        Set<8> set = Collections.singleton(backgroundAction);
        ProgressSupport.invoke(set);
        return datasourceArray[0];
    }

    private Datasource createProjectDataSource(DatasourceComboBoxCustomizer datasourceComboBoxCustomizer) {
        return new DatasourceImpl(datasourceComboBoxCustomizer.getJndiName(), datasourceComboBoxCustomizer.getUrl(), datasourceComboBoxCustomizer.getUsername(), datasourceComboBoxCustomizer.getPassword(), datasourceComboBoxCustomizer.getDriverClassName());
    }

    private static class DatasourceImpl
    implements Datasource {
        private final String jndiName;
        private final String url;
        private final String username;
        private final String password;
        private final String driverClassName;
        private String displayName;

        public DatasourceImpl(String string, String string2, String string3, String string4, String string5) {
            this.jndiName = string;
            this.url = string2;
            this.username = string3;
            this.password = string4;
            this.driverClassName = string5;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.getJndiName() + " [" + this.getUrl() + "]";
            }
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

