/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.AbstractLog;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RawDiagnosticFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log
extends AbstractLog {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    public final int MaxErrors;
    public final int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean dumpOnError;
    public boolean multipleErrors;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    public Set<String> expectDiagKeys;
    private JavacMessages messages;
    private boolean partialReparse;
    private final Set<Pair<JavaFileObject, Integer>> partialReparseRecorded = new HashSet<Pair<JavaFileObject, Integer>>();
    private final Map<JCTree, JCDiagnostic> errTrees = new HashMap<JCTree, JCDiagnostic>();
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();

    @Deprecated
    protected Log(Context context, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        super(JCDiagnostic.Factory.instance(context));
        DiagnosticListener dl;
        context.put(logKey, this);
        this.errWriter = errWriter;
        this.warnWriter = warnWriter;
        this.noticeWriter = noticeWriter;
        Options options = Options.instance(context);
        this.dumpOnError = options.get("-doe") != null;
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-Xlint:none") == null;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
        boolean rawDiagnostics = options.get("rawDiagnostics") != null;
        this.messages = JavacMessages.instance(context);
        this.diagFormatter = rawDiagnostics ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this.messages);
        this.diagListener = dl = context.get(DiagnosticListener.class);
        String ek = options.get("expectKeys");
        if (ek != null) {
            this.expectDiagKeys = new HashSet<String>(Arrays.asList(ek.split(", *")));
        }
    }

    private int getIntOption(Options options, String optionName, int defaultValue) {
        String s = options.get(optionName);
        try {
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return defaultValue;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter result = context.get(outKey);
        if (result == null) {
            result = new PrintWriter(System.err);
            context.put(outKey, result);
        }
        return result;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter defaultWriter) {
        this(context, defaultWriter, defaultWriter, defaultWriter);
    }

    public static Log instance(Context context) {
        Log instance = context.get(logKey);
        if (instance == null) {
            instance = new Log(context);
        }
        return instance;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject name, Map<JCTree, Integer> table) {
        name.getClass();
        this.getSource(name).setEndPosTable(table);
    }

    public void startPartialReparse() {
        assert (this.partialReparseRecorded.isEmpty());
        this.nerrors = 0;
        this.nwarnings = 0;
        this.partialReparse = true;
    }

    public void endPartialReparse() {
        this.partialReparseRecorded.clear();
        this.partialReparse = false;
    }

    public JavaFileObject currentSourceFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public DiagnosticFormatter<JCDiagnostic> getDiagnosticFormatter() {
        return this.diagFormatter;
    }

    public void setDiagnosticFormatter(DiagnosticFormatter<JCDiagnostic> diagFormatter) {
        this.diagFormatter = diagFormatter;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    protected boolean shouldReport(JavaFileObject file, int pos) {
        boolean shouldReport;
        if (this.multipleErrors || file == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> coords = new Pair<JavaFileObject, Integer>(file, pos);
        if (this.partialReparse) {
            boolean shouldReport2;
            boolean bl = shouldReport2 = !this.partialReparseRecorded.contains(coords);
            if (shouldReport2) {
                this.partialReparseRecorded.add(coords);
            }
            return shouldReport2;
        }
        boolean bl = shouldReport = !this.recorded.contains(coords);
        if (shouldReport) {
            this.recorded.add(coords);
        }
        return shouldReport;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int pos, PrintWriter writer) {
        String line;
        String string = line = this.source == null ? null : this.source.getLine(pos);
        if (line == null) {
            return;
        }
        int col = this.source.getColumnNumber(pos, false);
        Log.printLines(writer, line);
        for (int i = 0; i < col - 1; ++i) {
            writer.print(line.charAt(i) == '\t' ? "\t" : " ");
        }
        writer.println("^");
        writer.flush();
    }

    public static void printLines(PrintWriter writer, String msg) {
        int nl;
        while ((nl = msg.indexOf(10)) != -1) {
            writer.println(msg.substring(0, nl));
            msg = msg.substring(nl + 1);
        }
        if (msg.length() != 0) {
            writer.println(msg);
        }
    }

    @Override
    protected void directError(String key, Object ... args) {
        Log.printLines(this.errWriter, Log.getLocalizedString(key, args));
        this.errWriter.flush();
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.writeDiagnostic(this.diags.warning(this.source, pos, key, args));
        ++this.nwarnings;
    }

    @Override
    public void report(JCDiagnostic diagnostic) {
        if (this.expectDiagKeys != null) {
            this.expectDiagKeys.remove(diagnostic.getCode());
        }
        switch (diagnostic.getType()) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                if (!this.emitWarnings && !diagnostic.isMandatory()) break;
                this.writeDiagnostic(diagnostic);
                break;
            }
            case WARNING: {
                if (!this.emitWarnings && !diagnostic.isMandatory() || this.nwarnings >= this.MaxWarnings) break;
                this.writeDiagnostic(diagnostic);
                ++this.nwarnings;
                break;
            }
            case ERROR: {
                if (diagnostic.getTree() != null && !this.errTrees.containsKey(diagnostic.getTree())) {
                    this.errTrees.put(diagnostic.getTree(), diagnostic);
                }
                if (this.nerrors >= this.MaxErrors || !this.shouldReport(diagnostic.getSource(), diagnostic.getIntPosition())) break;
                this.writeDiagnostic(diagnostic);
                ++this.nerrors;
            }
        }
    }

    protected void writeDiagnostic(JCDiagnostic diag) {
        if (this.diagListener != null) {
            try {
                this.diagListener.report(diag);
                return;
            }
            catch (Throwable t) {
                throw new ClientCodeException(t);
            }
        }
        PrintWriter writer = this.getWriterForDiagnosticType(diag.getType());
        Log.printLines(writer, this.diagFormatter.format(diag, this.messages.getCurrentLocale()));
        if (this.promptOnError) {
            switch (diag.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(writer);
        }
        writer.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType dt) {
        switch (dt) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String key, Object ... args) {
        return JavacMessages.getDefaultLocalizedString("compiler.misc." + key, args);
    }

    private void printRawError(int pos, String msg) {
        if (this.source == null || pos == -1) {
            Log.printLines(this.errWriter, "error: " + msg);
        } else {
            int line = this.source.getLineNumber(pos);
            JavaFileObject file = this.source.getFile();
            if (file != null) {
                Log.printLines(this.errWriter, JavacFileManager.getJavacFileName(file) + ":" + line + ": " + msg);
            }
            this.printErrLine(pos, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int pos, String msg) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSourceFile(), pos)) {
            this.printRawError(pos, msg);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int pos, String msg) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(pos, "warning: " + msg);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }

    public static String format(String fmt, Object ... args) {
        return String.format((Locale)null, fmt, args);
    }

    public JCDiagnostic getErrDiag(JCTree tree) {
        return this.errTrees.get(tree);
    }
}

