/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.util.List;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Set;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileIndexArchive
implements JavacFileManager.Archive {
    private final ZipFileIndex zfIndex;
    private JavacFileManager fileManager;

    public ZipFileIndexArchive(JavacFileManager fileManager, ZipFileIndex zdir) throws IOException {
        this.fileManager = fileManager;
        this.zfIndex = zdir;
    }

    @Override
    public boolean contains(RelativePath name) {
        return this.zfIndex.contains(name);
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory subdirectory) {
        return this.zfIndex.getFiles(subdirectory);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory subdirectory, String file) {
        RelativePath.RelativeFile fullZipFileName = new RelativePath.RelativeFile(subdirectory, file);
        ZipFileIndex.Entry entry = this.zfIndex.getZipIndexEntry(fullZipFileName);
        ZipFileIndexFileObject ret = new ZipFileIndexFileObject(this.fileManager, this.zfIndex, entry, this.zfIndex.getZipFile().getPath());
        return ret;
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        return this.zfIndex.getAllDirectories();
    }

    @Override
    public void close() throws IOException {
        this.zfIndex.close();
    }

    public String toString() {
        return "ZipFileIndexArchive[" + this.zfIndex + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipFileIndexFileObject
    extends BaseFileObject {
        private String name;
        ZipFileIndex zfIndex;
        ZipFileIndex.Entry entry;
        InputStream inputStream = null;
        String zipName;

        ZipFileIndexFileObject(JavacFileManager fileManager, ZipFileIndex zfIndex, ZipFileIndex.Entry entry, String zipFileName) {
            super(fileManager);
            this.name = entry.getFileName();
            this.zfIndex = zfIndex;
            this.entry = entry;
            this.zipName = zipFileName;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new ByteArrayInputStream(this.read());
            }
            return this.inputStream;
        }

        @Override
        protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNameCompatible(String cn, JavaFileObject.Kind k) {
            cn.getClass();
            if (k == JavaFileObject.Kind.OTHER && this.getKind() != k) {
                return false;
            }
            return this.name.equals(cn + k.extension);
        }

        @Override
        @Deprecated
        public String getPath() {
            return this.zipName + "(" + this.entry.getName() + ")";
        }

        @Override
        public long getLastModified() {
            return this.entry.getLastModified();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ZipFileIndexFileObject)) {
                return false;
            }
            ZipFileIndexFileObject o = (ZipFileIndexFileObject)other;
            return this.entry.equals(o.entry);
        }

        public int hashCode() {
            return this.zipName.hashCode() + (this.name.hashCode() << 10);
        }

        public String getZipName() {
            return this.zipName;
        }

        public String getZipEntryName() {
            return this.entry.getName();
        }

        @Override
        public URI toUri() {
            String zipName = new File(this.getZipName()).toURI().normalize().getPath();
            String entryName = this.getZipEntryName();
            return URI.create("jar:" + zipName + "!" + entryName);
        }

        private byte[] read() throws IOException {
            assert (this.entry != null);
            return this.zfIndex.read(this.entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb = this.fileManager.getCachedContent(this);
            if (cb == null) {
                ByteArrayInputStream in = new ByteArrayInputStream(this.zfIndex.read(this.entry));
                try {
                    ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                    JavaFileObject prev = this.fileManager.log.useSource(this);
                    try {
                        cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.fileManager.log.useSource(prev);
                        throw throwable;
                    }
                    this.fileManager.log.useSource(prev);
                    this.fileManager.recycleByteBuffer(bb);
                    if (!ignoreEncodingErrors) {
                        this.fileManager.cache(this, cb);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    ((InputStream)in).close();
                    throw throwable;
                }
                ((InputStream)in).close();
                {
                }
            }
            return cb;
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> path) {
            String prefix;
            String entryName = this.getZipEntryName();
            if (this.zfIndex.symbolFilePrefix != null && entryName.startsWith(prefix = this.zfIndex.symbolFilePrefix.path)) {
                entryName = entryName.substring(prefix.length());
            }
            return ZipFileIndexFileObject.removeExtension(entryName).replace('/', '.');
        }
    }
}

