/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.errors.CoreErrorReporter;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.monitor.event.MavenWorkspaceMonitor;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.realm.MavenRealmManager;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.events.TransferListener;

public class DefaultMavenExecutionRequest
implements MavenExecutionRequest {
    private ArtifactRepository localRepository;
    private File localRepositoryPath;
    private boolean offline = false;
    private boolean interactiveMode = true;
    private List proxies;
    private List servers;
    private List mirrors;
    private List profiles;
    private List pluginGroups;
    private boolean usePluginUpdateOverride;
    private boolean isProjectPresent = true;
    private File userSettingsFile;
    private File globalSettingsFile;
    private File basedir;
    private List goals;
    private boolean useReactor = false;
    private boolean recursive = true;
    private File pom;
    private String reactorFailureBehavior = "fail-fast";
    private Properties properties;
    private Properties userProperties;
    private Date startTime;
    private boolean showErrors = false;
    private List eventMonitors;
    private MavenWorkspaceMonitor workspaceMonitor;
    private List activeProfiles;
    private List inactiveProfiles;
    private TransferListener transferListener;
    private int loggingLevel = 1;
    private String globalChecksumPolicy = "warn";
    private boolean updateSnapshots = false;
    private ProfileManager profileManager;
    private List remoteRepositories;
    private boolean noSnapshotUpdates;
    private MavenRealmManager realmManager;
    private Settings settings;
    private CoreErrorReporter errorReporter;
    private ProfileActivationContext profileActivationContext;
    private ProjectBuilderConfiguration projectBuildingConfiguration;

    public DefaultMavenExecutionRequest() {
    }

    public DefaultMavenExecutionRequest(MavenExecutionRequest original) {
        this.localRepository = original.getLocalRepository();
        this.localRepositoryPath = original.getLocalRepositoryPath();
        this.offline = original.isOffline();
        this.interactiveMode = original.isInteractiveMode();
        this.proxies = original.getProxies();
        this.servers = original.getServers();
        this.mirrors = original.getMirrors();
        this.profiles = original.getProfiles();
        this.pluginGroups = original.getPluginGroups();
        this.usePluginUpdateOverride = original.isUsePluginUpdateOverride();
        this.isProjectPresent = original.isProjectPresent();
        this.userSettingsFile = original.getUserSettingsFile();
        this.globalSettingsFile = original.getGlobalSettingsFile();
        this.basedir = new File(original.getBaseDirectory());
        this.goals = original.getGoals();
        this.useReactor = original.useReactor();
        this.recursive = original.isRecursive();
        this.pom = original.getPom();
        this.reactorFailureBehavior = original.getReactorFailureBehavior();
        this.properties = original.getProperties();
        this.startTime = original.getStartTime();
        this.showErrors = original.isShowErrors();
        this.eventMonitors = original.getEventMonitors();
        this.activeProfiles = original.getActiveProfiles();
        this.inactiveProfiles = original.getInactiveProfiles();
        this.transferListener = original.getTransferListener();
        this.loggingLevel = original.getLoggingLevel();
        this.globalChecksumPolicy = original.getGlobalChecksumPolicy();
        this.updateSnapshots = original.isUpdateSnapshots();
        this.profileManager = original.getProfileManager();
        this.remoteRepositories = original.getRemoteRepositories();
        this.noSnapshotUpdates = original.isNoSnapshotUpdates();
        this.realmManager = original.getRealmManager();
    }

    public String getBaseDirectory() {
        if (this.basedir == null) {
            return null;
        }
        return this.basedir.getAbsolutePath();
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public File getLocalRepositoryPath() {
        return this.localRepositoryPath;
    }

    public List getGoals() {
        return this.goals;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPomFile() {
        return this.pom.getAbsolutePath();
    }

    public File getPom() {
        return this.pom;
    }

    public String getReactorFailureBehavior() {
        return this.reactorFailureBehavior;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public List getEventMonitors() {
        return this.eventMonitors;
    }

    public List getActiveProfiles() {
        if (this.activeProfiles == null) {
            this.activeProfiles = new ArrayList();
        }
        return this.activeProfiles;
    }

    public List getInactiveProfiles() {
        if (this.inactiveProfiles == null) {
            this.inactiveProfiles = new ArrayList();
        }
        return this.inactiveProfiles;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    public boolean isNoSnapshotUpdates() {
        return this.noSnapshotUpdates;
    }

    public String getGlobalChecksumPolicy() {
        return this.globalChecksumPolicy;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public MavenExecutionRequest setBaseDirectory(File basedir) {
        this.basedir = basedir;
        return this;
    }

    public MavenExecutionRequest setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public MavenExecutionRequest setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
        return this;
    }

    public MavenExecutionRequest setGoals(List goals) {
        this.goals = goals;
        return this;
    }

    public MavenExecutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public MavenExecutionRequest setLocalRepositoryPath(File localRepository) {
        this.localRepositoryPath = localRepository;
        return this;
    }

    public MavenExecutionRequest setLocalRepositoryPath(String localRepository) {
        this.localRepositoryPath = new File(localRepository);
        return this;
    }

    public MavenExecutionRequest setProperties(Properties properties) {
        if (this.properties == null) {
            this.properties = properties;
        } else {
            this.properties.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    public MavenExecutionRequest setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
        if (this.userProperties == null) {
            this.userProperties = new Properties();
        }
        this.userProperties.setProperty(key, value);
        return this;
    }

    public MavenExecutionRequest setReactorFailureBehavior(String failureBehavior) {
        this.reactorFailureBehavior = failureBehavior;
        return this;
    }

    public MavenExecutionRequest addActiveProfile(String profile) {
        this.getActiveProfiles().add(profile);
        return this;
    }

    public MavenExecutionRequest addInactiveProfile(String profile) {
        this.getInactiveProfiles().add(profile);
        return this;
    }

    public MavenExecutionRequest addActiveProfiles(List profiles) {
        this.getActiveProfiles().addAll(profiles);
        return this;
    }

    public MavenExecutionRequest addInactiveProfiles(List profiles) {
        this.getInactiveProfiles().addAll(profiles);
        return this;
    }

    public MavenExecutionRequest addEventMonitor(EventMonitor monitor) {
        if (this.eventMonitors == null) {
            this.eventMonitors = new ArrayList();
        }
        this.eventMonitors.add(monitor);
        return this;
    }

    public MavenExecutionRequest setUseReactor(boolean reactorActive) {
        this.useReactor = reactorActive;
        return this;
    }

    public boolean useReactor() {
        return this.useReactor;
    }

    public MavenExecutionRequest setPomFile(String pomFilename) {
        if (pomFilename != null) {
            this.pom = new File(pomFilename);
        }
        return this;
    }

    public MavenExecutionRequest setPom(File pom) {
        this.pom = pom;
        return this;
    }

    public MavenExecutionRequest setInteractiveMode(boolean interactive) {
        this.interactiveMode = interactive;
        return this;
    }

    public MavenExecutionRequest setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    public MavenExecutionRequest setLoggingLevel(int loggingLevel) {
        this.loggingLevel = loggingLevel;
        return this;
    }

    public MavenExecutionRequest setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public MavenExecutionRequest setUpdateSnapshots(boolean updateSnapshots) {
        this.updateSnapshots = updateSnapshots;
        return this;
    }

    public MavenExecutionRequest setNoSnapshotUpdates(boolean noSnapshotUpdates) {
        this.noSnapshotUpdates = noSnapshotUpdates;
        return this;
    }

    public MavenExecutionRequest setGlobalChecksumPolicy(String globalChecksumPolicy) {
        this.globalChecksumPolicy = globalChecksumPolicy;
        return this;
    }

    public List getProxies() {
        return this.proxies;
    }

    public MavenExecutionRequest setProxies(List proxies) {
        this.proxies = proxies;
        return this;
    }

    public List getServers() {
        return this.servers;
    }

    public MavenExecutionRequest setServers(List servers) {
        this.servers = servers;
        return this;
    }

    public List getMirrors() {
        return this.mirrors;
    }

    public MavenExecutionRequest setMirrors(List mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    public List getProfiles() {
        return this.profiles;
    }

    public MavenExecutionRequest setProfiles(List profiles) {
        this.profiles = profiles;
        return this;
    }

    public List getPluginGroups() {
        return this.pluginGroups;
    }

    public MavenExecutionRequest setPluginGroups(List pluginGroups) {
        this.pluginGroups = pluginGroups;
        return this;
    }

    public boolean isUsePluginUpdateOverride() {
        return this.usePluginUpdateOverride;
    }

    public MavenExecutionRequest setUsePluginUpdateOverride(boolean usePluginUpdateOverride) {
        this.usePluginUpdateOverride = usePluginUpdateOverride;
        return this;
    }

    public MavenExecutionRequest setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public MavenExecutionRequest setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public MavenExecutionRequest setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
        return this;
    }

    public boolean isProjectPresent() {
        return this.isProjectPresent;
    }

    public MavenExecutionRequest setProjectPresent(boolean projectPresent) {
        this.isProjectPresent = projectPresent;
        return this;
    }

    public File getUserSettingsFile() {
        return this.userSettingsFile;
    }

    public MavenExecutionRequest setUserSettingsFile(File userSettingsFile) {
        this.userSettingsFile = userSettingsFile;
        return this;
    }

    public File getGlobalSettingsFile() {
        return this.globalSettingsFile;
    }

    public MavenExecutionRequest setGlobalSettingsFile(File globalSettingsFile) {
        this.globalSettingsFile = globalSettingsFile;
        return this;
    }

    public MavenExecutionRequest addRemoteRepository(ArtifactRepository repository) {
        if (this.remoteRepositories == null) {
            this.remoteRepositories = new ArrayList();
        }
        this.remoteRepositories.add(repository);
        return this;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public MavenExecutionRequest setRealmManager(MavenRealmManager realmManager) {
        this.realmManager = realmManager;
        return this;
    }

    public MavenRealmManager getRealmManager() {
        return this.realmManager;
    }

    public MavenExecutionRequest clearAccumulatedBuildState() {
        this.realmManager.clear();
        return this;
    }

    public CoreErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public MavenExecutionRequest setErrorReporter(CoreErrorReporter reporter) {
        this.errorReporter = reporter;
        return this;
    }

    public ProfileActivationContext getProfileActivationContext() {
        return this.profileActivationContext;
    }

    public MavenExecutionRequest setProfileActivationContext(ProfileActivationContext profileActivationContext) {
        this.profileActivationContext = profileActivationContext;
        return this;
    }

    public MavenWorkspaceMonitor getWorkspaceMonitor() {
        return this.workspaceMonitor;
    }

    public MavenExecutionRequest setWorkspaceMonitor(MavenWorkspaceMonitor workspaceMonitor) {
        this.workspaceMonitor = workspaceMonitor;
        return this;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public MavenExecutionRequest setUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    public ProjectBuilderConfiguration getProjectBuildingConfiguration() {
        if (this.projectBuildingConfiguration == null) {
            this.projectBuildingConfiguration = new DefaultProjectBuilderConfiguration();
            this.projectBuildingConfiguration.setLocalRepository(this.getLocalRepository());
            this.projectBuildingConfiguration.setExecutionProperties(this.getProperties());
            this.projectBuildingConfiguration.setGlobalProfileManager(this.getProfileManager());
            this.projectBuildingConfiguration.setUserProperties(this.getUserProperties());
        }
        return this.projectBuildingConfiguration;
    }
}

