/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.pagecontentmodel;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageContentItem {
    private Image icon;
    private String fromAction;
    private String fromOutcome;
    private String name;
    private List<Action> actions;
    private Image bufferedIcon = null;
    private static final Image UNKONWN_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/graph/resources/question.png");
    private static final Logger LOG = Logger.getLogger(PageContentItem.class.toString());

    public Action[] getActions() {
        return new Action[0];
    }

    public PageContentItem(String string, String string2, String string3, Image image) {
        this.name = string;
        this.fromAction = string2;
        this.fromOutcome = string3;
        this.icon = image;
    }

    public PageContentItem(String string, String string2, Image image) {
        this.name = string;
        this.fromOutcome = string2;
        this.icon = image;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getFromAction() {
        return this.fromAction;
    }

    public void setFromAction(String string) {
        this.fromAction = string;
    }

    public String getFromOutcome() {
        return this.fromOutcome;
    }

    public void setFromOutcome(String string) {
        this.fromOutcome = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "PageBean[" + this.getName() + ", fromOutcome=" + this.getFromOutcome() + ", fromAction=" + this.getFromAction() + "," + this.getIcon() + "]";
    }

    public Image getBufferedIcon() {
        if (this.bufferedIcon == null) {
            this.bufferedIcon = this.toBufferedImage(this.getIcon());
        }
        return this.bufferedIcon;
    }

    private Image toBufferedImage(Image image) {
        if (image == null) {
            LOG.fine("Page Content Item does not have Image: " + this.toString());
            image = UNKONWN_ICON;
        }
        new ImageIcon(image);
        BufferedImage bufferedImage = this.createBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    private BufferedImage createBufferedImage(int n, int n2) {
        if (Utilities.getOperatingSystem() == 4096) {
            return new BufferedImage(n, n2, 3);
        }
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        return null;
    }
}

