/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.JoinTokenListChange;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.inc.TokenListListUpdate;
import org.netbeans.lib.lexer.inc.TokenListUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyUpdate {
    static final Logger LOG = Logger.getLogger(TokenHierarchyUpdate.class.getName());
    private static final UpdateItem<?> NO_ITEM = new UpdateItem(null, null, null);
    final TokenHierarchyEventInfo eventInfo;
    private List<List<UpdateItem<?>>> itemLevels;
    private Map<LanguagePath, UpdateItem<?>> path2Item;
    private LanguagePath lastPath2ItemPath;
    private UpdateItem<?> lastPath2ItemItem;

    public static <T extends TokenId> UpdateItem<T> createUpdateItem(TokenListChange<T> tokenListChange) {
        UpdateItem updateItem = new UpdateItem(null, null, null);
        updateItem.tokenListChange = tokenListChange;
        return updateItem;
    }

    public TokenHierarchyUpdate(TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        this.eventInfo = tokenHierarchyEventInfo;
    }

    public void update() {
        CharSequence charSequence;
        TokenHierarchyOperation<?, ?> tokenHierarchyOperation = this.eventInfo.tokenHierarchyOperation();
        IncTokenList incTokenList = (IncTokenList)tokenHierarchyOperation.rootTokenList();
        if (LOG.isLoggable(Level.FINE)) {
            if (LOG.isLoggable(Level.FINEST)) {
                charSequence = incTokenList.inputSourceText();
                assert (charSequence != null);
                incTokenList.setInputSourceText((CharSequence)((Object)this.eventInfo.originalText()));
                LOG.finest("\n\nBEFORE UPDATE:\n" + tokenHierarchyOperation.toString() + '\n');
                incTokenList.setInputSourceText(charSequence);
            }
            charSequence = new StringBuilder(150);
            ((StringBuilder)charSequence).append("<<<<<<<<<<<<<<<<<< LEXER CHANGE START ------------------\n");
            ((StringBuilder)charSequence).append(this.eventInfo.modificationDescription(false));
            LOG.fine(((StringBuilder)charSequence).toString());
        }
        this.updateImpl(incTokenList, tokenHierarchyOperation.rootChildrenLanguages());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("AFFECTED: " + this.eventInfo.dumpAffected() + "\n");
            charSequence = "";
            if (LOG.isLoggable(Level.FINER)) {
                String string = tokenHierarchyOperation.checkConsistency();
                if (string != null) {
                    String string2 = "\n!!!CONSISTENCY-ERROR!!!: " + string + "\n\n" + "INCONSISTENT TOKEN HIERARCHY:\n" + tokenHierarchyOperation + "\n\n";
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(string2);
                    }
                    throw new IllegalStateException("INCONSISTENCY in token hierarchy occurred");
                }
                charSequence = "(TokenHierarchy Check OK) ";
            }
            LOG.fine(">>>>>>>>>>>>>>>>>> LEXER CHANGE END " + (String)charSequence + "------------------\n");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("\n\nAFTER UPDATE:\n" + tokenHierarchyOperation.toString() + '\n');
        }
    }

    private <T extends TokenId> void updateImpl(IncTokenList<T> incTokenList, Set<Language<?>> set) {
        incTokenList.incrementModCount();
        this.itemLevels = new ArrayList(3);
        UpdateItem updateItem = new UpdateItem(this, null, set);
        updateItem.tokenListChange = new TokenListChange<T>(incTokenList);
        this.addItem(updateItem, 0);
        this.processLevelInfos();
    }

    public <T extends TokenId> void updateCreateOrRemoveEmbedding(EmbeddedTokenList<T> embeddedTokenList, boolean bl) {
        LanguagePath languagePath = embeddedTokenList.languagePath();
        int n = languagePath.size() - 1;
        this.itemLevels = new ArrayList(n + 2);
        UpdateItem<T> updateItem = this.tokenListListItem(languagePath);
        if (updateItem != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("THU.updateCreateOrRemoveEmbedding() add=" + bl + ": " + embeddedTokenList.dumpInfo(null));
            }
            if (bl) {
                updateItem.tokenListListUpdate.markAddedMember(embeddedTokenList);
            } else {
                updateItem.tokenListListUpdate.markRemovedMember(embeddedTokenList, this.eventInfo);
            }
            this.processLevelInfos();
        }
    }

    private void processLevelInfos() {
        for (int i = 0; i < this.itemLevels.size(); ++i) {
            List<UpdateItem<?>> list = this.itemLevels.get(i);
            for (UpdateItem<?> updateItem : list) {
                updateItem.update();
            }
        }
    }

    void addItem(UpdateItem<?> updateItem, int n) {
        while (n >= this.itemLevels.size()) {
            this.itemLevels.add(new ArrayList(3));
        }
        List<UpdateItem<?>> list = this.itemLevels.get(n);
        list.add(updateItem);
    }

    private <T extends TokenId> UpdateItem<T> tokenListListItem(LanguagePath languagePath) {
        UpdateItem<Object> updateItem;
        if (languagePath == this.lastPath2ItemPath) {
            UpdateItem<?> updateItem2 = this.lastPath2ItemItem;
            return updateItem2;
        }
        if (this.path2Item == null) {
            this.path2Item = new HashMap(4, 0.5f);
        }
        if ((updateItem = this.path2Item.get(languagePath)) == NO_ITEM) {
            updateItem = null;
        } else if (updateItem == null) {
            TokenListList tokenListList = this.eventInfo.tokenHierarchyOperation().existingTokenListList(languagePath);
            if (tokenListList != null) {
                updateItem = new UpdateItem(this, tokenListList, tokenListList.childrenLanguages());
                int n = languagePath.size() - 1;
                this.addItem(updateItem, n);
                this.path2Item.put(languagePath, updateItem);
            } else {
                this.path2Item.put(languagePath, NO_ITEM);
            }
        }
        this.lastPath2ItemItem = updateItem;
        return updateItem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UpdateItem<T extends TokenId> {
        final TokenHierarchyUpdate update;
        final TokenListListUpdate<T> tokenListListUpdate;
        final Set<Language<?>> childrenLanguages;
        UpdateItem<?> parentItem;
        TokenListChange<T> tokenListChange;

        public UpdateItem(TokenHierarchyUpdate tokenHierarchyUpdate, TokenListList<T> tokenListList, Set<Language<?>> set) {
            this.update = tokenHierarchyUpdate;
            this.tokenListListUpdate = tokenListList != null ? new TokenListListUpdate<T>(tokenListList) : null;
            this.childrenLanguages = set;
        }

        void setParentItem(UpdateItem<?> updateItem) {
            assert (this.parentItem == null);
            this.parentItem = updateItem;
        }

        void initTokenListChange(EmbeddedTokenList<T> embeddedTokenList) {
            assert (this.tokenListChange == null);
            this.tokenListChange = this.tokenListListUpdate != null ? this.tokenListListUpdate.createTokenListChange(embeddedTokenList) : new TokenListChange<T>(embeddedTokenList);
        }

        void update() {
            JoinTokenListChange joinTokenListChange;
            TokenHierarchyEventInfo tokenHierarchyEventInfo = this.update.eventInfo;
            if (this.tokenListChange == null) {
                assert (this.tokenListListUpdate != null);
                if (this.tokenListListUpdate.tokenListList.joinSections()) {
                    this.tokenListChange = this.tokenListListUpdate.createJoinTokenListChange();
                }
            }
            if (this.tokenListListUpdate != null && this.tokenListListUpdate.addedTokenLists == null) {
                this.tokenListListUpdate.addedTokenLists = Collections.emptyList();
            }
            if (this.tokenListChange != null) {
                this.tokenListChange.setParentChangeIsBoundsChange(this.parentItem != null && this.parentItem.tokenListChange != null && this.parentItem.tokenListChange.isBoundsChange());
                if (this.tokenListChange.getClass() == JoinTokenListChange.class) {
                    joinTokenListChange = (JoinTokenListChange)this.tokenListChange;
                    assert (this.tokenListListUpdate != null);
                    assert (this.tokenListListUpdate.modTokenListIndex != -1);
                    joinTokenListChange.setTokenListListUpdate(this.tokenListListUpdate);
                    TokenListUpdater.updateJoined(joinTokenListChange, tokenHierarchyEventInfo);
                } else {
                    TokenListUpdater.updateRegular(this.tokenListChange, tokenHierarchyEventInfo);
                    if (this.parentItem == null) {
                        tokenHierarchyEventInfo.setTokenChangeInfo(this.tokenListChange.tokenChangeInfo());
                    }
                }
                if (this.tokenListChange.isBoundsChange()) {
                    Object object;
                    if (this.tokenListChange.getClass() == JoinTokenListChange.class) {
                        object = (JoinTokenListChange)this.tokenListChange;
                        assert (((JoinTokenListChange)object).relexChanges().size() == 1);
                        joinTokenListChange = ((JoinTokenListChange)object).relexChanges().get(0);
                    } else {
                        joinTokenListChange = this.tokenListChange;
                    }
                    object = this.processBoundsChange(joinTokenListChange);
                    if (object != null) {
                        this.collectAddedEmbeddings(joinTokenListChange, (Set<Language<?>>)object);
                    }
                } else {
                    tokenHierarchyEventInfo.setMinAffectedStartOffset(this.tokenListChange.offset());
                    tokenHierarchyEventInfo.setMaxAffectedEndOffset(this.tokenListChange.addedEndOffset());
                    if (this.childrenLanguages.size() > 0) {
                        if (this.tokenListChange.getClass() == JoinTokenListChange.class) {
                            joinTokenListChange = (JoinTokenListChange)this.tokenListChange;
                            joinTokenListChange.collectAddedRemovedEmbeddings(this);
                        } else {
                            this.collectRemovedEmbeddings(this.tokenListChange);
                            this.collectAddedEmbeddings(this.tokenListChange);
                        }
                    }
                }
            } else if (this.tokenListListUpdate != null) {
                this.tokenListListUpdate.replaceTokenLists(0);
                this.tokenListListUpdate.collectRemovedEmbeddings(this);
                this.tokenListListUpdate.collectAddedEmbeddings(this);
            }
            if (this.parentItem != null && this.tokenListChange != null) {
                joinTokenListChange = this.parentItem;
                while (((UpdateItem)((Object)joinTokenListChange)).tokenListChange == null) {
                    joinTokenListChange = ((UpdateItem)((Object)joinTokenListChange)).parentItem;
                }
                assert (joinTokenListChange != null) : "No valid tokenListChange";
                ((UpdateItem)((Object)joinTokenListChange)).tokenListChange.tokenChangeInfo().addEmbeddedChange(this.tokenListChange.tokenChangeInfo());
            }
        }

        Set<Language<?>> processBoundsChange(TokenListChange<T> tokenListChange) {
            Set<Language<?>> set = this.childrenLanguages;
            boolean bl = true;
            EmbeddingContainer<T> embeddingContainer = tokenListChange.tokenChangeInfo().removedTokenList().tokenOrEmbedding(0).embedding();
            if (embeddingContainer != null) {
                embeddingContainer.reinit(tokenListChange.addedTokenOrEmbeddings().get(0).token());
                embeddingContainer.updateStatusUnsync();
                tokenListChange.tokenList().wrapToken(tokenListChange.index(), embeddingContainer);
                EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList();
                if (embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING) {
                    TokenHierarchyEventInfo tokenHierarchyEventInfo = this.update.eventInfo;
                    int n = tokenHierarchyEventInfo.modOffset() - tokenListChange.offset();
                    int n2 = tokenListChange.addedEndOffset() - (tokenHierarchyEventInfo.modOffset() + tokenHierarchyEventInfo.diffLengthOrZero());
                    EmbeddedTokenList<?> embeddedTokenList2 = null;
                    do {
                        if (this.processBoundsChangeEmbeddedTokenList(embeddedTokenList, n, n2)) {
                            Language<?> language;
                            if (set != null && set.contains(language = embeddedTokenList.languagePath().innerLanguage())) {
                                if (set.size() == 1) {
                                    set = null;
                                } else {
                                    if (bl) {
                                        bl = false;
                                        set = new HashSet(set);
                                    }
                                    set.remove(language);
                                }
                            }
                            embeddedTokenList2 = embeddedTokenList;
                            embeddedTokenList = embeddedTokenList2.nextEmbeddedTokenList();
                            continue;
                        }
                        embeddedTokenList = embeddingContainer.removeEmbeddedTokenList(embeddedTokenList2, embeddedTokenList);
                    } while (embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING);
                    return set;
                }
            }
            return this.childrenLanguages;
        }

        private <ET extends TokenId> boolean processBoundsChangeEmbeddedTokenList(EmbeddedTokenList<ET> embeddedTokenList, int n, int n2) {
            UpdateItem<ET> updateItem;
            UpdateItem<ET> updateItem2 = updateItem = this.childrenLanguages.size() > 0 ? this.update.tokenListListItem(embeddedTokenList.languagePath()) : null;
            if (n >= embeddedTokenList.embedding().startSkipLength() && n2 >= embeddedTokenList.embedding().endSkipLength()) {
                if (updateItem == null) {
                    updateItem = new UpdateItem<ET>(this.update, null, Collections.<Language<?>>emptySet());
                    int n3 = embeddedTokenList.languagePath().size() - 1;
                    this.update.addItem(updateItem, n3);
                } else {
                    updateItem.tokenListListUpdate.markChangedMember(embeddedTokenList);
                }
                updateItem.setParentItem(this);
                updateItem.initTokenListChange(embeddedTokenList);
                return true;
            }
            if (updateItem != null) {
                updateItem.tokenListListUpdate.markRemovedMember(embeddedTokenList, this.update.eventInfo);
            }
            return false;
        }

        void collectRemovedEmbeddings(TokenListChange<?> tokenListChange) {
            RemovedTokenList<?> removedTokenList = tokenListChange.tokenChangeInfo().removedTokenList();
            if (removedTokenList != null) {
                this.collectRemovedEmbeddings(removedTokenList);
            }
        }

        void collectRemovedEmbeddings(TokenList<?> tokenList) {
            int n = tokenList.tokenCountCurrent();
            for (int i = 0; i < n; ++i) {
                EmbeddingContainer<?> embeddingContainer = tokenList.tokenOrEmbedding(i).embedding();
                if (embeddingContainer == null) continue;
                embeddingContainer.updateStatusUnsync();
                for (EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                    this.internalMarkRemovedMember(embeddedTokenList);
                }
            }
        }

        void collectAddedEmbeddings(TokenListChange<?> tokenListChange) {
            this.collectAddedEmbeddings(tokenListChange, this.childrenLanguages);
        }

        void collectAddedEmbeddings(TokenListChange<?> tokenListChange, Set<Language<?>> set) {
            MutableTokenList<?> mutableTokenList = tokenListChange.tokenList();
            this.collectAddedEmbeddings(mutableTokenList, tokenListChange.index(), tokenListChange.addedTokenOrEmbeddingsCount(), set);
        }

        void collectAddedEmbeddings(TokenList<?> tokenList, int n, int n2, Set<Language<?>> set) {
            for (int i = 0; i < n2; ++i) {
                for (EmbeddedTokenList<Object> embeddedTokenList = EmbeddingContainer.embeddedTokenList(tokenList, n + i, set, false); embeddedTokenList != null; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                    this.internalMarkAddedMember(embeddedTokenList);
                }
            }
        }

        private <ET extends TokenId> void internalMarkRemovedMember(EmbeddedTokenList<ET> embeddedTokenList) {
            UpdateItem updateItem = this.update.tokenListListItem(embeddedTokenList.languagePath());
            if (updateItem != null) {
                updateItem.tokenListListUpdate.markRemovedMember(embeddedTokenList, this.update.eventInfo);
                if (updateItem.parentItem == null) {
                    updateItem.setParentItem(this);
                }
            }
        }

        private <ET extends TokenId> void internalMarkAddedMember(EmbeddedTokenList<ET> embeddedTokenList) {
            UpdateItem updateItem = this.update.tokenListListItem(embeddedTokenList.languagePath());
            if (updateItem != null) {
                updateItem.tokenListListUpdate.markAddedMember(embeddedTokenList);
                if (updateItem.parentItem == null) {
                    updateItem.setParentItem(this);
                }
            }
        }
    }
}

