/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.support.AbstractObjectFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDObjectFactory
extends AbstractObjectFactory {
    private static UIDObjectFactory theFactory;
    private static final int FIRST_INDEX = 14;
    private static final int UID_PROJECT_UID = 14;
    private static final int UID_NAMESPACE_UID = 15;
    private static final int UID_FILE_UID = 16;
    private static final int UID_TYPEDEF_UID = 17;
    private static final int UID_CLASSIFIER_UID = 18;
    private static final int UID_UNNAMED_CLASSIFIER_UID = 19;
    private static final int UID_MACRO_UID = 20;
    private static final int UID_INCLUDE_UID = 21;
    private static final int UID_PARAM_LIST_UID = 22;
    private static final int UID_UNNAMED_OFFSETABLE_DECLARATION_UID = 23;
    private static final int UID_DECLARATION_UID = 24;
    private static final int UID_BUILT_IN_UID = 25;
    private static final int UID_INSTANTIATION_UID = 26;
    private static final int UID_UNRESOLVED_CLASS = 27;
    private static final int UID_UNRESOLVED_FILE = 28;
    private static final int UID_UNRESOLVED_NAMESPACE = 29;
    public static final int LAST_INDEX = 29;

    protected UIDObjectFactory() {
    }

    public static synchronized UIDObjectFactory getDefaultFactory() {
        if (theFactory == null) {
            theFactory = new UIDObjectFactory();
        }
        return theFactory;
    }

    public void writeUID(CsmUID<?> csmUID, DataOutput dataOutput) throws IOException {
        if (csmUID != null && !(csmUID instanceof SelfPersistent)) assert (false) : csmUID + ", " + csmUID.getObject();
        super.writeSelfPersistent((SelfPersistent)csmUID, dataOutput);
    }

    public <T> CsmUID<T> readUID(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        SelfPersistent selfPersistent = super.readSelfPersistent(dataInput);
        assert (selfPersistent == null || selfPersistent instanceof CsmUID);
        return (CsmUID)selfPersistent;
    }

    public <T> void writeUIDCollection(Collection<CsmUID<T>> collection, DataOutput dataOutput, boolean bl) throws IOException {
        assert (dataOutput != null);
        if (collection == null) {
            dataOutput.writeInt(-1);
        } else {
            collection = bl ? UIDObjectFactory.copySyncCollection(collection) : collection;
            int n = collection.size();
            dataOutput.writeInt(n);
            for (CsmUID<T> csmUID : collection) {
                assert (csmUID != null);
                this.writeUID(csmUID, dataOutput);
            }
        }
    }

    public <A, T extends Collection<CsmUID<A>>> T readUIDCollection(T t, DataInput dataInput) throws IOException {
        assert (t != null);
        assert (dataInput != null);
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            CsmUID<T> csmUID = this.readUID(dataInput);
            assert (csmUID != null);
            t.add(csmUID);
        }
        return t;
    }

    public <T> void writeStringToUIDMap(Map<CharSequence, CsmUID<T>> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<CharSequence, CsmUID<T>> entry : map.entrySet()) {
            CharSequence charSequence = entry.getKey();
            assert (charSequence != null);
            PersistentUtils.writeUTF(charSequence, dataOutput);
            CsmUID<T> csmUID = entry.getValue();
            assert (csmUID != null);
            this.writeUID(csmUID, dataOutput);
        }
    }

    public <T> void writeOffsetSortedToUIDMap(Map<FileImpl.OffsetSortedKey, CsmUID<T>> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<FileImpl.OffsetSortedKey, CsmUID<T>> entry : map.entrySet()) {
            entry.getKey().write(dataOutput);
            CsmUID<T> csmUID = entry.getValue();
            assert (csmUID != null);
            this.writeUID(csmUID, dataOutput);
        }
    }

    public <T> void writeNameSortedToUIDMap(Map<FileImpl.NameSortedKey, CsmUID<T>> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<FileImpl.NameSortedKey, CsmUID<T>> entry : map.entrySet()) {
            entry.getKey().write(dataOutput);
            CsmUID<T> csmUID = entry.getValue();
            assert (csmUID != null);
            this.writeUID(csmUID, dataOutput);
        }
    }

    public void writeStringToArrayUIDMap(Map<CharSequence, Object> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<CharSequence, Object> entry : map.entrySet()) {
            CharSequence charSequence = entry.getKey();
            assert (charSequence != null);
            PersistentUtils.writeUTF(charSequence, dataOutput);
            Object object = entry.getValue();
            if (object instanceof CsmUID) {
                dataOutput.writeInt(1);
                this.writeUID((CsmUID)object, dataOutput);
                continue;
            }
            CsmUID[] csmUIDArray = (CsmUID[])object;
            dataOutput.writeInt(csmUIDArray.length);
            for (CsmUID csmUID : csmUIDArray) {
                assert (csmUID != null);
                this.writeUID(csmUID, dataOutput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Collection<CsmUID<T>> copySyncCollection(Collection<CsmUID<T>> collection) {
        ArrayList<CsmUID<T>> arrayList;
        Collection<CsmUID<T>> collection2 = collection;
        synchronized (collection2) {
            arrayList = new ArrayList<CsmUID<T>>(collection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Map<K, V> copySyncMap(Map<K, V> map) {
        HashMap<K, V> hashMap;
        Map<K, V> map2 = map;
        synchronized (map2) {
            hashMap = new HashMap<K, V>(map);
        }
        return hashMap;
    }

    public <T> void readStringToUIDMap(Map<CharSequence, CsmUID<T>> map, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (map != null);
        assert (dataInput != null);
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence = PersistentUtils.readUTF(dataInput, aPTStringManager);
            assert (charSequence != null);
            CsmUID<T> csmUID = this.readUID(dataInput);
            assert (csmUID != null);
            map.put(charSequence, csmUID);
        }
    }

    public <T> void readOffsetSortedToUIDMap(Map<FileImpl.OffsetSortedKey, CsmUID<T>> map, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (map != null);
        assert (dataInput != null);
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            FileImpl.OffsetSortedKey offsetSortedKey = new FileImpl.OffsetSortedKey(dataInput);
            assert (offsetSortedKey != null);
            CsmUID<T> csmUID = this.readUID(dataInput);
            assert (csmUID != null);
            map.put(offsetSortedKey, csmUID);
        }
    }

    public <T> void readNameSortedToUIDMap(Map<FileImpl.NameSortedKey, CsmUID<T>> map, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (map != null);
        assert (dataInput != null);
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            FileImpl.NameSortedKey nameSortedKey = new FileImpl.NameSortedKey(dataInput);
            assert (nameSortedKey != null);
            CsmUID<T> csmUID = this.readUID(dataInput);
            assert (csmUID != null);
            map.put(nameSortedKey, csmUID);
        }
    }

    public void readStringToArrayUIDMap(Map<CharSequence, Object> map, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (map != null);
        assert (dataInput != null);
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            CsmUID csmUID;
            CharSequence charSequence = PersistentUtils.readUTF(dataInput, aPTStringManager);
            assert (charSequence != null);
            int n2 = dataInput.readInt();
            if (n2 == 1) {
                csmUID = this.readUID(dataInput);
                assert (csmUID != null);
                map.put(charSequence, csmUID);
                continue;
            }
            csmUID = new CsmUID[n2];
            for (int j = 0; j < n2; ++j) {
                CsmUID csmUID2 = this.readUID(dataInput);
                assert (csmUID2 != null);
                csmUID[j] = csmUID2;
            }
            map.put(charSequence, csmUID);
        }
    }

    protected int getHandler(Object object) {
        int n;
        if (object instanceof UIDUtilities.ProjectUID) {
            n = 14;
        } else if (object instanceof UIDUtilities.NamespaceUID) {
            n = 15;
        } else if (object instanceof UIDUtilities.FileUID) {
            n = 16;
        } else if (object instanceof UIDUtilities.TypedefUID) {
            n = 17;
        } else if (object instanceof UIDUtilities.ClassifierUID) {
            n = 18;
        } else if (object instanceof UIDUtilities.UnnamedClassifierUID) {
            n = 19;
        } else if (object instanceof UIDUtilities.MacroUID) {
            n = 20;
        } else if (object instanceof UIDUtilities.IncludeUID) {
            n = 21;
        } else if (object instanceof UIDUtilities.ParamListUID) {
            n = 22;
        } else if (object instanceof UIDUtilities.UnnamedOffsetableDeclarationUID) {
            n = 23;
        } else if (object instanceof UIDUtilities.DeclarationUID) {
            n = 24;
        } else if (object instanceof BuiltinTypes.BuiltInUID) {
            n = 25;
        } else if (object instanceof Instantiation.InstantiationUID) {
            n = 26;
        } else if (object instanceof UIDUtilities.UnresolvedClassUID) {
            n = 27;
        } else if (object instanceof UIDUtilities.UnresolvedFileUID) {
            n = 28;
        } else if (object instanceof UIDUtilities.UnresolvedNamespaceUID) {
            n = 29;
        } else {
            throw new IllegalArgumentException("The UID is an instance of unknow class");
        }
        return n;
    }

    protected SelfPersistent createObject(int n, DataInput dataInput) throws IOException {
        Object object;
        boolean bl = false;
        switch (n) {
            case 14: {
                bl = true;
                object = new UIDUtilities.ProjectUID(dataInput);
                break;
            }
            case 15: {
                bl = true;
                object = new UIDUtilities.NamespaceUID(dataInput);
                break;
            }
            case 16: {
                bl = true;
                object = new UIDUtilities.FileUID(dataInput);
                break;
            }
            case 17: {
                object = new UIDUtilities.TypedefUID(dataInput);
                break;
            }
            case 18: {
                object = new UIDUtilities.ClassifierUID(dataInput);
                break;
            }
            case 19: {
                object = new UIDUtilities.UnnamedClassifierUID(dataInput);
                break;
            }
            case 20: {
                bl = true;
                object = new UIDUtilities.MacroUID(dataInput);
                break;
            }
            case 21: {
                bl = true;
                object = new UIDUtilities.IncludeUID(dataInput);
                break;
            }
            case 22: {
                object = new UIDUtilities.ParamListUID(dataInput);
                break;
            }
            case 23: {
                object = new UIDUtilities.UnnamedOffsetableDeclarationUID(dataInput);
                break;
            }
            case 24: {
                object = new UIDUtilities.DeclarationUID(dataInput);
                break;
            }
            case 25: {
                object = BuiltinTypes.readUID(dataInput);
                bl = false;
                break;
            }
            case 26: {
                object = new Instantiation.InstantiationUID(dataInput);
                bl = false;
                break;
            }
            case 27: {
                object = new UIDUtilities.UnresolvedClassUID(dataInput);
                break;
            }
            case 28: {
                object = new UIDUtilities.UnresolvedFileUID(dataInput);
                break;
            }
            case 29: {
                object = new UIDUtilities.UnresolvedNamespaceUID(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("The UID is an instance of unknown class: " + n);
            }
        }
        if (bl) {
            assert (object != null);
            assert (object instanceof CsmUID);
            CsmUID csmUID = UIDManager.instance().getSharedUID(object);
            assert (csmUID != null);
            assert (csmUID instanceof SelfPersistent);
            object = (SelfPersistent)csmUID;
        }
        return object;
    }
}

