/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XRefResultSet<T> {
    private final Map<ContextScope, Collection<ContextEntry>> scopeEntries;
    private final Map<ContextScope, AtomicInteger> scopes;
    private final ConcurrentMap<CharSequence, T> unresolved;
    private final AtomicInteger lineCounter = new AtomicInteger(0);
    private long time = 0L;

    public static Collection<ContextScope> sortedContextScopes(XRefResultSet xRefResultSet, boolean bl) {
        ArrayList<ContextScope> arrayList = new ArrayList<ContextScope>(ContextScope.values().length);
        for (ContextScope contextScope : ContextScope.values()) {
            boolean bl2 = false;
            int n = bl ? xRefResultSet.getEntries(contextScope).size() : xRefResultSet.getNumberOfContexts(contextScope, false);
            for (int i = 0; i < arrayList.size(); ++i) {
                ContextScope contextScope2 = (ContextScope)((Object)arrayList.get(i));
                int n2 = bl ? xRefResultSet.getEntries(contextScope2).size() : xRefResultSet.getNumberOfContexts(contextScope2, false);
                if (n2 > n) continue;
                arrayList.add(i, contextScope);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            arrayList.add(contextScope);
        }
        return arrayList;
    }

    public XRefResultSet() {
        this.scopeEntries = new HashMap<ContextScope, Collection<ContextEntry>>(ContextScope.values().length);
        this.scopes = new HashMap<ContextScope, AtomicInteger>(ContextScope.values().length);
        this.unresolved = new ConcurrentHashMap<CharSequence, T>(100);
        for (ContextScope contextScope : ContextScope.values()) {
            this.scopeEntries.put(contextScope, Collections.synchronizedList(new ArrayList(1024)));
            this.scopes.put(contextScope, new AtomicInteger(0));
        }
    }

    public final void addEntry(ContextScope contextScope, ContextEntry contextEntry) {
        this.scopeEntries.get((Object)contextScope).add(contextEntry);
    }

    public final Collection<ContextEntry> getEntries(ContextScope contextScope) {
        return this.scopeEntries.get((Object)contextScope);
    }

    public final void incrementScopeCounter(ContextScope contextScope) {
        this.scopes.get((Object)contextScope).incrementAndGet();
    }

    public final void incrementLineCounter(int n) {
        this.lineCounter.addAndGet(n);
    }

    public final int getLineCount() {
        return this.lineCounter.get();
    }

    public final int getNumberOfAllContexts() {
        int n = 0;
        for (AtomicInteger atomicInteger : this.scopes.values()) {
            n += atomicInteger.get();
        }
        return n;
    }

    public final int getNumberOfContexts(ContextScope contextScope, boolean bl) {
        int n = this.scopes.get((Object)contextScope).get();
        if (bl && n != 0) {
            assert (n > 0);
            n = n * 100 / this.getNumberOfAllContexts();
        }
        return n;
    }

    public T getUnresolvedEntry(CharSequence charSequence) {
        return (T)this.unresolved.get(charSequence);
    }

    public T addUnresolvedEntry(CharSequence charSequence, T t) {
        T t2 = this.unresolved.putIfAbsent(charSequence, t);
        return t2 == null ? t : t2;
    }

    public Collection<T> getUnresolvedEntries(Comparator<? super T> comparator) {
        ArrayList arrayList = new ArrayList(this.unresolved.values());
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final long getTime() {
        return this.time;
    }

    public final double getTimeMs() {
        return (double)this.time / 1000000.0;
    }

    public final double getTimeSec() {
        return (double)this.time / 1.0E9;
    }

    public final double getLinesPerSec() {
        return this.time == 0L ? 0.0 : (double)this.getLineCount() / this.getTimeSec();
    }

    public static final class ContextEntry {
        public final DeclarationKind declaration;
        public final DeclarationScope declarationScope;
        public final IncludeLevel declarationIncludeLevel;
        public final UsageStatistics usageStatistics;
        public static final ContextEntry UNRESOLVED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_AFTER_UNRESOLVED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_TEMPLATE_BASED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_MACRO_BASED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_BUILTIN_BASED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry RESOLVED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);

        public ContextEntry(DeclarationKind declarationKind, DeclarationScope declarationScope, IncludeLevel includeLevel, UsageStatistics usageStatistics) {
            this.declaration = declarationKind;
            this.declarationScope = declarationScope;
            this.declarationIncludeLevel = includeLevel;
            this.usageStatistics = usageStatistics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UsageStatistics {
        FIRST_USAGE,
        SECOND_USAGE,
        NEXT_USAGE,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncludeLevel {
        THIS_FILE,
        PROJECT_DIRECT,
        LIBRARY_DIRECT,
        PROJECT_DEEP,
        LIBRARY_DEEP,
        UNRESOLVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeclarationScope {
        FUNCTION_THIS,
        CLASSIFIER_THIS,
        CLASSIFIER_PARENT,
        PROJECT_CLASSIFIER,
        LIBRARY_CLASSIFIER,
        NAMESPACE_THIS,
        NAMESPACE_PARENT,
        PROJECT_NAMESPACE,
        LIBRARY_NAMESPACE,
        FILE_THIS,
        PROJECT_FILE,
        LIBRARY_FILE,
        PROJECT_GLOBAL,
        LIBRARY_GLOBAL,
        UNRESOLVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeclarationKind {
        CLASSIFIER,
        ENUMERATOR,
        VARIABLE,
        PARAMETER,
        FUNCTION,
        NAMESPACE,
        CLASS_FORWARD,
        MACRO,
        UNRESOLVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextScope {
        GLOBAL_FUNCTION,
        NAMESPACE_FUNCTION,
        FILE_LOCAL_FUNCTION,
        METHOD,
        CONSTRUCTOR,
        INLINED_METHOD,
        INLINED_CONSTRUCTOR,
        UNRESOLVED;

    }
}

