/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceRepositoryImpl
extends CsmReferenceRepository {
    private static final boolean checkFileAttainability = false;

    public Collection<CsmReference> getReferences(CsmObject csmObject, CsmProject csmProject, Set<CsmReferenceKind> set, CsmReferenceRepository.Interrupter interrupter) {
        ArrayList<CsmReference> arrayList;
        CsmFile csmFile;
        if (!(csmProject instanceof ProjectBase)) {
            return Collections.emptyList();
        }
        ProjectBase projectBase = (ProjectBase)csmProject;
        boolean bl = true;
        CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject, (boolean)bl);
        CsmObject csmObject2 = csmObjectArray[0];
        CsmObject csmObject3 = csmObjectArray[1];
        CsmScope csmScope = this.getDeclarationScope(csmObject2);
        CsmFile csmFile2 = csmFile = CsmKindUtilities.isOffsetable((Object)csmScope) ? ((CsmOffsetable)csmScope).getContainingFile() : null;
        if (csmFile instanceof FileImpl) {
            arrayList = new ArrayList<CsmReference>(10);
            CsmOffsetable csmOffsetable = (CsmOffsetable)csmScope;
            arrayList.addAll(this.getReferences(csmObject2, csmObject3, (FileImpl)csmFile, set, bl, csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset(), interrupter));
        } else {
            Collection<FileImpl> collection = projectBase.getAllFileImpls();
            arrayList = new ArrayList(collection.size() * 10);
            for (FileImpl fileImpl : collection) {
                if (interrupter != null && interrupter.cancelled()) break;
                arrayList.addAll(this.getReferences(csmObject2, csmObject3, fileImpl, set, bl, 0, Integer.MAX_VALUE, interrupter));
            }
        }
        return arrayList;
    }

    public Collection<CsmReference> getReferences(CsmObject csmObject, CsmFile csmFile, Set<CsmReferenceKind> set, CsmReferenceRepository.Interrupter interrupter) {
        CsmFile csmFile2;
        CsmScope csmScope = this.getDeclarationScope(csmObject);
        CsmFile csmFile3 = csmFile2 = CsmKindUtilities.isOffsetable((Object)csmScope) ? ((CsmOffsetable)csmScope).getContainingFile() : null;
        if (!(csmFile instanceof FileImpl)) {
            return Collections.emptyList();
        }
        if (csmFile2 != null && !csmFile2.equals(csmFile)) {
            return Collections.emptyList();
        }
        boolean bl = true;
        CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject, (boolean)bl);
        CsmObject csmObject2 = csmObjectArray[0];
        CsmObject csmObject3 = csmObjectArray[1];
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        if (CsmKindUtilities.isOffsetable((Object)csmScope)) {
            n = ((CsmOffsetable)csmScope).getStartOffset();
            n2 = ((CsmOffsetable)csmScope).getEndOffset();
        }
        return this.getReferences(csmObject2, csmObject3, (FileImpl)csmFile, set, bl, n, n2, interrupter);
    }

    public Map<CsmObject, Collection<CsmReference>> getReferences(CsmObject[] csmObjectArray, CsmProject csmProject, Set<CsmReferenceKind> set, CsmReferenceRepository.Interrupter interrupter) {
        HashMap<CsmObject, Collection<CsmReference>> hashMap = new HashMap<CsmObject, Collection<CsmReference>>(csmObjectArray.length);
        for (CsmObject csmObject : csmObjectArray) {
            if (interrupter != null && interrupter.cancelled()) break;
            hashMap.put(csmObject, this.getReferences(csmObject, csmProject, set, interrupter));
        }
        return hashMap;
    }

    public Collection<CsmReference> getReferences(CsmObject[] csmObjectArray, CsmFile csmFile, Set<CsmReferenceKind> set, CsmReferenceRepository.Interrupter interrupter) {
        AbstractCollection object = new LinkedHashSet<CsmReference>(1024);
        for (CsmObject csmObject : csmObjectArray) {
            object.addAll(this.getReferences(csmObject, csmFile, set, interrupter));
        }
        if (!object.isEmpty() && csmObjectArray.length > 1) {
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>(object);
            Collections.sort(arrayList, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference csmReference, CsmReference csmReference2) {
                    return csmReference.getStartOffset() - csmReference2.getStartOffset();
                }
            });
            object = arrayList;
        }
        return object;
    }

    private Collection<CsmReference> getReferences(final CsmObject csmObject, final CsmObject csmObject2, FileImpl fileImpl, final Set<CsmReferenceKind> set, final boolean bl, int n, int n2, final CsmReferenceRepository.Interrupter interrupter) {
        Object object2;
        assert (csmObject != null);
        assert (fileImpl != null);
        CharSequence charSequence = "";
        if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
            charSequence = ((CsmNamedElement)csmObject).getName();
        } else if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
            if (csmObject instanceof CsmLabel) {
                charSequence = ((CsmLabel)csmObject).getLabel();
            } else if (csmObject instanceof CsmGotoStatement) {
                charSequence = ((CsmGotoStatement)csmObject).getLabel();
            }
        }
        if (charSequence.length() == 0) {
            if (TraceFlags.TRACE_XREF_REPOSITORY) {
                System.err.println("resolving unnamed element is not yet supported " + csmObject);
            }
            return Collections.emptyList();
        }
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        if (TraceFlags.TRACE_XREF_REPOSITORY) {
            System.err.println("resolving " + charSequence + " in file " + fileImpl.getAbsolutePath());
        }
        if (!this.fastDetect(csmObject, csmObject2, fileImpl, charSequence)) {
            return Collections.emptyList();
        }
        Collection<APTToken> collection = this.getTokensToResolve(fileImpl, charSequence, n, n2);
        if (TraceFlags.TRACE_XREF_REPOSITORY) {
            System.err.println("collecting tokens");
        }
        ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>(20);
        for (Object object2 : collection) {
            if (interrupter != null && interrupter.cancelled()) break;
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference((CsmFile)fileImpl, object2.getOffset());
            if (csmReference == null) continue;
            arrayList.add(csmReference);
        }
        final ArrayList arrayList2 = new ArrayList(20);
        object2 = new CsmFileReferences.ReferenceVisitor(){

            public void visit(CsmReference csmReference) {
                if (interrupter != null && interrupter.cancelled()) {
                    return;
                }
                if (ReferenceRepositoryImpl.this.acceptReference(csmReference, csmObject, csmObject2, set, bl)) {
                    arrayList2.add(csmReference);
                }
            }
        };
        CsmFileReferences.getDefault().visit(arrayList, (CsmFileReferences.ReferenceVisitor)object2);
        return arrayList2;
    }

    private boolean fastDetect(CsmObject csmObject, CsmObject csmObject2, FileImpl fileImpl, CharSequence charSequence) {
        return charSequence.length() != 0 && this.hasName(fileImpl, charSequence);
    }

    private boolean hasName(FileImpl fileImpl, CharSequence charSequence) {
        try {
            if (fileImpl.isValid()) {
                FileBuffer fileBuffer = fileImpl.getBuffer();
                if (fileBuffer == null) {
                    return false;
                }
                String string = fileBuffer.getText();
                return string.indexOf(((Object)charSequence).toString()) >= 0;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    private Collection<APTToken> getTokensToResolve(FileImpl fileImpl, CharSequence charSequence, int n, int n2) {
        TokenStream tokenStream = this.getTokenStream(fileImpl);
        ArrayList<APTToken> arrayList = new ArrayList<APTToken>(100);
        boolean bl = false;
        if (charSequence.charAt(0) == '~') {
            bl = true;
            charSequence = charSequence.subSequence(1, charSequence.length());
        }
        if (tokenStream != null) {
            try {
                APTToken aPTToken = (APTToken)tokenStream.nextToken();
                APTToken aPTToken2 = null;
                while (!APTUtils.isEOF((Token)aPTToken)) {
                    int n3;
                    if (aPTToken.getOffset() >= n && ((n3 = aPTToken.getType()) == 205 || n3 == 235) && charSequence.equals(aPTToken.getTextID()) && (!bl || aPTToken2 != null && aPTToken2.getType() == 171)) {
                        arrayList.add(aPTToken);
                    }
                    if (aPTToken.getEndOffset() <= n2) {
                        aPTToken2 = aPTToken;
                        aPTToken = (APTToken)tokenStream.nextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (TokenStreamException tokenStreamException) {
                APTUtils.LOG.log(Level.SEVERE, tokenStreamException.getMessage());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private TokenStream getTokenStream(FileImpl var1_1) {
        block13: {
            var2_2 = null;
            var3_3 = null;
            try {
                block12: {
                    if (!var1_1.isValid() || (var4_4 = var1_1.getBuffer()) == null) break block12;
                    var2_2 = var4_4.getReader();
                    var3_3 = APTTokenStreamBuilder.buildTokenStream((CharSequence)var1_1.getAbsolutePath(), (Reader)var2_2);
                }
                var6_6 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var5_12) {
                var6_8 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var7_11) {
                        DiagnosticExceptoins.register(var7_11);
                    }
                }
                throw var5_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (IOException var7_9) {
                    DiagnosticExceptoins.register(var7_9);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (IOException var4_5) {
                    DiagnosticExceptoins.register(var4_5);
                    var3_3 = null;
                    var6_7 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var7_10) {
                            DiagnosticExceptoins.register(var7_10);
                        }
                    }
                }
            }
        }
        if (var3_3 == null || !var1_1.isValid()) {
            return null;
        }
        var4_4 = var1_1.getProjectImpl(false).getPreprocState(var1_1);
        return var1_1.getLanguageFilter((APTPreprocHandler.State)var4_4).getFilteredStream((TokenStream)new APTCommentsFilter(var3_3));
    }

    private boolean acceptReference(CsmReference csmReference, CsmObject csmObject, CsmObject csmObject2, Set<CsmReferenceKind> set, boolean bl) {
        CsmObject csmObject3;
        assert (csmObject != null);
        boolean bl2 = false;
        CsmObject csmObject4 = csmObject3 = csmReference == null ? null : csmReference.getReferencedObject();
        if (bl && CsmKindUtilities.isTemplateInstantiation((CsmObject)csmObject3)) {
            csmObject3 = ((CsmInstantiation)csmObject3).getTemplateDeclaration();
        }
        if (csmObject.equals(csmObject3) || csmObject2 != null && csmObject2.equals(csmObject3)) {
            bl2 = CsmReferenceResolver.getDefault().isKindOf(csmReference, set);
        }
        return bl2;
    }

    private CsmScope getDeclarationScope(CsmObject csmObject) {
        assert (csmObject != null);
        CsmObject csmObject2 = csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
                return (CsmFunction)csmScope;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)csmScope)) break;
            csmObject2 = (CsmScopeElement)csmScope;
        }
        return null;
    }
}

