/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public abstract class StatementBase
extends OffsetableBase
implements CsmStatement {
    private final AST ast;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;

    public StatementBase(AST aST, CsmFile csmFile, CsmScope csmScope) {
        super(aST, csmFile);
        this.ast = aST;
        if (csmScope != null) {
            this.setScope(csmScope);
        }
    }

    public CsmScope getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return csmScope;
    }

    protected void setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    protected AST getAst() {
        return this.ast;
    }

    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    protected StatementBase(DataInput dataInput) throws IOException {
        super(dataInput);
        this.ast = null;
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }

    public String toString() {
        return "" + this.getKind() + ' ' + this.getOffsetString();
    }

    private void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null) : "no object for UID " + this.scopeUID;
        }
    }
}

