/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import antlr.TokenStream;
import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyStatementImpl
extends StatementBase
implements CsmScope {
    private SoftReference<List<CsmStatement>> statements = null;

    public LazyStatementImpl(AST aST, CsmFile csmFile, CsmFunction csmFunction) {
        super(aST, csmFile, (CsmScope)csmFunction);
        aST.setFirstChild(null);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.COMPOUND;
    }

    public List<CsmStatement> getStatements() {
        if (this.statements == null) {
            return this.createStatements();
        }
        List<CsmStatement> list = this.statements.get();
        return list == null ? this.createStatements() : list;
    }

    public List<CsmStatement> createStatements() {
        ArrayList<CsmStatement> arrayList = new ArrayList<CsmStatement>();
        if (this.renderStatements(arrayList)) {
            this.statements = new SoftReference<ArrayList<CsmStatement>>(arrayList);
            return arrayList;
        }
        return Collections.emptyList();
    }

    private boolean renderStatements(List<CsmStatement> list) {
        FileImpl fileImpl = (FileImpl)this.getContainingFile();
        TokenStream tokenStream = fileImpl.getTokenStream(this.getStartOffset(), this.getEndOffset(), this.getFirstTokenID(), true);
        if (tokenStream == null) {
            Utils.LOG.severe("Can't create compound statement: can't create token stream for file " + fileImpl.getAbsolutePath());
            return false;
        }
        AST aST = this.resolveLazyStatement(tokenStream);
        this.renderStatements(aST, list);
        return true;
    }

    private void renderStatements(AST aST, List<CsmStatement> list) {
        AST aST2 = aST = aST == null ? null : aST.getFirstChild();
        while (aST != null) {
            StatementBase statementBase = AstRenderer.renderStatement(aST, this.getContainingFile(), this);
            if (statementBase != null) {
                list.add(statementBase);
            }
            aST = aST.getNextSibling();
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        List<CsmStatement> list = this.getStatements();
        return list;
    }

    protected abstract AST resolveLazyStatement(TokenStream var1);

    protected abstract int getFirstTokenID();

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
    }

    public LazyStatementImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.statements = null;
    }
}

