/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassifierContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private Map<CharSequence, CsmUID<CsmClassifier>> classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
    private Map<CharSequence, CsmUID<CsmClassifier>> typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
    private ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private static final ClassifierContainer EMPTY = new ClassifierContainer(){

        public boolean putClassifier(CsmClassifier csmClassifier) {
            return false;
        }

        public void put() {
        }
    };

    public static ClassifierContainer empty() {
        return EMPTY;
    }

    public ClassifierContainer(ProjectBase projectBase) {
        super(new ClassifierContainerKey(((Object)projectBase.getUniqueName()).toString()), false);
        this.put();
    }

    public ClassifierContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        this.read(dataInput);
    }

    private ClassifierContainer() {
        super(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getClassifier(CharSequence charSequence) {
        CsmUID<CsmClassifier> csmUID;
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            csmUID = this.classifiers.get(charSequence);
            if (csmUID == null) {
                csmUID = this.typedefs.get(charSequence);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        CsmClassifier csmClassifier = UIDCsmConverter.UIDtoDeclaration(csmUID);
        return csmClassifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CharSequence, CsmClassifier> getClassifiers() {
        TreeMap<CharSequence, CsmClassifier> treeMap = new TreeMap<CharSequence, CsmClassifier>();
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, CsmUID<CsmClassifier>> entry : this.classifiers.entrySet()) {
                treeMap.put(entry.getKey(), UIDCsmConverter.UIDtoDeclaration(entry.getValue()));
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CharSequence, CsmClassifier> getTypedefs() {
        TreeMap<CharSequence, CsmClassifier> treeMap = new TreeMap<CharSequence, CsmClassifier>();
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, CsmUID<CsmClassifier>> entry : this.typedefs.entrySet()) {
                treeMap.put(entry.getKey(), UIDCsmConverter.UIDtoDeclaration(entry.getValue()));
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putClassifier(CsmClassifier csmClassifier) {
        boolean bl = false;
        CharSequence charSequence = csmClassifier.getQualifiedName();
        try {
            this.declarationsLock.writeLock().lock();
            Map<CharSequence, CsmUID<CsmClassifier>> map = this.isTypedef((CsmDeclaration)csmClassifier) ? this.typedefs : this.classifiers;
            if (!map.containsKey(charSequence)) {
                CsmUID<CsmClassifier> csmUID = UIDCsmConverter.declarationToUID(csmClassifier);
                assert (csmUID != null);
                map.put(charSequence, csmUID);
                assert (UIDCsmConverter.UIDtoDeclaration(csmUID) != null);
                bl = true;
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        if (bl) {
            this.put();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassifier(CsmDeclaration csmDeclaration) {
        CsmUID<CsmClassifier> csmUID;
        try {
            this.declarationsLock.writeLock().lock();
            Map<CharSequence, CsmUID<CsmClassifier>> map = this.isTypedef(csmDeclaration) ? this.typedefs : this.classifiers;
            csmUID = map.remove(csmDeclaration.getQualifiedName());
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        assert (csmUID == null || UIDCsmConverter.UIDtoCsmObject(csmUID) != null) : " no object for UID " + csmUID;
        if (csmUID != null) {
            this.put();
        }
    }

    private boolean isTypedef(CsmDeclaration csmDeclaration) {
        return CsmKindUtilities.isTypedef((CsmObject)csmDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.classifiers, dataOutput, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.typedefs, dataOutput, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }

    private void read(DataInput dataInput) throws IOException {
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.classifiers, dataInput, QualifiedNameCache.getManager());
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.typedefs, dataInput, QualifiedNameCache.getManager());
    }
}

