/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PackageViewChildren
extends Children.Keys<String>
implements FileChangeListener,
ChangeListener,
Runnable {
    private static final String NODE_NOT_CREATED = "NNC";
    private static final String NODE_NOT_CREATED_EMPTY = "NNC_E";
    private static final MessageFormat PACKAGE_FLAVOR = new MessageFormat("application/x-java-org-netbeans-modules-java-project-packagenodednd; class=org.netbeans.spi.java.project.support.ui.PackageViewChildren$PackageNode; mask={0}");
    static final String PRIMARY_TYPE = "application";
    static final String SUBTYPE = "x-java-org-netbeans-modules-java-project-packagenodednd";
    static final String MASK = "mask";
    private Map<String, Object> names2nodes;
    private final FileObject root;
    private final SourceGroup group;
    private FileChangeListener wfcl;
    private ChangeListener wvqcl;
    RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);
    private RequestProcessor.Task refreshLazilyTask;
    private final DataFilter NO_FOLDERS_FILTER = new NoFoldersDataFilter();

    public PackageViewChildren(SourceGroup sourceGroup) {
        this.root = sourceGroup.getRootFolder();
        this.group = sourceGroup;
    }

    FileObject getRoot() {
        return this.root;
    }

    protected Node[] createNodes(String string) {
        FileObject fileObject = this.root.getFileObject(string);
        if (fileObject != null && fileObject.isValid()) {
            Object object = this.names2nodes.get(string);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            if (dataFolder.isValid()) {
                PackageNode packageNode = object == NODE_NOT_CREATED ? new PackageNode(this.root, dataFolder, false) : new PackageNode(this.root, dataFolder);
                this.names2nodes.put(string, (Object)packageNode);
                return new Node[]{packageNode};
            }
        }
        return new Node[0];
    }

    protected void addNotify() {
        super.addNotify();
        this.task.schedule(0);
    }

    public Node[] getNodes(boolean bl) {
        if (bl) {
            Node[] nodeArray = super.getNodes(false);
            this.task.waitFinished();
        }
        return super.getNodes(false);
    }

    public Node findChild(String string) {
        Node node;
        while ((node = super.findChild(string)) == null) {
            try {
                if (this.task.waitFinished(5000L)) {
                    return super.findChild(string);
                }
                this.refreshKeys();
                continue;
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
                continue;
            }
            break;
        }
        return node;
    }

    @Override
    public void run() {
        this.computeKeys();
        this.refreshKeys();
        try {
            FileSystem fileSystem = this.root.getFileSystem();
            this.wfcl = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileSystem);
            fileSystem.addFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        this.wvqcl = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
        VisibilityQuery.getDefault().addChangeListener(this.wvqcl);
    }

    protected void removeNotify() {
        VisibilityQuery.getDefault().removeChangeListener(this.wvqcl);
        try {
            this.root.getFileSystem().removeFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        this.setKeys(new String[0]);
        this.names2nodes.clear();
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshKeys() {
        TreeSet<String> treeSet;
        Map<String, Object> map = this.names2nodes;
        synchronized (map) {
            treeSet = new TreeSet<String>(this.names2nodes.keySet());
        }
        this.setKeys(treeSet);
    }

    private void refreshKeysAsync() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PackageViewChildren.this.refreshKeys();
            }
        });
    }

    private void computeKeys() {
        this.names2nodes = Collections.synchronizedMap(new TreeMap());
        this.findNonExcludedPackages(this.root);
    }

    private void findNonExcludedPackages(FileObject fileObject) {
        PackageView.findNonExcludedPackages(this, null, fileObject, this.group, true);
    }

    private void cleanEmptyKeys(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (this.root.equals(fileObject2)) {
            PackageNode packageNode = this.get(fileObject2);
            if (packageNode != null && PackageDisplayUtils.isEmpty(this.root, false)) {
                this.remove(this.root);
            }
            return;
        }
        while (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject2)) {
            PackageNode packageNode = this.get(fileObject2);
            if (packageNode != null && packageNode.isLeaf()) {
                this.remove(fileObject2);
            }
            fileObject2 = fileObject2.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(FileObject fileObject, boolean bl, boolean bl2) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Adding wrong folder " + fileObject + "(valid=" + fileObject.isValid() + ")" + "under root" + this.root + "(valid=" + this.root.isValid() + ")";
        if (this.get(fileObject) == null) {
            this.names2nodes.put(string, bl ? NODE_NOT_CREATED_EMPTY : NODE_NOT_CREATED);
            if (bl2) {
                this.refreshKeysAsync();
            } else {
                PackageViewChildren packageViewChildren = this;
                synchronized (packageViewChildren) {
                    if (this.refreshLazilyTask == null) {
                        this.refreshLazilyTask = RequestProcessor.getDefault().post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                PackageViewChildren packageViewChildren = PackageViewChildren.this;
                                synchronized (packageViewChildren) {
                                    PackageViewChildren.this.refreshLazilyTask = null;
                                    PackageViewChildren.this.refreshKeysAsync();
                                }
                            }
                        }, 2500);
                    }
                }
            }
        }
    }

    private void remove(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Removing wrong folder" + fileObject;
        this.names2nodes.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubTree(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Removing wrong folder" + fileObject;
        Map<String, Object> map = this.names2nodes;
        synchronized (map) {
            Set<String> set = this.names2nodes.keySet();
            set.remove(string);
            string = string + '/';
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().startsWith(string)) continue;
                iterator.remove();
            }
        }
    }

    private PackageNode get(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Asking for wrong folder" + fileObject;
        Object object = this.names2nodes.get(string);
        return !this.isNodeCreated(object) ? null : (PackageNode)((Object)object);
    }

    private boolean contains(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Asking for wrong folder" + fileObject;
        Object object = this.names2nodes.get(string);
        return object != null;
    }

    private boolean exists(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        return this.names2nodes.get(string) != null;
    }

    private boolean isNodeCreated(Object object) {
        return object instanceof Node;
    }

    private PackageNode updatePath(String string, String string2) {
        assert (string2 != null);
        Object object = this.names2nodes.get(string);
        if (object == null) {
            return null;
        }
        this.names2nodes.remove(string);
        this.names2nodes.put(string2, object);
        return !this.isNodeCreated(object) ? null : (PackageNode)((Object)object);
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && this.isVisible(this.root, fileObject)) {
            this.cleanEmptyKeys(fileObject);
            this.findNonExcludedPackages(fileObject);
            this.refreshKeys();
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && this.isVisible(this.root, fileObject)) {
            FileObject fileObject2 = fileObject.getParent();
            if (!VisibilityQuery.getDefault().isVisible(fileObject2)) {
                return;
            }
            PackageNode packageNode = this.get(fileObject2);
            if (packageNode == null && !this.contains(fileObject2)) {
                this.add(fileObject2, false, true);
                this.refreshKeysAsync();
            } else if (packageNode != null) {
                packageNode.updateChildren();
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && this.isVisible(this.root, fileObject)) {
            if (fileObject.isFolder() || this.get(fileObject) != null) {
                this.removeSubTree(fileObject);
                FileObject fileObject2 = fileObject.getParent();
                if ((FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject2) || this.root.equals(fileObject2)) && this.get(fileObject2) == null && fileObject2.isValid() && !this.toBeRemoved(fileObject2)) {
                    this.add(fileObject2, true, true);
                }
                this.refreshKeysAsync();
            } else {
                FileObject fileObject3 = fileObject.getParent();
                final PackageNode packageNode = this.get(fileObject3);
                if (packageNode != null) {
                    DataFolder dataFolder;
                    boolean bl;
                    boolean bl2 = packageNode.isLeaf();
                    if (bl2 != (bl = PackageViewChildren.isEmpty(dataFolder = packageNode.getDataFolder()))) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                packageNode.updateChildren();
                            }
                        });
                    } else {
                        packageNode.updateChildren();
                    }
                }
                if (this.toBeRemoved(fileObject3)) {
                    this.remove(fileObject3);
                    this.refreshKeysAsync();
                }
            }
        }
    }

    private boolean toBeRemoved(FileObject fileObject) {
        boolean bl = true;
        boolean bl2 = true;
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            bl = false;
            if (fileObject2.isFolder()) continue;
            bl2 = false;
            break;
        }
        if (bl) {
            return false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && fileObject.isFolder()) {
            Object object;
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject.getParent());
            String string2 = string + (string.length() == 0 ? "" : "/") + fileRenameEvent.getName() + fileRenameEvent.getExt();
            boolean bl = VisibilityQuery.getDefault().isVisible(fileObject);
            boolean bl2 = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            Map<String, Object> map = this.names2nodes;
            synchronized (map) {
                object = this.names2nodes.keySet().iterator();
                while (object.hasNext()) {
                    String string3 = object.next();
                    if (!string3.startsWith(string2)) continue;
                    if (bl) {
                        arrayList.add(string3);
                        continue;
                    }
                    object.remove();
                    bl2 = true;
                }
            }
            if (this.get(fileObject) == null && bl) {
                this.cleanEmptyKeys(fileObject);
                this.findNonExcludedPackages(fileObject);
                bl2 = true;
            }
            int n = string2.length();
            object = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            for (String string4 : arrayList) {
                StringBuilder stringBuilder = new StringBuilder(string4);
                stringBuilder.replace(0, n, (String)object);
                PackageNode packageNode = this.updatePath(string4, stringBuilder.toString());
                if (packageNode == null) continue;
                packageNode.updateDisplayName();
            }
            if (arrayList.size() > 1 || bl2) {
                this.refreshKeys();
            }
        }
    }

    private boolean isVisible(FileObject fileObject, FileObject fileObject2) {
        do {
            if (VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            return false;
        } while ((fileObject2 = fileObject2.getParent()) != null && fileObject2 != fileObject);
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.computeKeys();
        this.refreshKeys();
    }

    private static boolean isEmpty(DataFolder dataFolder) {
        if (dataFolder == null) {
            return true;
        }
        return PackageDisplayUtils.isEmpty(dataFolder.getPrimaryFile());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonRecursiveFolderSet
    extends HashSet<FileObject>
    implements NonRecursiveFolder {
        private final FileObject folder;

        public NonRecursiveFolderSet(FileObject fileObject) {
            this.folder = fileObject;
            this.add(fileObject);
        }

        public FileObject getFolder() {
            return this.folder;
        }
    }

    static class PackagePasteType
    extends PasteType {
        private int op;
        private PackageNode[] nodes;
        private FileObject srcRoot;

        public PackagePasteType(FileObject fileObject, PackageNode[] packageNodeArray, int n) {
            assert (n == 1 || n == 2 || n == 0) : "Invalid DnD operation";
            this.nodes = packageNodeArray;
            this.op = n;
            this.srcRoot = fileObject;
        }

        public void setOperation(int n) {
            this.op = n;
        }

        public Transferable paste() throws IOException {
            assert (this.op != 0);
            for (int i = 0; i < this.nodes.length; ++i) {
                Object object;
                Object object2;
                FileObject fileObject = this.srcRoot;
                if (!this.nodes[i].isDefaultPackage) {
                    object2 = this.nodes[i].getName();
                    object = new StringTokenizer((String)object2, ".");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string = ((StringTokenizer)object).nextToken();
                        FileObject fileObject2 = fileObject.getFileObject(string, null);
                        if (fileObject2 == null) {
                            fileObject2 = fileObject.createFolder(string);
                        }
                        fileObject = fileObject2;
                    }
                }
                object2 = DataFolder.findFolder((FileObject)fileObject);
                object = this.nodes[i].dataFolder.getChildren();
                boolean bl = false;
                for (int j = 0; j < ((Object)object).length; ++j) {
                    if (object[j].getPrimaryFile().isData() && VisibilityQuery.getDefault().isVisible(object[j].getPrimaryFile())) {
                        if (this.op == 2) {
                            object[j].move(object2);
                            continue;
                        }
                        object[j].copy(object2);
                        continue;
                    }
                    bl = true;
                }
                if (this.op != 2 || bl) continue;
                try {
                    FileObject fileObject3 = this.nodes[i].dataFolder.getPrimaryFile();
                    FileObject fileObject4 = this.nodes[i].root;
                    assert (fileObject3 != null && fileObject4 != null);
                    while (!fileObject3.equals(fileObject4) && fileObject3.getChildren().length == 0) {
                        FileObject fileObject5 = fileObject3.getParent();
                        fileObject3.delete();
                        fileObject3 = fileObject5;
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return ExTransferable.EMPTY;
        }

        public String getName() {
            return NbBundle.getMessage(PackageViewChildren.class, (String)"TXT_PastePackage");
        }
    }

    static class PackageTransferable
    extends ExTransferable.Single {
        private PackageNode node;

        public PackageTransferable(PackageNode packageNode, int n) throws ClassNotFoundException {
            super(new DataFlavor(PACKAGE_FLAVOR.format(new Object[]{new Integer(n)}), null, PackageNode.class.getClassLoader()));
            this.node = packageNode;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    final class NoFoldersDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public NoFoldersDataFilter() {
            VisibilityQuery.getDefault().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault()));
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return this.acceptFileObject(dataObject.getPrimaryFile());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public boolean acceptFileObject(FileObject fileObject) {
            return fileObject.isValid() && VisibilityQuery.getDefault().isVisible(fileObject) && fileObject.isData() && PackageViewChildren.this.group.contains(fileObject);
        }
    }

    private static final class NoFoldersContainer
    implements DataObject.Container,
    PropertyChangeListener,
    NonRecursiveFolder {
        private DataFolder folder;
        private PropertyChangeSupport prop = new PropertyChangeSupport(this);

        public NoFoldersContainer(DataFolder dataFolder) {
            this.folder = dataFolder;
        }

        public FileObject getFolder() {
            return this.folder.getPrimaryFile();
        }

        public DataObject[] getChildren() {
            DataObject[] dataObjectArray = this.folder.getChildren();
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (dataObjectArray[i] instanceof DataFolder) continue;
                arrayList.add(dataObjectArray[i]);
            }
            return arrayList.size() == dataObjectArray.length ? dataObjectArray : arrayList.toArray(new DataObject[0]);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop.removePropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("children".equals(propertyChangeEvent.getPropertyName())) {
                this.prop.firePropertyChange("children", null, null);
            }
        }
    }

    final class PackageNode
    extends FilterNode {
        private Action[] actions;
        private final FileObject root;
        private DataFolder dataFolder;
        private boolean isDefaultPackage;

        public PackageNode(FileObject fileObject, DataFolder dataFolder) {
            this(fileObject, dataFolder, PackageViewChildren.isEmpty(dataFolder));
        }

        public PackageNode(FileObject fileObject, DataFolder dataFolder, boolean bl) {
            super(dataFolder.getNodeDelegate(), bl ? FilterNode.Children.LEAF : dataFolder.createNodeChildren(PackageViewChildren.this.NO_FOLDERS_FILTER), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)new NoFoldersContainer(dataFolder)), dataFolder.getNodeDelegate().getLookup(), Lookups.singleton((Object)PackageRootNode.alwaysSearchableSearchInfo(SearchInfoFactory.createSearchInfo((FileObject)dataFolder.getPrimaryFile(), (boolean)false, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER})))}));
            this.root = fileObject;
            this.dataFolder = dataFolder;
            this.isDefaultPackage = fileObject.equals(dataFolder.getPrimaryFile());
        }

        FileObject getRoot() {
            return this.root;
        }

        public String getName() {
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.dataFolder.getPrimaryFile());
            return string == null ? null : string.replace('/', '.');
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                if (this.actions == null) {
                    Action[] actionArray = super.getActions(bl);
                    ArrayList<Action> arrayList = new ArrayList<Action>(actionArray.length);
                    for (int i = 0; i < actionArray.length; ++i) {
                        if (i <= actionArray.length - 2 && actionArray[i] == null && actionArray[i + 1] instanceof PropertiesAction) {
                            ++i;
                            continue;
                        }
                        if (actionArray[i] instanceof PropertiesAction) continue;
                        if (actionArray[i] instanceof FileSystemAction) {
                            arrayList.add(null);
                            arrayList.add(FileSensitiveActions.fileCommandAction((String)"compile.single", (String)NbBundle.getMessage(PackageViewChildren.class, (String)"LBL_CompilePackage_Action"), null));
                        }
                        arrayList.add(actionArray[i]);
                    }
                    this.actions = new Action[arrayList.size()];
                    arrayList.toArray(this.actions);
                }
                return this.actions;
            }
            return super.getActions(bl);
        }

        public boolean canRename() {
            return !this.isDefaultPackage;
        }

        public boolean canCut() {
            return !this.isDefaultPackage;
        }

        public Transferable clipboardCopy() throws IOException {
            try {
                return new PackageTransferable(this, 1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public Transferable clipboardCut() throws IOException {
            try {
                return new PackageTransferable(this, 2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public Transferable drag() throws IOException {
            try {
                return new PackageTransferable(this, 0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public PasteType[] getPasteTypes(Transferable transferable) {
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    boolean bl = false;
                    for (int i = 0; i < multiTransferObject.getCount(); ++i) {
                        DataFlavor[] dataFlavorArray = multiTransferObject.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(dataFlavorArray)) continue;
                        bl = true;
                    }
                    return bl ? new PasteType[]{} : super.getPasteTypes(transferable);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    ErrorManager.getDefault().notify((Throwable)unsupportedFlavorException);
                    return new PasteType[0];
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return new PasteType[0];
                }
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (this.isPackageFlavor(dataFlavorArray)) {
                return new PasteType[0];
            }
            return super.getPasteTypes(transferable);
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    boolean bl = false;
                    for (int i = 0; i < multiTransferObject.getCount(); ++i) {
                        DataFlavor[] dataFlavorArray = multiTransferObject.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(dataFlavorArray)) continue;
                        bl = true;
                    }
                    return bl ? null : super.getDropType(transferable, n, n2);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    ErrorManager.getDefault().notify((Throwable)unsupportedFlavorException);
                    return null;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return null;
                }
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (this.isPackageFlavor(dataFlavorArray)) {
                return null;
            }
            return super.getDropType(transferable, n, n2);
        }

        private boolean isPackageFlavor(DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!PackageViewChildren.SUBTYPE.equals(dataFlavorArray[i].getSubType()) || !PackageViewChildren.PRIMARY_TYPE.equals(dataFlavorArray[i].getPrimaryType())) continue;
                return true;
            }
            return false;
        }

        private synchronized PackageRenameHandler getRenameHandler() {
            Collection collection = Lookup.getDefault().lookupAll(PackageRenameHandler.class);
            if (collection.size() == 0) {
                return null;
            }
            if (collection.size() > 1) {
                ErrorManager.getDefault().log(16, "Multiple instances of PackageRenameHandler found in Lookup; only using first one: " + collection);
            }
            return (PackageRenameHandler)collection.iterator().next();
        }

        public void setName(String string) {
            int n;
            int n2;
            PackageRenameHandler packageRenameHandler = this.getRenameHandler();
            if (packageRenameHandler != null) {
                packageRenameHandler.handleRename((Node)this, string);
                return;
            }
            if (this.isDefaultPackage) {
                return;
            }
            String string2 = this.getName();
            if (string2.equals(string)) {
                return;
            }
            if (!this.isValidPackageName(string)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PackageViewChildren.class, (String)"MSG_InvalidPackageName"), 1));
                return;
            }
            string = string.replace('.', '/') + '/';
            string2 = string2.replace('.', '/') + '/';
            for (n2 = 0; n2 < string2.length() && n2 < string.length() && string2.charAt(n2) == string.charAt(n2); ++n2) {
            }
            String string3 = (n = string2.lastIndexOf(47, --n2)) == -1 ? null : string2.substring(0, n);
            String string4 = n + 1 == string.length() ? "" : string.substring(n + 1);
            try {
                FileObject fileObject;
                String string5;
                FileObject fileObject2;
                FileObject fileObject3 = fileObject2 = string3 == null ? this.root : this.root.getFileObject(string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    fileObject = fileObject3.getFileObject(string5);
                    if (fileObject == null) {
                        fileObject = fileObject3.createFolder(string5);
                    }
                    fileObject3 = fileObject;
                }
                string5 = this.dataFolder.getPrimaryFile();
                fileObject = DataFolder.findFolder((FileObject)string5);
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject3);
                DataObject[] dataObjectArray = fileObject.getChildren();
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    if (!dataObjectArray[i].getPrimaryFile().isData()) continue;
                    dataObjectArray[i].move(dataFolder);
                }
                while (!fileObject2.equals(string5) && string5.getChildren().length == 0) {
                    String string6 = string5;
                    string5 = string5.getParent();
                    string6.delete();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public boolean canDestroy() {
            return !this.isDefaultPackage;
        }

        public void destroy() throws IOException {
            FileObject fileObject = this.dataFolder.getPrimaryFile().getParent();
            DataObject[] dataObjectArray = this.dataFolder.getChildren();
            boolean bl = true;
            for (int i = 0; dataObjectArray != null && i < dataObjectArray.length; ++i) {
                if (!dataObjectArray[i].getPrimaryFile().isFolder()) {
                    dataObjectArray[i].delete();
                    continue;
                }
                bl = false;
            }
            if (bl) {
                super.destroy();
            }
            while (!fileObject.equals(this.root) && fileObject.getChildren().length == 0) {
                FileObject fileObject2 = fileObject.getParent();
                fileObject.delete();
                fileObject = fileObject2;
            }
        }

        public String getHtmlDisplayName() {
            Object object = this.getDisplayName();
            try {
                FileObject fileObject = this.dataFolder.getPrimaryFile();
                NonRecursiveFolderSet nonRecursiveFolderSet = new NonRecursiveFolderSet(fileObject);
                FileSystem.Status status = fileObject.getFileSystem().getStatus();
                object = status instanceof FileSystem.HtmlStatus ? ((FileSystem.HtmlStatus)status).annotateNameHtml((String)object, (Set)nonRecursiveFolderSet) : (((String)object).startsWith("<") ? null : status.annotateName((String)object, (Set)nonRecursiveFolderSet));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return object;
        }

        public String getDisplayName() {
            FileObject fileObject = this.dataFolder.getPrimaryFile();
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            if (string == null) {
                return "";
            }
            return PackageDisplayUtils.getDisplayLabel(string.replace('/', '.'));
        }

        public String getShortDescription() {
            FileObject fileObject = this.dataFolder.getPrimaryFile();
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            if (string == null) {
                return "";
            }
            return PackageDisplayUtils.getToolTip(fileObject, string.replace('/', '.'));
        }

        public Image getIcon(int n) {
            Image image = this.getMyIcon(n);
            try {
                FileObject fileObject = this.dataFolder.getPrimaryFile();
                NonRecursiveFolderSet nonRecursiveFolderSet = new NonRecursiveFolderSet(fileObject);
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, (Set)nonRecursiveFolderSet);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = this.getMyOpenedIcon(n);
            try {
                FileObject fileObject = this.dataFolder.getPrimaryFile();
                NonRecursiveFolderSet nonRecursiveFolderSet = new NonRecursiveFolderSet(fileObject);
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, (Set)nonRecursiveFolderSet);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return image;
        }

        private Image getMyIcon(int n) {
            FileObject fileObject = this.dataFolder.getPrimaryFile();
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            if (string == null) {
                return ImageUtilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/package.gif");
            }
            return PackageDisplayUtils.getIcon(fileObject, string.replace('/', '.'), this.isLeaf());
        }

        private Image getMyOpenedIcon(int n) {
            return this.getMyIcon(n);
        }

        public void update() {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public void updateDisplayName() {
            this.fireNameChange(null, null);
            this.fireDisplayNameChange(null, null);
            this.fireShortDescriptionChange(null, null);
        }

        public void updateChildren() {
            DataFolder dataFolder;
            boolean bl;
            boolean bl2 = this.isLeaf();
            if (bl2 != (bl = PackageViewChildren.isEmpty(dataFolder = this.getDataFolder()))) {
                this.setChildren(bl ? FilterNode.Children.LEAF : dataFolder.createNodeChildren(PackageViewChildren.this.NO_FOLDERS_FILTER));
                this.update();
            }
        }

        public Node.PropertySet[] getPropertySets() {
            Node.PropertySet[] propertySetArray = super.getPropertySets();
            for (int i = 0; i < propertySetArray.length; ++i) {
                if (!"properties".equals(propertySetArray[i].getName())) continue;
                propertySetArray[i] = Sheet.createPropertiesSet();
                ((Sheet.Set)propertySetArray[i]).put((Node.Property)new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getMessage(PackageViewChildren.class, (String)"PROP_name"), NbBundle.getMessage(PackageViewChildren.class, (String)"HINT_name")){

                    public String getValue() {
                        return PackageNode.this.getName();
                    }

                    public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        if (!PackageNode.this.canRename()) {
                            throw new IllegalAccessException();
                        }
                        PackageNode.this.setName(string);
                    }

                    public boolean canWrite() {
                        return PackageNode.this.canRename();
                    }
                });
            }
            return propertySetArray;
        }

        private DataFolder getDataFolder() {
            return (DataFolder)this.getCookie(DataFolder.class);
        }

        private boolean isValidPackageName(String string) {
            if (string.length() == 0) {
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!bl) {
                    if (string2.equals(".")) {
                        return false;
                    }
                    for (int i = 0; i < string2.length(); ++i) {
                        char c = string2.charAt(i);
                        if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
                        return false;
                    }
                } else if (!string2.equals(".")) {
                    return false;
                }
                bl = !bl;
            }
            return bl;
        }
    }
}

